/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;

public class ByteBufferInputStream
extends InputStream {
    ByteBuffer buf;
    private FileChannel channel;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBufferInputStream(RandomAccessFile raf) throws IOException {
        this.channel = raf.getChannel();
        this.buf = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, 8192L);
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            ByteBufferInputStream.$$$reportNull$$$0(0);
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/prosc/io/ByteBufferInputStream", "read"));
    }
}

