/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.shared.ReflectionUtils;
import com.prosc.shared.StringUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    private static final Logger log = Logger.getLogger(ClassUtils.class.getName());

    public static URL urlForClass(Class whichClass) throws ClassNotFoundException {
        String className = whichClass.getName();
        URL result = null;
        try {
            URLClassLoader loader = (URLClassLoader)whichClass.getClassLoader();
            if (loader == null) {
                throw new ClassNotFoundException("Could not locate URL, because this class is loaded by the bootstrap loader");
            }
            URL[] urls = loader.getURLs();
            for (int n = 0; n < urls.length && result == null; ++n) {
                URL eachURL = urls[n];
                try {
                    new URLClassLoader(new URL[]{eachURL}, null).loadClass(className);
                    result = eachURL;
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    result = eachURL;
                }
            }
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException("Could not locate URL, because this class was not loaded by a URLClassLoader");
        }
        return result;
    }

    public static String dumpAllClassPaths(@Nullable ClassLoader loader) {
        StringBuilder jarsList = new StringBuilder();
        String loaderDelim = "";
        while (loader != null) {
            jarsList.append(loaderDelim);
            loaderDelim = StringUtils.CR;
            Class<?> loaderClass = loader.getClass();
            String loaderName = loaderClass.getName();
            jarsList.append("=== ClassLoader " + loaderName + " ===" + StringUtils.CR);
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            try {
                if (loader instanceof URLClassLoader) {
                    urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
                    try {
                        List jarLoaders = (List)ReflectionUtils.getFieldValue(loader, "ucp", "loaders");
                        ArrayList<URL> jarLoaderUrls = new ArrayList<URL>(jarLoaders.size());
                        for (Object jarLoader : jarLoaders) {
                            URL loaderUrl;
                            if (jarLoader.getClass().getName().contains("URLClassPath$JarLoader")) {
                                loaderUrl = (URL)ReflectionUtils.getFieldValue(jarLoader, "csu");
                                jarLoaderUrls.add(loaderUrl);
                                continue;
                            }
                            if (!jarLoader.getClass().getName().contains("URLClassPath$FileLoader")) continue;
                            loaderUrl = (URL)ReflectionUtils.getFieldValue(jarLoader, "base");
                            jarLoaderUrls.add(loaderUrl);
                        }
                        urls.addAll(jarLoaderUrls);
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Could not retrieve JarLoader URLs", t);
                    }
                } else if (loader.getClass().getName().contains("AntClassLoader")) {
                    String classpathString = (String)ReflectionUtils.getMethodResult(loader, "getClasspath", new Object[0]);
                    String[] classpathElements = classpathString.split(System.getProperty("path.separator"));
                    for (String classpathElement : classpathElements) {
                        urls.add(new File(classpathElement).toURL());
                    }
                } else {
                    urls = null;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not generate classpath listing for classloader " + loader, e);
                urls = null;
            }
            if (urls == null) {
                jarsList.append("Could not get classpath for class " + loaderName);
            } else {
                String delim = "";
                for (URL url : urls) {
                    jarsList.append(delim).append(url.toExternalForm());
                    delim = StringUtils.CR;
                }
            }
            loader = loader.getParent();
        }
        return jarsList.toString();
    }

    public static void main(String[] args) throws ClassNotFoundException {
        if (args.length == 0) {
            System.err.println("Usage: ClassUtils fully.qualified.class.Name");
            return;
        }
        System.out.println(ClassUtils.urlForClass(Class.forName(args[0])));
    }
}

