[Setup]
PrivilegesRequired=admin
DisableDirPage=yes
AppName=MirrorSync
AppVersion=3.0
DefaultDirName="{sd}\Program Files\360Works\"
DefaultGroupName=360Works
Uninstallable=no
DisableWelcomePage=yes
OutputBaseFilename=UninstallMirrorsync

[Run]
Filename: "{app}\Internal\Uninstaller Data\installer.jar"; Parameters: {code:InstallerType}; Flags: shellexec waituntilterminated


[Code]
var
  Page: TInputOptionWizardPage;
  InstallType: String;

function InstallerType(DefaultString: String): String;
begin
  Result := InstallType;
end;


procedure CreateInputsPage;
begin
  Page := CreateInputOptionPage(wpWelcome,
  'MirrorSync Setup', 'Uninstallation Type',
  'Please choose the uninstall method that suits your needs.',
  True, False);

// Add items
Page.Add('Standard Uninstall');
Page.Add('Uninstall a specific instance (for hosting providers)');

// Set initial values (optional)
Page.Values[0] := True;
Page.Values[1] := False;


end;

procedure InitializeWizard();
var
  BackgroundBitmapImage: TBitmapImage;
begin
  { Custom wizard pages }

  CreateInputsPage;
  
  { Custom controls }

  BackgroundBitmapImage := TBitmapImage.Create(MainForm);
  BackgroundBitmapImage.Left := 50;
  BackgroundBitmapImage.Top := 90;
  BackgroundBitmapImage.AutoSize := True;
  BackgroundBitmapImage.Bitmap := WizardForm.WizardBitmapImage.Bitmap;
  BackgroundBitmapImage.Parent := MainForm;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
begin
  if CurPageID = 100 THEN
  begin
    InstallType := 'hostuninstall';
    if Page.Values[0] = True then
    begin
      InstallType := 'uninstall';
    end;
  end;
  Result := True;
end;

