/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.exception.UserCanceledException;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.swingworker.SwingWorker;

public class SwingWaiter<E> {
    private static final Logger log = Logger.getLogger(SwingWaiter.class.getName());
    private final SwingWorker<E, ?> worker;
    private final JDialog dialog;
    private final JProgressBar progressBar;
    private final JLabel jlabel;
    private final boolean determinate;
    private long millisBeforeDialog;

    public SwingWaiter(SwingWorker<E, ?> worker, Component parentComponent, String dialogMessage, String dialogTitle) {
        this(worker, parentComponent, dialogMessage, dialogTitle, false);
    }

    public SwingWaiter(SwingWorker<E, ?> worker, Component parentComponent, String dialogMessage, String dialogTitle, boolean determinate) {
        this.worker = worker;
        this.millisBeforeDialog = 500L;
        this.determinate = determinate;
        this.progressBar = new JProgressBar();
        if (determinate) {
            this.progressBar.setMaximum(100);
        }
        JComponent[] jComponentArray = new JComponent[2];
        this.jlabel = new JLabel(dialogMessage);
        jComponentArray[0] = this.jlabel;
        jComponentArray[1] = this.progressBar;
        JComponent[] message = jComponentArray;
        Object[] options = new Object[]{"Cancel"};
        log.info("SwingWaiter parentComponent is " + parentComponent);
        this.dialog = new JOptionPane(message, 1, 0, null, options).createDialog(parentComponent, dialogTitle);
        this.dialog.setDefaultCloseOperation(2);
        this.installPropertyChangeListenerOnWorker(worker, this.dialog);
        log.log(Level.FINE, "Creating SwingWorker \"" + dialogMessage + "\", title: " + dialogTitle);
    }

    public SwingWaiter(SwingWorker<E, ?> worker, JDialog dialog, long millisBeforeDialog) {
        if (!dialog.isModal()) {
            throw new IllegalArgumentException("dialog must be modal");
        }
        this.worker = worker;
        this.progressBar = null;
        this.determinate = false;
        this.dialog = dialog;
        this.jlabel = null;
        this.millisBeforeDialog = millisBeforeDialog;
        this.installPropertyChangeListenerOnWorker(worker, dialog);
    }

    public void setMillisBeforeDialog(long millisBeforeDialog) {
        this.millisBeforeDialog = millisBeforeDialog;
    }

    private void installPropertyChangeListenerOnWorker(SwingWorker<E, ?> worker, final JDialog dialog) {
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                log.fine("Property change event: " + event);
                if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                } else if ("progress".equals(event.getPropertyName())) {
                    if (SwingWaiter.this.progressBar != null) {
                        SwingWaiter.this.progressBar.setValue((Integer)event.getNewValue());
                    }
                } else if ("message".equals(event.getPropertyName())) {
                    if (SwingWaiter.this.jlabel != null) {
                        SwingWaiter.this.jlabel.setText((String)event.getNewValue());
                        if (dialog.getPreferredSize().width > dialog.getSize().width) {
                            dialog.pack();
                        }
                    }
                } else if ("title".equals(event.getPropertyName())) {
                    dialog.setTitle((String)event.getNewValue());
                }
            }
        });
    }

    public E execute() throws ExecutionException, UserCanceledException {
        this.executeNoResult();
        try {
            return this.worker.get();
        }
        catch (InterruptedException e) {
            throw new UserCanceledException();
        }
        catch (ExecutionException e) {
            EventQueue.invokeLater(this.dialog::dispose);
            throw e;
        }
    }

    public void executeNoResult() throws UserCanceledException {
        if (!SwingUtilities.isEventDispatchThread()) {
            log.log(Level.INFO, "We are already in a background thread. Presumably, we are running within another SwingWaiter. Instead of starting another one, just execute the worker immediately");
            this.worker.run();
            return;
        }
        this.worker.execute();
        long sleepUntil = System.currentTimeMillis() + this.millisBeforeDialog;
        while (System.currentTimeMillis() < sleepUntil && !this.worker.isDone() && !this.worker.isCancelled()) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                throw new UserCanceledException();
            }
        }
        if (!this.worker.isDone() && !this.worker.isCancelled()) {
            if (!this.determinate && this.progressBar != null) {
                this.progressBar.setIndeterminate(true);
            }
            this.dialog.setVisible(true);
        } else {
            this.dialog.dispose();
        }
        if (!this.worker.isDone() && this.worker.cancel(true)) {
            throw new UserCanceledException();
        }
    }
}

