/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import com.prosc.swing.DraggableGlassPanel;
import com.prosc.swing.SmoothDragTransferHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;

public class DraggableJListFactory {
    public static void apply(final JList list) {
        list.setDragEnabled(false);
        if (list.isDisplayable()) {
            DraggableJListFactory._apply(list);
        } else {
            list.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) > 0L) {
                        DraggableJListFactory._apply(list);
                    }
                }
            });
        }
    }

    private static void _apply(final JList list) {
        if (list.isDisplayable()) {
            final JFrame frame = (JFrame)JOptionPane.getFrameForComponent(list);
            DraggableGlassPanel glassPane = new DraggableGlassPanel(frame);
            frame.setGlassPane(glassPane);
            list.addMouseListener(new MouseAdapter(){
                Transferable t;

                @Override
                public void mousePressed(MouseEvent e) {
                    AWTEventListener al = (AWTEventListener)((Object)frame.getGlassPane());
                    Toolkit.getDefaultToolkit().addAWTEventListener(al, 48L);
                    DraggableGlassPanel draggablePanel = (DraggableGlassPanel)frame.getGlassPane();
                    draggablePanel.setInitialMouseEvent(e);
                    draggablePanel.setVisible(true);
                    draggablePanel.setRectWidth(list.getWidth());
                    TransferHandler handler = list.getTransferHandler();
                    if (handler instanceof SmoothDragTransferHandler) {
                        this.t = ((SmoothDragTransferHandler)handler).publicCreateTransferable(list);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    DraggableGlassPanel draggablePanel = (DraggableGlassPanel)frame.getGlassPane();
                    draggablePanel.setVisible(false);
                    TransferHandler handler = list.getTransferHandler();
                    if (handler instanceof SmoothDragTransferHandler) {
                        ((SmoothDragTransferHandler)handler).importData(this.t, e.getPoint());
                    }
                }
            });
        }
    }
}

