/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class CompoundTableModel
extends AbstractTableModel {
    private TranslatedColumn[] translatedColumns;
    private TableModel firstDelegate;

    public CompoundTableModel(TableModel delegate) {
        this.firstDelegate = delegate;
        this.translatedColumns = new TranslatedColumn[delegate.getColumnCount()];
        for (int n = 0; n < delegate.getColumnCount(); ++n) {
            this.translatedColumns[n] = new TranslatedColumn(delegate, n);
        }
    }

    public void addModel(TableModel model, int targetColumn) {
        TranslatedColumn[] newColumns = new TranslatedColumn[this.translatedColumns.length + model.getColumnCount()];
        if (targetColumn > 0) {
            System.arraycopy(this.translatedColumns, 0, newColumns, 0, targetColumn);
        }
        if (targetColumn <= this.translatedColumns.length) {
            System.arraycopy(this.translatedColumns, targetColumn, newColumns, targetColumn + model.getColumnCount(), this.translatedColumns.length - targetColumn);
        }
        for (int n = 0; n < model.getColumnCount(); ++n) {
            newColumns[n + targetColumn] = new TranslatedColumn(model, n);
        }
        this.translatedColumns = newColumns;
    }

    private TranslatedColumn translateColumn(int columnIndex) {
        return this.translatedColumns[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.firstDelegate.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.translatedColumns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TranslatedColumn translated = this.translateColumn(columnIndex);
        return translated.whichDelegate.getValueAt(rowIndex, translated.delegateColumn);
    }

    @Override
    public String getColumnName(int columnIndex) {
        TranslatedColumn translated = this.translateColumn(columnIndex);
        return translated.whichDelegate.getColumnName(translated.delegateColumn);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        TranslatedColumn translated = this.translateColumn(columnIndex);
        return translated.whichDelegate.getColumnClass(translated.delegateColumn);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        TranslatedColumn translated = this.translateColumn(columnIndex);
        return translated.whichDelegate.isCellEditable(rowIndex, translated.delegateColumn);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TranslatedColumn translated = this.translateColumn(columnIndex);
        translated.whichDelegate.setValueAt(aValue, rowIndex, translated.delegateColumn);
    }

    private class TranslatedColumn {
        private TableModel whichDelegate;
        private int delegateColumn;

        private TranslatedColumn(TableModel whichDelegate, int delegateColumn) {
            this.whichDelegate = whichDelegate;
            this.delegateColumn = delegateColumn;
        }
    }
}

