/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    CheckBoxTree selfPointer = this;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();
    protected EventListenerList listenerList = new EventListenerList();

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.resetCheckingState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isSelectedPartially(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected && cn.hasChildren && !cn.allChildrenSelected;
    }

    private void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        TreeNode node = (TreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node);
    }

    private void addSubtreeToCheckingStateTracking(TreeNode node) {
        Object[] path = this.pathFor(node);
        TreePath tp = new TreePath(path);
        CheckedNode cn = new CheckedNode(false, node.getChildCount() > 0, false);
        this.nodesCheckingState.put(tp, cn);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((TreeNode)tp.pathByAddingChild(node.getChildAt(i)).getLastPathComponent());
        }
    }

    private TreeNode[] pathFor(TreeNode node) {
        return this.getPathToRoot(node, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public CheckBoxTree() {
        this(new DefaultMutableTreeNode());
    }

    public CheckBoxTree(TreeNode root) {
        super(root);
        this.setLargeModel(true);
        this.setToggleClickCount(0);
        CheckBoxCellRenderer cellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){
            TreePath clickedPath = null;

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                this.clickedPath = CheckBoxTree.this.selfPointer.getPathForLocation(arg0.getX(), arg0.getY());
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (this.clickedPath != null && CheckBoxTree.this.isEnabled()) {
                    TreePath tp = CheckBoxTree.this.selfPointer.getPathForLocation(arg0.getX(), arg0.getY());
                    if (tp == null || !tp.equals(this.clickedPath)) {
                        return;
                    }
                    boolean checkMode = !CheckBoxTree.this.nodesCheckingState.get((Object)tp).isSelected;
                    CheckBoxTree.this.checkSubTree(tp, checkMode);
                    CheckBoxTree.this.updatePredecessorsWithCheckMode(tp, checkMode);
                    CheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(tp, checkMode));
                    CheckBoxTree.this.selfPointer.repaint();
                }
                this.clickedPath = null;
            }
        });
        this.setSelectionModel(dtsm);
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp, boolean check) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = this.nodesCheckingState.get(parentPath);
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        parentCheckedNode.allChildrenSelected = true;
        parentCheckedNode.isSelected = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = this.nodesCheckingState.get(childPath);
            if (!childCheckedNode.allChildrenSelected) {
                parentCheckedNode.allChildrenSelected = false;
            }
            if (!childCheckedNode.isSelected) continue;
            parentCheckedNode.isSelected = true;
        }
        if (parentCheckedNode.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessorsWithCheckMode(parentPath, check);
    }

    public void checkSubTree(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        cn.isSelected = check;
        TreeNode node = (TreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
        cn.allChildrenSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
    }

    public static class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            HashMap<TreePath, CheckedNode> nodesCheckingState = ((CheckBoxTree)tree).nodesCheckingState;
            TreePath tp = tree.getPathForRow(row);
            CheckedNode cn = nodesCheckingState.get(tp);
            if (cn == null) {
                cn = new CheckedNode(false, false, false);
            }
            this.checkBox.setEnabled(tree.isEnabled());
            this.checkBox.setSelected(cn.isSelected);
            this.setText(tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus));
            this.checkBox.setOpaque(cn.isSelected && cn.hasChildren && !cn.allChildrenSelected);
            return this;
        }

        public void setText(String s) {
            this.checkBox.setText(s);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = this.checkBox.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 33, retDimension.height);
            }
            return retDimension;
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;
        private final boolean checked;

        public CheckChangeEvent(TreePath source, boolean checkMode) {
            super(source);
            this.checked = checkMode;
        }

        @Override
        public TreePath getSource() {
            return (TreePath)super.getSource();
        }

        public boolean isChecked() {
            return this.checked;
        }
    }

    private static class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;

        public CheckedNode(boolean isSelected_, boolean hasChildren_, boolean allChildrenSelected_) {
            this.isSelected = isSelected_;
            this.hasChildren = hasChildren_;
            this.allChildrenSelected = allChildrenSelected_;
        }
    }
}

