/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.servlet.admin;

import com.prosc.Platform;
import com.prosc.deployment.DeploymentInfo;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.LogUtils;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import com.prosc.servlet.admin.AppInfo;
import com.prosc.servlet.admin.ApplicationException;
import com.prosc.servlet.admin.DaemonUtils;
import com.prosc.servlet.admin.RemoteDaemon;
import com.prosc.servlet.admin.TomcatStoppedException;
import com.prosc.shared.DebugTimer;
import com.prosc.shared.ExceptionUtils;
import com.prosc.shared.LaunchBrowser;
import com.prosc.swing.ActionListenerThrowable;
import com.prosc.swing.ListModelWrapper;
import com.prosc.swing.SwingWaiter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingworker.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AdminFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(AdminFrame.class.getName());
    private final RemoteDaemon daemon;
    private TomcatStates currentTomcatState = TomcatStates.unknown;
    private States currentState;
    private AppInfo selectedApp;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JLabel currentTomcatStateLabel;
    private JButton startStopButton;
    private JButton refreshButton;
    private JScrollPane scrollPane1;
    private JList appsList;
    private JButton startButton;
    private JButton stopButton;
    private JButton gotoAppButton;
    private JButton removeButton;
    private JLabel statusLabel;

    AdminFrame(RemoteDaemon daemon) throws RemoteException, ApplicationException, UserCanceledException, InterruptedException {
        this.daemon = daemon;
        this.initComponents();
    }

    private void createUIComponents() {
        this.appsList = new JList(){

            @Override
            public String getToolTipText(MouseEvent event) {
                AppInfo selection = (AppInfo)AdminFrame.this.appsList.getSelectedValue();
                if (selection != null) {
                    return selection.warningMessage;
                }
                return null;
            }
        };
    }

    private void refreshButtonActionPerformed() {
        try {
            this.refreshApplications();
        }
        catch (Exception e) {
            ExceptionUtils.reportAndLogException(Level.WARNING, this, "Could not refresh application list", e);
        }
    }

    private void refreshApplications() throws UserCanceledException, InterruptedException {
        SwingWorker<Map<String, AppInfo>, Void> updateAllApps = new SwingWorker<Map<String, AppInfo>, Void>(){

            @Override
            protected Map<String, AppInfo> doInBackground() throws Exception {
                try {
                    log.info("Requesting list of applications from daemon...");
                    Map<String, AppInfo> appInfoMap = AdminFrame.this.daemon.getApplications(true);
                    log.info("Retrieved list of applications");
                    AdminFrame.this.currentTomcatState = TomcatStates.running;
                    return appInfoMap;
                }
                catch (TomcatStoppedException e) {
                    AdminFrame.this.currentTomcatState = TomcatStates.stopped;
                    return Collections.emptyMap();
                }
            }

            @Override
            protected void done() {
                try {
                    AdminFrame.this.updateUI((Map)this.get());
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.log(Level.WARNING, "Task was interrupted");
                }
                catch (ExecutionException e1) {
                    ExceptionUtils.reportAndLogException(Level.WARNING, AdminFrame.this, "Could not communicate with 360Works Tomcat daemon to get list of running applications: " + e1.getCause().getMessage(), e1.getCause());
                }
            }
        };
        new SwingWaiter<Map<String, AppInfo>>(updateAllApps, this, "Updating list of applications...", null).executeNoResult();
    }

    private void initComponents() throws RemoteException, ApplicationException, UserCanceledException, InterruptedException {
        this.createUIComponents();
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.currentTomcatStateLabel = new JLabel();
        this.startStopButton = new JButton();
        this.refreshButton = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.gotoAppButton = new JButton();
        this.removeButton = new JButton();
        this.statusLabel = new JLabel();
        this.setTitle("360Works Admin");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{1.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.panel1.setLayout(new FlowLayout());
        this.currentTomcatStateLabel.setText("Status is updating...");
        this.panel1.add(this.currentTomcatStateLabel);
        this.startStopButton.setText("Start");
        this.panel1.add(this.startStopButton);
        this.contentPanel.add((Component)this.panel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.refreshButton.setText("Refresh application list");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminFrame.this.refreshButtonActionPerformed();
            }
        });
        this.contentPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.appsList.setSelectionMode(0);
        this.scrollPane1.setViewportView(this.appsList);
        this.contentPanel.add((Component)this.scrollPane1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.startButton.setText("Start");
        this.contentPanel.add((Component)this.startButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.stopButton.setText("Stop");
        this.contentPanel.add((Component)this.stopButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.gotoAppButton.setText("Go to application");
        this.contentPanel.add((Component)this.gotoAppButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.removeButton.setText("Remove");
        this.contentPanel.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
        this.contentPanel.add((Component)this.statusLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setDefaultCloseOperation(3);
        this.currentTomcatStateLabel.setText(this.currentTomcatState.message);
        this.appsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AdminFrame.this.selectedApp = (AppInfo)AdminFrame.this.appsList.getSelectedValue();
                AdminFrame.this.updateUI();
            }
        });
        this.appsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result;
                AppInfo app = (AppInfo)value;
                String display = app.name;
                DeploymentInfo deploymentInfo = app.deploymentInfo;
                if (deploymentInfo != null) {
                    display = display + " version " + deploymentInfo.getVersion();
                }
                if (app.status == AppInfo.Status.running) {
                    display = display + " (" + app.sessionCount + " sessions)";
                    result = super.getListCellRendererComponent((JList<?>)list, display, index, isSelected, cellHasFocus);
                    if (isSelected) {
                        result.setForeground(Color.GREEN);
                    } else {
                        result.setForeground(new Color(0, 128, 0));
                    }
                    Font boldFont = result.getFont().deriveFont(1);
                    result.setFont(boldFont);
                } else if (app.status == AppInfo.Status.error) {
                    display = display + " (" + app.warningMessage + ")";
                    result = super.getListCellRendererComponent((JList<?>)list, display, index, isSelected, cellHasFocus);
                    result.setForeground(Color.RED);
                } else {
                    display = display + " (stopped)";
                    result = super.getListCellRendererComponent((JList<?>)list, display, index, isSelected, cellHasFocus);
                    result.setForeground(Color.DARK_GRAY);
                }
                return result;
            }
        });
        this.startButton.addActionListener(new ActionListenerThrowable(){

            @Override
            public void actionPerformedThrowable(ActionEvent e) throws Exception {
                AdminFrame.this.currentState = States.starting;
                AdminFrame.this.updateUI();
                SwingWorker<AppInfo, Void> worker = new SwingWorker<AppInfo, Void>(){

                    @Override
                    protected AppInfo doInBackground() throws Exception {
                        log.info("Asking daemon to start " + ((AdminFrame)AdminFrame.this).selectedApp.name);
                        return AdminFrame.this.daemon.startApplication(((AdminFrame)AdminFrame.this).selectedApp.name);
                    }

                    @Override
                    protected void done() {
                        AdminFrame.this.currentState = States.stopped;
                        try {
                            AdminFrame.this.updateUI((AppInfo)this.get());
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            log.log(Level.WARNING, "Task was interrupted");
                        }
                        catch (ExecutionException e1) {
                            ExceptionUtils.reportAndLogException(Level.WARNING, AdminFrame.this, "Could not communicate with 360Works Tomcat daemon to get list of running applications: " + e1.getCause().getMessage(), e1.getCause());
                        }
                    }
                };
                new SwingWaiter<AppInfo>(worker, AdminFrame.this, "Starting application " + ((AdminFrame)AdminFrame.this).selectedApp.name + "...", null, false).executeNoResult();
            }
        });
        this.stopButton.addActionListener(new ActionListenerThrowable(){

            @Override
            public void actionPerformedThrowable(ActionEvent e) throws Exception {
                AdminFrame.this.currentState = States.stopping;
                AdminFrame.this.updateUI();
                SwingWorker<AppInfo, Void> worker = new SwingWorker<AppInfo, Void>(){

                    @Override
                    protected AppInfo doInBackground() throws Exception {
                        log.info("Asking daemon to stop " + ((AdminFrame)AdminFrame.this).selectedApp.name);
                        return AdminFrame.this.daemon.stopApplication(((AdminFrame)AdminFrame.this).selectedApp.name);
                    }

                    @Override
                    protected void done() {
                        AdminFrame.this.currentState = States.started;
                        try {
                            AdminFrame.this.updateUI((AppInfo)this.get());
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            log.log(Level.WARNING, "Task was interrupted");
                        }
                        catch (ExecutionException e1) {
                            ExceptionUtils.reportAndLogException(Level.WARNING, AdminFrame.this, e1.getCause().getMessage(), e1.getCause());
                        }
                    }
                };
                new SwingWaiter<AppInfo>(worker, AdminFrame.this, "Stopping application \u2206" + ((AdminFrame)AdminFrame.this).selectedApp.name + "...", null, false).executeNoResult();
            }
        });
        this.gotoAppButton.addActionListener(new ActionListenerThrowable(){

            @Override
            public void actionPerformedThrowable(ActionEvent e) throws Exception {
                new LaunchBrowser().launch(((AdminFrame)AdminFrame.this).selectedApp.url);
            }
        });
        this.removeButton.addActionListener(new ActionListenerThrowable(){

            @Override
            public void actionPerformedThrowable(ActionEvent e) throws Exception {
                boolean removingLastApp = AdminFrame.this.appsList.getModel().getSize() == 1;
                String message = removingLastApp ? "This will uninstall the 360Works Tomcat Service. You will need to run the installer to get it back. Do you wish to proceed?" : "This will uninstall the selected application. You will need to run the installer to get it back. Do you wish to proceed?";
                if (JOptionPane.showConfirmDialog(AdminFrame.this, message, "Confirm uninstall", 0) == 0) {
                    SwingWorker<Map<String, AppInfo>, Void> undeployApp = new SwingWorker<Map<String, AppInfo>, Void>(){

                        @Override
                        protected Map<String, AppInfo> doInBackground() throws Exception {
                            boolean lastAppRemoved = AdminFrame.this.daemon.undeployApplication(((AdminFrame)AdminFrame.this).selectedApp.name, true);
                            if (lastAppRemoved) {
                                AdminFrame.this.removeDaemonAndAdminApplication(AdminFrame.this.daemon, true, new DebugTimer("Remove Daemon And Admin Application"));
                                AdminFrame.this.currentTomcatState = TomcatStates.stopped;
                                return new HashMap<String, AppInfo>();
                            }
                            return AdminFrame.this.daemon.getApplications(true);
                        }

                        @Override
                        protected void done() {
                            try {
                                AdminFrame.this.updateUI((Map)this.get());
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                log.log(Level.WARNING, "Task was interrupted");
                            }
                            catch (ExecutionException e1) {
                                ExceptionUtils.reportAndLogException(Level.WARNING, AdminFrame.this, "Could not communicate with 360Works Tomcat daemon to get list of running applications: " + e1.getCause().getMessage(), e1.getCause());
                            }
                        }
                    };
                    String message1 = !removingLastApp ? "Removing application " + ((AdminFrame)AdminFrame.this).selectedApp.name + "..." : "Uninstalling 360Works Tomcat Service...";
                    new SwingWaiter<Map<String, AppInfo>>(undeployApp, AdminFrame.this, message1, null).executeNoResult();
                    if (removingLastApp) {
                        JOptionPane.showConfirmDialog(AdminFrame.this, "360Works Tomcat Service Uninstalled.", "Uninstall Complete", -1);
                        System.exit(0);
                    }
                }
            }
        });
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                if (AdminFrame.this.currentTomcatState == TomcatStates.running && JOptionPane.showConfirmDialog(AdminFrame.this, message = "This will disconnect users from all active applications. Do you wish to proceed?", "Confirm Tomcat restart", 0) != 0) {
                    return;
                }
                try {
                    new SwingWaiter<Map<String, AppInfo>>(new SwingWorker<Map<String, AppInfo>, Void>(){

                        @Override
                        protected Map<String, AppInfo> doInBackground() throws Exception {
                            if (AdminFrame.this.currentTomcatState == TomcatStates.stopped) {
                                Map<String, AppInfo> result;
                                AdminFrame.this.daemon.startTomcat();
                                try {
                                    result = AdminFrame.this.daemon.getApplications(true);
                                }
                                catch (TomcatStoppedException e1) {
                                    AdminFrame.this.daemon.stopTomcat();
                                    AdminFrame.this.daemon.startTomcat();
                                    result = AdminFrame.this.daemon.getApplications(true);
                                }
                                AdminFrame.this.currentTomcatState = TomcatStates.running;
                                AdminFrame.this.updateUI(result);
                                return result;
                            }
                            if (AdminFrame.this.currentTomcatState == TomcatStates.running) {
                                AdminFrame.this.daemon.stopTomcat();
                                AdminFrame.this.currentTomcatState = TomcatStates.stopped;
                                Map<String, AppInfo> result = Collections.emptyMap();
                                AdminFrame.this.updateUI(result);
                                return result;
                            }
                            throw new IllegalStateException("This button should not be clickable; tomcat state is " + (Object)((Object)AdminFrame.this.currentTomcatState));
                        }
                    }, AdminFrame.this, AdminFrame.this.currentTomcatState == TomcatStates.running ? "Stopping 360Works application server" : "Starting 360Works application server", null, false).executeNoResult();
                }
                catch (UserCanceledException e1) {
                    log.log(Level.INFO, "User canceled while stopping/starting Tomcat", e1);
                    AdminFrame.this.updateUI();
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Unexpected exception while stopping/starting Tomcat", t);
                    AdminFrame.this.updateUI();
                }
            }
        });
        this.refreshApplications();
    }

    private void updateUI(@NotNull AppInfo application) {
        if (application == null) {
            AdminFrame.$$$reportNull$$$0(0);
        }
        ListModelWrapper listModel = (ListModelWrapper)this.appsList.getModel();
        ListIterator<AppInfo> it = listModel.listIterator();
        while (it.hasNext()) {
            if (!((AppInfo)it.next()).name.equals(application.name)) continue;
            it.set(application);
            break;
        }
        if (this.selectedApp.name.equals(application.name)) {
            this.selectedApp = application;
        }
        this.appsList.repaint();
        this.updateUI();
    }

    private void updateUI(@Nullable Map<String, AppInfo> applications) {
        if (applications != null) {
            ArrayList<AppInfo> apps = new ArrayList<AppInfo>(applications.size());
            for (AppInfo info : applications.values()) {
                if ("manager".equals(info.name) || "host-manager".equals(info.name)) continue;
                apps.add(info);
            }
            AppInfo previousSelection = (AppInfo)this.appsList.getSelectedValue();
            if (previousSelection != null) {
                previousSelection = applications.get(previousSelection.name);
            }
            this.appsList.setModel(new ListModelWrapper(apps));
            this.appsList.setSelectedValue(previousSelection, true);
            this.appsList.repaint();
        }
        this.updateUI();
    }

    /*
     * Unable to fully structure code
     */
    private void removeDaemonAndAdminApplication(@Nullable RemoteDaemon existingDaemon, boolean removeAdminApplication, DebugTimer dt) throws RemoteException {
        daemonInstallDir = DaemonUtils.get360dir();
        try {
            if (existingDaemon != null) {
                dt.markTime("Calling shutdown() on existing daemon");
                daemonInstallDir = existingDaemon.getInfo().dir360Works;
                existingDaemon.shutdown();
            }
        }
        catch (Throwable e) {
            AdminFrame.log.log(Level.WARNING, "Could not stop existing daemon before deleting; will proceed anyway");
        }
        dir360WorksInternal = new File(daemonInstallDir, "Internal");
        if (Platform.isMac()) {
            dt.markTime("Calling launchctl stop com.prosc.TomcatDaemon");
            tomcatDaemonPlist = new File("/Library/LaunchDaemons/com.prosc.TomcatDaemon.plist");
            if (tomcatDaemonPlist.exists()) {
                try {
                    try {
                        b = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "stop", "com.prosc.TomcatDaemon"}, null, null);
                        AdminFrame.log.info("Stopped launchctl; result: " + new String(b, "utf-8"));
                    }
                    catch (ProcessExecutionException e) {
                        AdminFrame.log.info("Did not stop com.prosc.TomcatDaemon; it is probably already stopped: " + e.getMessage());
                    }
                    dt.markTime("Calling launchctl unload com.prosc.TomcatDaemon");
                    try {
                        b = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "unload", tomcatDaemonPlist.getAbsolutePath()}, null, null);
                        AdminFrame.log.info("Unloaded launchctl; result: " + new String(b, "utf-8"));
                    }
                    catch (ProcessExecutionException e) {
                        AdminFrame.log.info("Did not unload " + tomcatDaemonPlist.getAbsolutePath() + "; it is probably already stopped: " + e.getMessage());
                    }
                    if (tomcatDaemonPlist.delete()) ** GOTO lbl46
                    AdminFrame.log.info("Launchctl plist at " + tomcatDaemonPlist + " could not be deleted.");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (UserCanceledException e) {
                    throw new RuntimeException("User canceled installation while waiting for Tomcat daemon to stop and start", e);
                }
            }
        } else {
            dt.markTime("Calling ProscTomcatDaemon.exe to delete service");
            daemonExe = new File(dir360WorksInternal, "ProscTomcatDaemon.exe");
            if (daemonExe.exists()) {
                try {
                    ProcessUtils.doShellCommand(new String[]{daemonExe.getAbsolutePath(), "//DS//360Works"}, null, dir360WorksInternal);
                }
                catch (Exception e) {
                    AdminFrame.log.log(Level.INFO, "The 360Works Windows service could not be removed by the installer: " + e.getMessage(), e);
                }
            }
        }
lbl46:
        // 7 sources

        if (removeAdminApplication) {
            dt.markTime("Removing admin application and ProscTomcatDaemon files");
            new File(dir360WorksInternal, "ProscTomcatDaemon.jar").delete();
            new File(dir360WorksInternal, "ProscTomcatDaemon.exe").delete();
            new File(daemonInstallDir, "360Works Admin.jar").delete();
            if (Platform.isMac()) {
                IOUtils.deleteRecursive(new File("/Applications/360Works Admin.app"));
            } else {
                IOUtils.deleteRecursive(new File(daemonInstallDir, "360Works Admin"));
            }
        }
    }

    private void updateUI() {
        this.currentTomcatStateLabel.setText(this.currentTomcatState.message);
        if (this.currentTomcatState == TomcatStates.stopped) {
            this.startStopButton.setVisible(true);
            this.startStopButton.setText("Start");
            this.refreshButton.setEnabled(false);
        } else if (this.currentTomcatState == TomcatStates.running) {
            this.startStopButton.setVisible(true);
            this.startStopButton.setText("Stop");
            this.refreshButton.setEnabled(true);
        } else {
            this.startStopButton.setVisible(false);
            this.refreshButton.setEnabled(false);
        }
        this.startButton.setEnabled(this.selectedApp != null && this.selectedApp.status == AppInfo.Status.stopped);
        if (this.startButton.isEnabled()) {
            this.currentState = States.stopped;
        }
        this.stopButton.setEnabled(this.selectedApp != null && this.selectedApp.status != AppInfo.Status.stopped);
        if (this.stopButton.isEnabled()) {
            this.currentState = States.started;
        }
        this.gotoAppButton.setEnabled(this.selectedApp != null && this.selectedApp.status != AppInfo.Status.stopped);
        this.removeButton.setEnabled(this.selectedApp != null);
        this.statusLabel.setText(this.currentState == null ? null : this.currentState.message);
    }

    public static void main(String[] args) {
        log.info(LogUtils.getSystemInfo(false, true, true));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                log.info("Started AdminFrame");
                boolean appDidStart = false;
                try {
                    log.info("Establishing RMI connection");
                    Registry registry = LocateRegistry.getRegistry("127.0.0.1", 43434);
                    RemoteDaemon daemon = (RemoteDaemon)registry.lookup("com.prosc.servlet.admin.RemoteDaemon");
                    log.info("Opening new AdminFrame");
                    AdminFrame frame = new AdminFrame(daemon);
                    frame.pack();
                    frame.setVisible(true);
                    appDidStart = true;
                }
                catch (RemoteException e) {
                    ExceptionUtils.reportAndLogException(Level.SEVERE, JOptionPane.getRootFrame(), "Could not connect to 360Works Tomcat Daemon: " + e.toString(), e);
                }
                catch (NotBoundException e) {
                    ExceptionUtils.reportAndLogException(Level.SEVERE, JOptionPane.getRootFrame(), "Could not connect to 360Works Tomcat Daemon: " + e.toString(), e);
                }
                catch (ApplicationException e) {
                    ExceptionUtils.reportAndLogException(Level.SEVERE, JOptionPane.getRootFrame(), "Could not connect to 360Works Tomcat Daemon: " + e.toString(), e);
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Process was interrupted while waiting for initial application list to load");
                }
                catch (UserCanceledException e) {
                    log.log(Level.WARNING, "User canceled while waiting for initial application list to load");
                }
                if (!appDidStart) {
                    System.exit(1);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/prosc/servlet/admin/AdminFrame", "updateUI"));
    }

    private static enum TomcatStates {
        running("360Works application server is running"),
        stopped("360Works application server is stopped"),
        unknown("Checking status of application server...");

        String message;

        private TomcatStates(String message) {
            this.message = message;
        }
    }

    private static enum States {
        stopping("Application is stopping..."),
        stopped("Application is stopped."),
        starting("Application is starting..."),
        started("Application is running.");

        String message;

        private States(String message) {
            this.message = message;
        }
    }
}

