/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HttpClientUtils {
    private static final Logger log;
    private static final SSLSocketFactory noCheckFactory;
    private static final SSLSocketFactory standardFactory;
    private static final HostnameVerifier verifier;

    public static void trustSelfSignedCertificates(HttpsURLConnection connection) {
        connection.setSSLSocketFactory(noCheckFactory);
    }

    public static void trustMismatchedHostname(HttpsURLConnection connection) {
        connection.setHostnameVerifier(verifier);
    }

    public static void trustInvalidCertificates(HttpsURLConnection connection, boolean trustMismatchedHostname, boolean trustSelfSignedCertificates) {
        if (trustSelfSignedCertificates) {
            connection.setSSLSocketFactory(noCheckFactory);
        } else {
            connection.setSSLSocketFactory(standardFactory);
        }
        if (trustMismatchedHostname) {
            connection.setHostnameVerifier(verifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getCertificateHostnames(URL url) throws IOException {
        HttpsURLConnection sslConnection = (HttpsURLConnection)url.openConnection();
        sslConnection.setUseCaches(false);
        HttpClientUtils.trustInvalidCertificates(sslConnection, true, true);
        sslConnection.connect();
        try {
            X509Certificate[] certificates;
            HashSet<String> sslNames = new HashSet<String>();
            sslConnection.getResponseCode();
            for (X509Certificate certificate : certificates = (X509Certificate[])sslConnection.getServerCertificates()) {
                try {
                    Collection<List<?>> alternativeNames = certificate.getSubjectAlternativeNames();
                    if (alternativeNames == null) continue;
                    for (List<?> alternativeNameObjects : alternativeNames) {
                        for (Object object : alternativeNameObjects) {
                            String hostname;
                            if (!(object instanceof String) || !(hostname = (String)object).startsWith("*.") && sslNames.contains("*." + hostname)) continue;
                            sslNames.add(hostname);
                        }
                    }
                }
                catch (CertificateParsingException e) {
                    log.log(Level.WARNING, "Could not parse hostnames from SSL certificate for server " + url, e);
                }
            }
            HashSet<String> hashSet = sslNames;
            return hashSet;
        }
        finally {
            sslConnection.disconnect();
        }
    }

    static {
        SSLSocketFactory _standardFactory;
        SSLContext context;
        log = Logger.getLogger(HttpClientUtils.class.getName());
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            context = SSLContext.getInstance("SSL");
            context.init(null, trustManagers, null);
            _standardFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not create a standard SSL socket factory; will use the default. This will have the side effect that if trustMismatchedHostnames is called for a URL, it will be trusted for all other URLConnections to that same URL.", e);
            _standardFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        standardFactory = _standardFactory;
        try {
            context = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509TrustManager gullible = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            context.init(null, new TrustManager[]{gullible}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        noCheckFactory = context.getSocketFactory();
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }
}

