/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class GlobalCurrencyFormat
extends Format {
    private static final Logger log = Logger.getLogger(GlobalCurrencyFormat.class.getName());
    private Currency currency;
    private Locale locale;
    private static Map<Currency, Locale> map;
    private static List<Locale> locales;
    private NumberFormat embeddedFormat;

    public GlobalCurrencyFormat(Currency currency, Locale locale) {
        this.currency = currency;
        this.locale = locale;
        if (locale == null) {
            DecimalFormat newFormat = new DecimalFormat();
            newFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
            newFormat.setPositivePrefix(currency.getSymbol());
            newFormat.setNegativePrefix(currency.getSymbol() + " -");
        } else {
            this.embeddedFormat = NumberFormat.getCurrencyInstance(locale);
        }
    }

    public GlobalCurrencyFormat(Currency currency) {
        this(currency, map.get(currency));
    }

    @Override
    public StringBuffer format(Object obj, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
        if (toAppendTo == null) {
            GlobalCurrencyFormat.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            GlobalCurrencyFormat.$$$reportNull$$$0(1);
        }
        return this.embeddedFormat.format(obj, toAppendTo, pos);
    }

    @Override
    public Object parseObject(String source, @NotNull ParsePosition pos) {
        if (pos == null) {
            GlobalCurrencyFormat.$$$reportNull$$$0(2);
        }
        return this.embeddedFormat.parseObject(source, pos);
    }

    static {
        locales = Arrays.asList(NumberFormat.getAvailableLocales());
        map = new HashMap<Currency, Locale>(locales.size());
        for (Locale eachLocale : locales) {
            try {
                if (eachLocale.getCountry().length() != 2) continue;
                Currency eachCurrency = Currency.getInstance(eachLocale);
                map.put(eachCurrency, eachLocale);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Got an error trying to get a currency for locale: " + eachLocale, e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAppendTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        objectArray2[1] = "com/prosc/format/GlobalCurrencyFormat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

