/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.shared.Bool;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateRangeFormatter {
    private DateFormat longDateFormatter;
    private DateFormat monthNameFormatter;
    private Calendar cal;
    private static DateRangeFormatter instance = new DateRangeFormatter();
    private DateFormat timeFormatter;

    public DateRangeFormatter() {
        this(DateFormat.getDateInstance(2), new SimpleDateFormat("MMM"));
    }

    private DateRangeFormatter(DateFormat longDateFormatter, DateFormat monthNameFormatter) {
        this(longDateFormatter, monthNameFormatter, null);
    }

    private DateRangeFormatter(DateFormat longDateFormatter, DateFormat monthNameFormatter, DateFormat timeFormatter) {
        this.longDateFormatter = longDateFormatter;
        this.monthNameFormatter = monthNameFormatter;
        this.timeFormatter = timeFormatter;
        this.cal = Calendar.getInstance();
    }

    public String format(Date min, Date max) {
        if (Bool.equals(min, max)) {
            return min == null ? "n/a" : this.longDateFormatter.format(min);
        }
        this.cal.setTime(min);
        int minYear = this.cal.get(1);
        int minMonth = this.cal.get(2);
        int minDay = this.cal.get(5);
        this.cal.setTime(max);
        if (this.cal.get(1) != minYear) {
            return this.longDateFormatter.format(min) + " to " + this.longDateFormatter.format(max);
        }
        if (this.cal.get(2) != minMonth) {
            return this.monthNameFormatter.format(min) + " " + minDay + " to " + this.longDateFormatter.format(max);
        }
        if (this.cal.get(5) != minDay) {
            return this.monthNameFormatter.format(min) + " " + minDay + "-" + this.cal.get(5) + ", " + minYear;
        }
        if (this.timeFormatter == null) {
            return this.longDateFormatter.format(min);
        }
        return this.longDateFormatter.format(min) + " " + this.timeFormatter.format(min) + " to " + this.timeFormatter.format(max);
    }

    public DateFormat getLongDateFormatter() {
        return this.longDateFormatter;
    }

    public void setLongDateFormatter(DateFormat longDateFormatter) {
        this.longDateFormatter = longDateFormatter;
    }

    public DateFormat getMonthNameFormatter() {
        return this.monthNameFormatter;
    }

    public void setMonthNameFormatter(DateFormat monthNameFormatter) {
        this.monthNameFormatter = monthNameFormatter;
    }

    public DateFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    public void setTimeFormatter(DateFormat timeFormatter) {
        this.timeFormatter = timeFormatter;
    }

    public static DateRangeFormatter getInstance() {
        return instance;
    }
}

