/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.xml;

import com.prosc.shared.Bool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class DomUtils {
    private static final Logger log = Logger.getLogger(DomUtils.class.getName());
    public static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public static String getRecursiveChildText(Element xml, String childTag) {
        NodeList nodeList = xml.getElementsByTagName(childTag);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    public static String getChildText(@Nullable Element xml, String childTag) {
        return DomUtils.getChildText(xml, childTag, true);
    }

    public static String getChildText(@Nullable Element xml, String childTag, boolean validateThatRecursiveCallMatches) {
        String recursiveResult;
        String result;
        Iterator<Element> elementsByTagName = DomUtils.getChildElements((Node)xml, childTag).iterator();
        if (elementsByTagName.hasNext()) {
            Element next = elementsByTagName.next();
            result = next.getTextContent();
        } else {
            result = null;
        }
        if (validateThatRecursiveCallMatches && !Bool.equals(result, recursiveResult = DomUtils.getRecursiveChildText(xml, childTag))) {
            log.log(Level.INFO, "Recursive result for child tag '" + childTag + "' is not the same as shallow result. This is not generally a problem, but it could be for legacy classes that assumed that all calls are recursive.\nShallow result: " + result + "\nRecursive result: " + recursiveResult + "\nXML input: " + DomUtils.dumpXml(xml.getOwnerDocument(), xml), new RuntimeException("Stack trace"));
        }
        return result;
    }

    public static Iterable<Element> getChildElements(@Nullable Node parent, String ... childNames) {
        if (parent == null) {
            return Collections.emptyList();
        }
        LinkedList<Element> result = new LinkedList<Element>();
        DomUtils.getChildElements(parent, result, childNames);
        return result;
    }

    private static void getChildElements(@NotNull Node parent, List<Element> result, String ... childName) {
        String[] descendents = null;
        if (childName != null && childName.length > 1) {
            descendents = new String[childName.length - 1];
            System.arraycopy(childName, 1, descendents, 0, descendents.length);
        }
        NodeList nodeList = parent.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node item = nodeList.item(n);
            if (!(item instanceof Element)) continue;
            if (childName == null) {
                result.add((Element)item);
                continue;
            }
            if (!item.getNodeName().equals(childName[0])) continue;
            if (childName.length == 1) {
                result.add((Element)item);
                continue;
            }
            DomUtils.getChildElements(item, result, descendents);
        }
    }

    public static Iterable<Element> getChildElements(@Nullable Node parent) {
        return DomUtils.getChildElements(parent, (String[])null);
    }

    public static String dumpXml(@NotNull Element element) {
        return DomUtils.dumpXml(element.getOwnerDocument(), element);
    }

    public static String dumpXml(Document document, @Nullable Element element) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(element == null ? document : element);
    }

    public static Document parse(InputStream xml, Charset charset) throws SAXParseException {
        return DomUtils.parse(new InputSource(new InputStreamReader(xml, charset)));
    }

    public static Document parse(File xml, Charset charset) throws SAXParseException, IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xml), charset);){
            Document document = DomUtils.parse(new InputSource(reader));
            return document;
        }
    }

    public static Document parse(String xml) throws SAXParseException {
        return DomUtils.parse(new InputSource(new StringReader(xml)));
    }

    public static Document parse(InputSource xml) throws SAXParseException {
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            return documentBuilder.parse(xml);
        }
        catch (SAXParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

