/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.servlet.installer;

import com.prosc.Platform;
import com.prosc.deployment.DeploymentInfo;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.FileMakerConfigurationException;
import com.prosc.infrastructure.FileMakerInstallerUtils;
import com.prosc.infrastructure.LogUtils;
import com.prosc.io.HttpClientUtils;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import com.prosc.servlet.admin.AppInfo;
import com.prosc.servlet.admin.ApplicationException;
import com.prosc.servlet.admin.DaemonInfo;
import com.prosc.servlet.admin.DaemonUtils;
import com.prosc.servlet.admin.RemoteDaemon;
import com.prosc.servlet.admin.TomcatStoppedException;
import com.prosc.servlet.installer.AbstractInstaller;
import com.prosc.servlet.installer.InstallerAbortException;
import com.prosc.servlet.installer.LaunchBrowser;
import com.prosc.shared.DebugTimer;
import com.prosc.windows.NoSuchRegistryEntryException;
import com.prosc.windows.WindowsRegistry;
import com.prosc.windows.WindowsRegistryAccessException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public abstract class WebAppInstaller
extends AbstractInstaller {
    private static final Logger log = Logger.getLogger(WebAppInstaller.class.getName());
    private static final boolean isApache = Platform.isMac();
    private static final BigDecimal daemonVersion = new BigDecimal("2.5707");
    public static final FileMakerInstallerUtils fmUtils = new FileMakerInstallerUtils();
    public static boolean debugMode;
    private static final String CR;
    private RemoteDaemon cachedDaemon;
    private final File originalWarFile;
    private final String originalAppName;
    private final JTextArea statusText;
    private final String versionInfo;
    private File daemonInstallDir;
    private String appName;
    private volatile String lastStatus;
    private File userAppManager;
    private URL webAppUrl;
    private DeploymentInfo currentDeploymentInfo;
    private final DeploymentInfo installerDeploymentInfo;
    private AppInfo installedApp;
    private ResourceBundle _resourceBundle;
    boolean addCalDAVRedirect = false;
    private boolean registryValueChanged = false;

    public WebAppInstaller(File originalWarFile) throws IOException, InstallerAbortException {
        if (!originalWarFile.exists()) {
            throw new FileNotFoundException("Could not locate the " + originalWarFile.getAbsolutePath() + " file. Installation cannot continue, please try re-downloading.\nBe sure not to move any of the directory contents before running the installer.");
        }
        URL url = originalWarFile.toURI().toURL();
        url = new URL("jar:" + url.toExternalForm() + "!/WEB-INF/classes/deployment.properties");
        InputStream deploymentInfoStream = url.openStream();
        DeploymentInfo deploymentInfo = new DeploymentInfo(deploymentInfoStream);
        this.versionInfo = deploymentInfo.getSummary();
        this.installerDeploymentInfo = deploymentInfo;
        this.appName = this.originalAppName = deploymentInfo.getShortName();
        this.originalWarFile = originalWarFile;
        this.statusText = new JTextArea("Starting installation...");
        this.statusText.setEditable(false);
        this.statusText.setLineWrap(true);
        this.statusText.setWrapStyleWord(true);
        if (Platform.isMac()) {
            this.daemonInstallDir = DaemonUtils.getMac360dir();
        } else {
            try {
                String location = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\360Works\\MirrorSync", "InstallLocation");
                log.info("Install location: " + location);
                this.daemonInstallDir = new File(location);
            }
            catch (NoSuchRegistryEntryException e) {
                log.log(Level.WARNING, "did not find the install location in the registry", e);
                this.daemonInstallDir = DaemonUtils.getWindows360dir();
            }
        }
    }

    public File get360WorksDir() {
        return this.daemonInstallDir;
    }

    public File getUserAppManager() {
        return this.userAppManager;
    }

    public URL getWebAppUrl() {
        return this.webAppUrl;
    }

    public String getAppName() {
        return this.appName;
    }

    public ResourceBundle getInstallerResourceBundle() {
        if (this._resourceBundle == null) {
            this._resourceBundle = ResourceBundle.getBundle("com.prosc.servlet.installer.strings");
        }
        return this._resourceBundle;
    }

    protected DeploymentInfo getDeploymentInfo() {
        return this.installerDeploymentInfo;
    }

    public void setAddCalDAVRedirect(boolean addCalDAVRedirect) {
        this.addCalDAVRedirect = addCalDAVRedirect;
    }

    @Override
    public void overrideInstallLocation(File newInstallLocation) throws IOException, InstallerAbortException {
        log.info("Changing the install location to: " + newInstallLocation);
        this.daemonInstallDir = newInstallLocation;
        this.checkConfiguration();
        log.info("About to write new install location to Windows Registry.");
        if (Platform.isWin()) {
            try {
                String oldValue = null;
                try {
                    oldValue = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\360Works\\MirrorSync", "InstallLocation");
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not get previous registry value for InstallLocation");
                }
                if (!this.daemonInstallDir.getAbsolutePath().equals(oldValue)) {
                    WindowsRegistry.writeRegistry("HKLM\\SOFTWARE\\360Works\\MirrorSync", "InstallLocation", this.daemonInstallDir.getAbsolutePath());
                    log.info("successfully wrote new install location to Windows Registry.");
                    this.registryValueChanged = true;
                }
            }
            catch (WindowsRegistryAccessException e) {
                log.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void overrideApplicationName(JFrame rootFrame) throws UserCanceledException {
        String newAppName = JOptionPane.showInputDialog(rootFrame, "<html>You can change the default name from " + this.originalAppName + " to some other name.<br> This is useful when running multiple instances on the same server. Enter the application name:</html>", this.appName);
        if (newAppName == null) {
            throw new UserCanceledException();
        }
        log.info("Checking new application instance name to ensure no whitespace characters");
        while (this.checkForWhitespace(newAppName)) {
            log.info("Changing application instance name to " + newAppName);
            this.appName = newAppName;
            newAppName = JOptionPane.showInputDialog(rootFrame, "Please enter a name with no spaces.", newAppName);
        }
        log.info("Changing application instance name to " + newAppName);
        this.appName = newAppName;
    }

    @Override
    public String getProductTitle() {
        return this.appName;
    }

    @Override
    public String getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public void checkConfiguration() throws IOException, InstallerAbortException {
        boolean runningAsAdmin = true;
        String logPath = Platform.isMac() ? "/tmp/360installer_log.txt" : "C:\\Windows\\TEMP\\360installer_log.txt";
        FileHandler handler = new FileHandler(logPath, false);
        handler.setFormatter(new SimpleFormatter());
        LogManager.getLogManager().getLogger("").addHandler(handler);
        log.info("Writing to log file at " + logPath);
        log.info(LogUtils.getSystemInfo(false, true, true));
        if (!runningAsAdmin) {
            if (debugMode) {
                JOptionPane.showMessageDialog(null, "You will not be able to complete installation because we're in debug mode as a non-admin user");
            } else {
                int choice = JOptionPane.showOptionDialog(null, "You must run this application using the Mac or Windows installer application, not by double-clicking on the installer.jar file. Would you like to continue anyways?", "MirrorSync Installer", 0, 1, null, new String[]{"Continue", "Cancel"}, "Continue");
                if (choice == 1) {
                    throw new InstallerAbortException("Halting MirrorSync installer.");
                }
            }
        }
        if (debugMode) {
            // empty if block
        }
        if (this.daemonInstallDir.exists() && !this.daemonInstallDir.canWrite() && !debugMode) {
            throw new InstallerAbortException("The 360Works directory at " + this.daemonInstallDir + " is not writeable. This must be fixed before the installer can run.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isInstalled() throws IOException, TomcatStoppedException {
        DebugTimer dt = new DebugTimer("isInstalled running");
        try {
            block14: {
                File getWebAppsDir = fmUtils.getWebApps();
                File oldJarFile = new File(getWebAppsDir, this.originalAppName + ".war");
                File oldServletDir = new File(getWebAppsDir, this.originalAppName);
                if (oldJarFile.exists() || oldServletDir.exists()) {
                    boolean bl = true;
                    return bl;
                }
                break block14;
                catch (FileMakerConfigurationException e) {
                    log.log(Level.WARNING, "Could not detect whether old " + this.originalAppName + " is installed in the Web Publishing Engine", e);
                }
            }
            this.loadTomcatDaemon(null, dt);
            AppInfo appInfo = this.cachedDaemon.getApplications(false).get(this.appName);
            this.currentDeploymentInfo = null;
            if (appInfo != null) {
                this.currentDeploymentInfo = appInfo.deploymentInfo;
            }
            boolean bl = appInfo != null;
            return bl;
        }
        catch (UnmarshalException e) {
            log.log(Level.WARNING, "UnmarshalException when communicating with the Daemon. Returning true to indicate that the app is installed.", e);
            boolean bl = true;
            return bl;
        }
        catch (ServerException e) {
            if (e.getCause() instanceof UnmarshalException) {
                log.log(Level.WARNING, "Daemon is running, but it might be an old version or we can't communicate with it for some reason. Returning true to indicate that the app is installed.", e);
                boolean bl = true;
                return bl;
            }
            throw e;
        }
        catch (ApplicationException | InstallerAbortException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            dt.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void runInstaller(@Nullable JFrame rootFrame, @Nullable ActionEvent event) throws IOException, UserCanceledException, InstallerAbortException, InterruptedException {
        if (event != null && (event.getModifiers() & 8) > 0) {
            this.overrideApplicationName(rootFrame);
            throw new UserCanceledException();
        }
        this.preInstallUI();
        final JDialog progressDialog = new JDialog(rootFrame, this.getInstallerResourceBundle().getString("installer.installationProgress"), true);
        progressDialog.setAlwaysOnTop(true);
        Cursor startingCursor = progressDialog.getCursor();
        try {
            progressDialog.setCursor(new Cursor(3));
            progressDialog.setSize(400, 300);
            progressDialog.setLocationRelativeTo(rootFrame);
            progressDialog.getContentPane().add((Component)new JScrollPane(this.statusText), "Center");
            JButton cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 5));
            buttonPanel.add(cancelButton);
            progressDialog.getContentPane().add((Component)buttonPanel, "South");
            ExecutorService executor = Executors.newSingleThreadExecutor();
            final Future<Void> future = executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException, InstallerAbortException, InterruptedException, UserCanceledException {
                    try {
                        WebAppInstaller.this.install(progressDialog);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        EventQueue.invokeLater(progressDialog::dispose);
                    }
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.log(Level.INFO, "Canceling install worker");
                    future.cancel(true);
                }
            });
            progressDialog.setVisible(true);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof InstallerAbortException) {
                    throw (InstallerAbortException)t;
                }
                if (t instanceof UserCanceledException) {
                    throw (UserCanceledException)t;
                }
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            catch (CancellationException e) {
                throw new UserCanceledException();
            }
        }
        finally {
            progressDialog.setCursor(startingCursor);
        }
    }

    protected void preInstallUI() throws IOException, UserCanceledException, InstallerAbortException {
        block4: {
            try {
                try {
                    new URL("http://127.0.0.1").openStream().close();
                }
                catch (IOException e) {
                    HttpsURLConnection connection = (HttpsURLConnection)new URL("https://127.0.0.1").openConnection();
                    HttpClientUtils.trustInvalidCertificates(connection, true, true);
                    connection.getInputStream().close();
                }
            }
            catch (IOException e) {
                String message = "<html>There is no Web Server running on this computer. Verify that a Web Server is installed and running by testing the URL http://127.0.0.1. <br>" + this.appName + " can still be installed, but it will not be accessible over port 80. Would you like to proceed with installation anyway?</html>";
                int choice = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "Web Server is not running", 2);
                if (choice != 2) break block4;
                throw new UserCanceledException();
            }
        }
    }

    @Override
    public void installFinished() {
        try {
            new LaunchBrowser().launch(this.getWebAppUrl());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not auto-start the browser. You should manually go to this URL to access " + this.appName + ": " + this.getWebAppUrl());
            log.log(Level.WARNING, "Could not launch " + this.appName + " page at " + this.webAppUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(JDialog parent) throws IOException, InstallerAbortException, InterruptedException, UserCanceledException {
        block19: {
            try {
                if (this.currentDeploymentInfo != null && this.installerDeploymentInfo != null) {
                    String message;
                    int comparison;
                    String currentVersion = this.currentDeploymentInfo.getVersion();
                    String installerVersion = this.installerDeploymentInfo.getVersion();
                    if (currentVersion != null && installerVersion != null && (comparison = new BigDecimal(installerVersion).compareTo(new BigDecimal(currentVersion))) <= 0 && (comparison < 0 ? JOptionPane.showConfirmDialog(parent, message = MessageFormat.format(this.getInstallerResourceBundle().getString("installer.promptInstallOverNewerVersion"), currentVersion, installerVersion), this.getInstallerResourceBundle().getString("installer.versionOnServerIsNewer"), 0, 2) == 1 : JOptionPane.showConfirmDialog(parent, message = MessageFormat.format(this.getInstallerResourceBundle().getString("installer.promptInstallSameVersion"), installerVersion), this.getInstallerResourceBundle().getString("installer.sameVersion"), 0, 2) == 1)) {
                        throw new UserCanceledException();
                    }
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Error parsing version numbers; proceed without prompting the user", e);
            }
            DebugTimer dt = new DebugTimer("Uninstall legacy location in the web publishing engine");
            try {
                this.uninstallFromWebPublishingEngine();
                try {
                    try {
                        dt.markTime("Load existing daemon version; no update check");
                        this.loadTomcatDaemon(null, dt);
                    }
                    catch (InstallerAbortException e) {
                        dt.markTime("Existing daemon did not exist; load most recent version");
                        this.loadTomcatDaemon(daemonVersion, dt);
                    }
                    this.loadTomcatDaemon(daemonVersion, dt);
                    log.info("Starting status update thread");
                    StatusUpdateThread statusUpdateThread = new StatusUpdateThread();
                    statusUpdateThread.start();
                    try {
                        block18: {
                            Object[] options;
                            String message;
                            int choice;
                            do {
                                dt.markTime("Copy .war file to temp directory");
                                String CR = System.getProperty("line.separator");
                                log.info("Line separator: " + CR);
                                File warFileCopy = new File(IOUtils.findWriteableTempDirectory(), this.originalWarFile.getName());
                                warFileCopy.delete();
                                IOUtils.copyFile(this.originalWarFile, warFileCopy);
                                log.info("originalWarFile: " + this.originalWarFile + "; warFileCopy: " + warFileCopy);
                                dt.markTime("Ask daemon to install application");
                                try {
                                    this.installedApp = this.cachedDaemon.installWar(this.appName, warFileCopy.toURI().toURL(), (int)warFileCopy.length(), this.addCalDAVRedirect);
                                }
                                catch (TomcatStoppedException e) {
                                    throw new InstallerAbortException("Unable to install, because Tomcat application server could not be started", e);
                                }
                                this.webAppUrl = this.installedApp.url;
                                dt.markTime("Install finished; waiting for user confirmation if applicable");
                                if (this.installedApp.forwardingException == null) break block18;
                                message = MessageFormat.format(this.getInstallerResourceBundle().getString("installer.successWithWebForwardingerror"), this.appName, this.installedApp.forwardingException.getMessage(), this.appName, this.installedApp.accessiblePort);
                                options = new String[]{this.getInstallerResourceBundle().getString("installer.installAgain"), this.getInstallerResourceBundle().getString("installer.ignore")};
                            } while ((choice = JOptionPane.showOptionDialog(this.statusText, message, this.getInstallerResourceBundle().getString("installer.webServerInstallationProblem"), -1, 2, null, options, options[1])) == 0);
                            break block19;
                        }
                        if (this.installedApp.warningMessage != null) {
                            JOptionPane.showMessageDialog(parent, this.installedApp.warningMessage);
                        }
                    }
                    finally {
                        statusUpdateThread.interrupt();
                    }
                }
                catch (ApplicationException e) {
                    throw new InstallerAbortException("Unable to install: " + e.getMessage(), e);
                }
            }
            finally {
                dt.stop();
            }
        }
    }

    protected AppInfo getInstalledApp() {
        return this.installedApp;
    }

    protected void updateStatus(final @Nullable String status) {
        if (status != null && !status.equals(this.lastStatus)) {
            log.info(status);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String previousText = WebAppInstaller.this.statusText.getText();
                    if (previousText == null) {
                        previousText = "";
                    }
                    WebAppInstaller.this.statusText.setText(previousText + "\n" + status);
                }
            });
            this.lastStatus = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runUninstaller() throws IOException, InstallerAbortException, InterruptedException {
        log.info("Running uninstaller");
        this.updateStatus("Starting uninstall process...");
        DebugTimer dt = new DebugTimer("Uninstall from Web Publishing Engine");
        try {
            this.uninstallFromWebPublishingEngine();
            try {
                boolean shouldUninstall;
                this.loadTomcatDaemon(new BigDecimal("2.13"), dt);
                StatusUpdateThread statusUpdateThread = new StatusUpdateThread();
                statusUpdateThread.start();
                try {
                    shouldUninstall = this.cachedDaemon.undeployApplication(this.appName, true);
                }
                catch (TomcatStoppedException e) {
                    log.info("Tomcat is not running when we expected it to be; something is wrong so proceed with uninstall");
                    shouldUninstall = true;
                }
                finally {
                    statusUpdateThread.interrupt();
                }
                if (shouldUninstall) {
                    this.removeDaemonAndAdminApplication(this.cachedDaemon, true, dt);
                }
            }
            catch (RemoteException shouldUninstall) {
            }
            catch (InstallerAbortException e) {
                log.info("The 360Works daemon is not running; presumably there is nothing for the installer to do.");
            }
        }
        finally {
            dt.stop();
        }
    }

    private void uninstallFromWebPublishingEngine() {
        HashSet<String> oldNames = new HashSet<String>(2);
        oldNames.add(this.originalAppName);
        oldNames.add(this.appName);
        for (String oldName : oldNames) {
            try {
                File getWebAppsDir = fmUtils.getWebApps();
                File oldJarFile = new File(getWebAppsDir, oldName + ".war");
                File oldServletDir = new File(getWebAppsDir, oldName);
                if (oldJarFile.exists() || oldServletDir.exists()) {
                    this.updateStatus(this.getInstallerResourceBundle().getString("installer.uninstallingFromWebPublishing"));
                }
                if (oldJarFile.exists() && !oldJarFile.delete()) {
                    log.warning("Could not delete old application at " + oldJarFile);
                }
                if (oldServletDir.exists() && !IOUtils.deleteRecursive(oldServletDir)) {
                    log.warning("Could not delete old servlet directory at " + oldServletDir);
                }
            }
            catch (FileMakerConfigurationException e) {
                log.warning("Could not delete old copy of " + oldName + " from the FileMaker Web Publishing Engine: " + e);
            }
            try {
                if (isApache) continue;
                fmUtils.writeJKMounts(Collections.singletonList(this.appName), false);
            }
            catch (Exception e) {
                log.warning("Could not remove " + oldName + " from FileMaker Web Publishing Engine list of URLs: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTomcatDaemon(@Nullable BigDecimal minVersion, DebugTimer dt) throws InstallerAbortException {
        File proscTomcatDaemonExe;
        File javaDir;
        String[] cmdArray;
        RemoteDaemon daemon;
        File dir360WorksInternal;
        block74: {
            log.info("loadTomcatDaemon with minVersion " + minVersion);
            dt.markTime("Create / check the 360Works internal directory");
            dir360WorksInternal = new File(this.daemonInstallDir, "Internal");
            try {
                IOUtils.ensureDirectoryIsReady(dir360WorksInternal);
            }
            catch (FileNotFoundException e) {
                throw new InstallerAbortException("The 360Works/Internal directory could not be created at " + dir360WorksInternal, e);
            }
            if (this.cachedDaemon != null) {
                if (minVersion == null) {
                    return;
                }
                if (Platform.isWin() && this.registryValueChanged) {
                    log.info("Registry value changed install location; will install a new daemon version");
                } else {
                    try {
                        DaemonInfo info = this.cachedDaemon.getInfo();
                        if (info.startupError == null && minVersion.compareTo(info.version) <= 0) {
                            log.info("Existing daemon is up-to-date; returning");
                            return;
                        }
                    }
                    catch (RemoteException e) {
                        log.log(Level.WARNING, "Error getting daemon version; will proceed with rest of method", e);
                    }
                }
            }
            dt.markTime("Checking daemon version");
            daemon = null;
            try {
                Registry registry = LocateRegistry.getRegistry("127.0.0.1", 43434);
                daemon = (RemoteDaemon)registry.lookup("com.prosc.servlet.admin.RemoteDaemon");
                log.info("Found existing daemon with version " + daemon.getInfo().version + " (minVersion is " + minVersion + ")");
            }
            catch (Exception e) {
                log.log(Level.INFO, "Could not load daemon using RMI: " + e);
            }
            try {
                if (minVersion == null) {
                    if (daemon == null || daemon.getInfo().startupError != null) {
                        throw new InstallerAbortException("Daemon is not running");
                    }
                    this.cachedDaemon = daemon;
                    return;
                }
                if (daemon == null) break block74;
                if (Platform.isWin() && this.registryValueChanged) {
                    log.info("Registry value changed install location; will install a new daemon version");
                    break block74;
                }
                DaemonInfo info = daemon.getInfo();
                if (info.startupError != null) {
                    log.info("Daemon has a startup error (" + info.startupError + "); will install a new version");
                    break block74;
                }
                if (minVersion.compareTo(info.version) > 0) {
                    log.info("Daemon version " + info.version + " does NOT meet minimum requirement " + minVersion + "; will install a new version");
                    break block74;
                }
                log.info("Daemon version " + info.version + " meets minimum requirement " + minVersion + "; returning");
                this.cachedDaemon = daemon;
                return;
            }
            catch (RemoteException e) {
                log.log(Level.WARNING, "Tomcat daemon is running, but we could not communicate with it. We will stop it and install a new one.", e);
            }
        }
        dt.markTime("Installing latest 360Works admin");
        if (minVersion != null) {
            File destination;
            File bundledAdminTool;
            this.updateStatus(this.getInstallerResourceBundle().getString("installer.installingLatestAdminApp"));
            if (Platform.isMac()) {
                File adminExecutable;
                bundledAdminTool = new File("appFiles/adminTool/mac/360Works Admin.app");
                try {
                    log.info("Copying bundled admin tool to 360Works directory");
                    destination = new File(this.daemonInstallDir, "360Works Admin.app");
                    IOUtils.deleteRecursive(destination);
                    IOUtils.copyDirectory(bundledAdminTool, destination);
                    this.userAppManager = destination;
                    adminExecutable = new File(destination, "Contents/MacOS/360Works Admin");
                    cmdArray = new String[]{"/bin/chmod", "a+x", adminExecutable.getCanonicalPath()};
                    ProcessUtils.doShellCommand(cmdArray, null, null);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not copy 360Works Tomcat Admin Tool to destination folder; will proceed without it", e);
                }
                catch (UserCanceledException | ProcessExecutionException e) {
                    log.log(Level.WARNING, "Could not set executable bit on 360Works Tomcat Admin Tool; will proceed without it", e);
                }
                try {
                    log.info("Copying bundled admin tool to Applications directory");
                    destination = new File("/Applications", "360Works Admin.app");
                    IOUtils.deleteRecursive(destination);
                    IOUtils.copyDirectory(bundledAdminTool, destination);
                    this.userAppManager = destination;
                    adminExecutable = new File(destination, "Contents/MacOS/360Works Admin");
                    cmdArray = new String[]{"/bin/chmod", "a+x", adminExecutable.getCanonicalPath()};
                    ProcessUtils.doShellCommand(cmdArray, null, null);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not copy 360Works Tomcat Admin jar to destination folder; will proceed without it", e);
                }
                catch (UserCanceledException | ProcessExecutionException e) {
                    log.log(Level.WARNING, "Could not set executable bit on 360Works Tomcat Admin Tool; will proceed without it", e);
                }
            } else {
                bundledAdminTool = new File("appFiles/adminTool/win/360Works Admin");
                try {
                    log.info("Copying bundled admin tool to 360Works directory");
                    destination = new File(this.daemonInstallDir, "360Works Admin");
                    IOUtils.deleteRecursive(destination);
                    IOUtils.copyDirectory(bundledAdminTool, destination);
                    this.userAppManager = destination;
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not copy 360Works Tomcat Admin Tool to destination folder; will proceed without it", e);
                }
            }
        }
        this.updateStatus(this.getInstallerResourceBundle().getString("installer.installingTomcatDaemon"));
        dt.markTime("Remove old daemon");
        this.removeDaemonAndAdminApplication(daemon, false, dt);
        File daemonLogsDir = new File(dir360WorksInternal, "Logs");
        if (!daemonLogsDir.exists() && !daemonLogsDir.mkdirs()) {
            throw new InstallerAbortException("Could not create logs directory at " + daemonLogsDir);
        }
        dt.markTime("Copy daemon.jar");
        try {
            log.info("Copying ProscTomcatDaemon.jar");
            this.copyResourceNamed("/ProscTomcatDaemon.jar", dir360WorksInternal);
        }
        catch (IOException e) {
            throw new InstallerAbortException("A necessary file (ProscTomcatDaemon.jar) could not be copied to " + dir360WorksInternal + ": " + e.getMessage(), e);
        }
        dt.markTime("Start daemon");
        if (Platform.isMac()) {
            try {
                log.info("Copying bundled jre");
                javaDir = new File(dir360WorksInternal, "appFiles");
                IOUtils.ensureDirectoryIsReady(javaDir);
                IOUtils.copyDirectory(new File("appFiles/mac"), javaDir);
            }
            catch (IOException e) {
                throw new InstallerAbortException("A necessary file (appFiles) could not be copied to " + dir360WorksInternal + ": " + e.getMessage(), e);
            }
            try {
                log.info("Setting permissions on java executables");
                File javaBinFolder = new File(javaDir, "Contents/Home/bin");
                cmdArray = new String[]{"/bin/chmod", "-R", "a+x", javaBinFolder.getCanonicalPath()};
                ProcessUtils.doShellCommand(cmdArray, null, null);
                log.info("Setting permissions on jspawnhelper");
                File jspawnhelper = new File(javaDir, "Contents/Home/lib/jspawnhelper");
                cmdArray = new String[]{"/bin/chmod", "a+x", jspawnhelper.getCanonicalPath()};
                ProcessUtils.doShellCommand(cmdArray, null, null);
                log.info("Setting permissions on libfreetype.dylib.6");
                try {
                    File temp = new File(javaDir, "Contents/Home/lib/libfreetype.dylib.6");
                    cmdArray = new String[]{"/bin/chmod", "a+x", temp.getCanonicalPath()};
                    ProcessUtils.doShellCommand(cmdArray, null, null);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not set dylib to executable, ignoring: " + e.getMessage(), e);
                }
            }
            catch (UserCanceledException | ProcessExecutionException | IOException e) {
                throw new InstallerAbortException("Necessary permissions could not be set on the java executables here: " + javaDir.getAbsolutePath() + ", Message: " + e.getMessage(), e);
            }
            String launchctlLabel = "com.prosc.TomcatDaemon";
            log.info("Copying " + launchctlLabel + ".plist");
            File tomcatDaemonPlist = new File("/Library/LaunchDaemons", launchctlLabel + ".plist");
            File javaBinary = new File(javaDir, "Contents/Home/bin/java");
            if (!javaBinary.exists()) {
                javaBinary = new File("/usr/bin/java");
            }
            if (!javaBinary.exists()) {
                throw new InstallerAbortException("You must install Java on this computer before the installer can run.");
            }
            String resource = "/com/prosc/servlet/installer/TomcatDaemon.txt";
            try {
                InputStream input = this.getClass().getResourceAsStream(resource);
                if (input == null) {
                    throw new FileNotFoundException("Could not locate resource " + resource);
                }
                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(tomcatDaemonPlist), StandardCharsets.UTF_8);
                try {
                    String[] contents = IOUtils.inputStreamAsString(input);
                    contents = String.format((String)contents, javaBinary.getAbsolutePath());
                    output.write((String)contents);
                }
                finally {
                    input.close();
                    ((Writer)output).close();
                }
            }
            catch (IOException e) {
                throw new InstallerAbortException("A necessary file (" + resource + ") could not be copied to " + tomcatDaemonPlist + ": " + e.getMessage(), e);
            }
            log.info("Starting " + tomcatDaemonPlist.getAbsolutePath() + " with launchctl as user " + System.getProperty("user.name"));
            try {
                byte[] bytes = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "load", tomcatDaemonPlist.getAbsolutePath()}, null, null);
                log.info("Launchctl load process execution result: " + new String(bytes, StandardCharsets.UTF_8));
                bytes = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "start", launchctlLabel}, null, null);
                log.info("Launchctl start process execution result: " + new String(bytes, StandardCharsets.UTF_8));
            }
            catch (ProcessExecutionException e) {
                throw new InstallerAbortException("The ProscTomcatDaemon could not be loaded with launchctl", e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (UserCanceledException e) {
                throw new InstallerAbortException("User canceled while waiting for Tomcat daemon to stop and start", e);
            }
        }
        try {
            log.info("Copying bundled jre");
            javaDir = new File(dir360WorksInternal, "appFiles");
            IOUtils.ensureDirectoryIsReady(javaDir);
            File file = new File(System.getProperty("user.dir"));
            IOUtils.copyDirectory(new File(file, "appFiles/win"), javaDir);
        }
        catch (IOException e) {
            throw new InstallerAbortException("A necessary file (appFiles) could not be copied to " + dir360WorksInternal + ": " + e.getMessage(), e);
        }
        try {
            boolean is64bit = true;
            try {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command("java", "-version");
                builder.redirectErrorStream(true);
                Process process = builder.start();
                try (InputStream in = process.getInputStream();){
                    String javaVersion = IOUtils.inputStreamAsString(in);
                    is64bit = javaVersion.contains("64-Bit");
                    log.info(javaVersion);
                    log.info("64bit is" + is64bit);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not determine 32 bit vs 64 java; assuming 64 bit", e.getMessage());
            }
            String resourcePath = is64bit ? "/v64/ProscTomcatDaemon.exe" : "/v32/ProscTomcatDaemon.exe";
            log.info("Using ProscTomcatDaemon from " + resourcePath);
            log.info("Copying ProscTomcatDaemon.exe");
            proscTomcatDaemonExe = this.copyResourceNamed(resourcePath, dir360WorksInternal);
        }
        catch (IOException e) {
            throw new InstallerAbortException("A necessary file could not be copied: " + e.getMessage(), e);
        }
        File jvmDLL = new File(javaDir, "bin/server/jvm.dll");
        String[] stopCommands = new String[]{proscTomcatDaemonExe.getAbsolutePath(), "//SS//360Works"};
        String[] deleteCommands = new String[]{proscTomcatDaemonExe.getAbsolutePath(), "//DS//360Works"};
        String[] installCommands = new String[]{proscTomcatDaemonExe.getAbsolutePath(), "//IS//360Works", "--Startup=auto", "--Description=360Works web applications", "--Install=" + proscTomcatDaemonExe.getAbsolutePath(), "--Jvm=" + jvmDLL.getAbsolutePath(), "--Classpath=" + dir360WorksInternal.getAbsolutePath() + "\\ProscTomcatDaemon.jar", "--StartMode=jvm", "--StartClass=com.prosc.servlet.admin.Daemon", "--StartMethod=startService", "--StartParams=start", "--StopMode=jvm", "--StopClass=com.prosc.servlet.admin.Daemon", "--StopMethod=stopService", "--StopParams=stop", "--LogPath=" + daemonLogsDir.getAbsolutePath(), "--StdOutput=auto", "--StdError=auto"};
        String[] startCommands = new String[]{proscTomcatDaemonExe.getAbsolutePath(), "//ES//360Works"};
        for (String installCommand : installCommands) {
            log.info(installCommand);
        }
        log.log(Level.INFO, "Stopping 360Works Services...");
        try {
            ProcessUtils.doShellCommand(stopCommands, null, dir360WorksInternal);
            log.log(Level.INFO, "360Works Service Stopped.");
        }
        catch (Exception e) {
            log.log(Level.INFO, "360Works Service could not be stopped, likely because it was not running in the first place: " + e.getMessage());
        }
        log.log(Level.INFO, "Deleting 360Works Services...");
        try {
            ProcessUtils.doShellCommand(deleteCommands, null, dir360WorksInternal);
            log.log(Level.INFO, "360Works Service Deleted.");
        }
        catch (Exception e) {
            log.log(Level.INFO, "360Works Service could not be deleted, likely because it was not running in the first place: " + e.getMessage());
        }
        log.info("Installing " + proscTomcatDaemonExe.getAbsolutePath() + " as a Windows service");
        try {
            ProcessUtils.doShellCommand(installCommands, null, dir360WorksInternal);
            ProcessUtils.doShellCommand(startCommands, null, dir360WorksInternal);
        }
        catch (ProcessExecutionException e) {
            throw new InstallerAbortException("The ProscTomcatDaemon could not be loaded with procrun", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UserCanceledException e) {
            throw new InstallerAbortException("User canceled while attempting to install the ProscTomcatDaemon", e);
        }
        this.chown(this.daemonInstallDir, "root", true);
        dt.markTime("Get RMI connection to daemon");
        long tryUntil = System.currentTimeMillis() + 20000L;
        while (true) {
            try {
                Registry registry = LocateRegistry.getRegistry("127.0.0.1", 43434);
                RemoteDaemon remote = (RemoteDaemon)registry.lookup("com.prosc.servlet.admin.RemoteDaemon");
                log.info("Daemon was installed and is running and accessible via RMI; version is " + remote.getInfo().version);
                this.cachedDaemon = remote;
                return;
            }
            catch (Exception e) {
                Exception rmiException = e;
                log.info("RMI is not responding yet; will wait one second and try again");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new InstallerAbortException("User canceled while waiting for RMI connection to daemon", e1);
                }
                if (System.currentTimeMillis() < tryUntil) continue;
                log.log(Level.SEVERE, "RMI lookup exception", rmiException);
                throw new InstallerAbortException("The ProscTomcatDaemon.jar file could not be started, or we cannot communicate with it. Contact 360Works for support at plugins@360works.com");
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeDaemonAndAdminApplication(@Nullable RemoteDaemon existingDaemon, boolean removeAdminApplication, DebugTimer dt) throws InstallerAbortException {
        try {
            if (existingDaemon != null) {
                dt.markTime("Calling shutdown() on existing daemon");
                existingDaemon.shutdown();
            }
        }
        catch (Throwable e) {
            WebAppInstaller.log.log(Level.WARNING, "Could not stop existing daemon before deleting; will proceed anyway");
        }
        dir360WorksInternal = new File(this.daemonInstallDir, "Internal");
        if (Platform.isMac()) {
            dt.markTime("Calling launchctl stop com.prosc.TomcatDaemon");
            tomcatDaemonPlist = new File("/Library/LaunchDaemons/com.prosc.TomcatDaemon.plist");
            if (tomcatDaemonPlist.exists()) {
                try {
                    try {
                        b = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "stop", "com.prosc.TomcatDaemon"}, null, null);
                        WebAppInstaller.log.info("Stopped launchctl; result: " + new String(b, StandardCharsets.UTF_8));
                    }
                    catch (ProcessExecutionException e) {
                        WebAppInstaller.log.info("Did not stop com.prosc.TomcatDaemon; it is probably already stopped: " + e.getMessage());
                    }
                    dt.markTime("Calling launchctl unload com.prosc.TomcatDaemon");
                    try {
                        b = ProcessUtils.doShellCommand(new String[]{"/bin/launchctl", "unload", tomcatDaemonPlist.getAbsolutePath()}, null, null);
                        WebAppInstaller.log.info("Unloaded launchctl; result: " + new String(b, StandardCharsets.UTF_8));
                    }
                    catch (ProcessExecutionException e) {
                        WebAppInstaller.log.info("Did not unload " + tomcatDaemonPlist.getAbsolutePath() + "; it is probably already stopped: " + e.getMessage());
                    }
                    if (tomcatDaemonPlist.delete()) ** GOTO lbl44
                    WebAppInstaller.log.info("Launchctl plist at " + tomcatDaemonPlist + " could not be deleted.");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (UserCanceledException e) {
                    throw new InstallerAbortException("User canceled installation while waiting for Tomcat daemon to stop and start", e);
                }
            }
        } else {
            dt.markTime("Calling ProscTomcatDaemon.exe to delete service");
            daemonExe = new File(dir360WorksInternal, "ProscTomcatDaemon.exe");
            if (daemonExe.exists()) {
                try {
                    ProcessUtils.doShellCommand(new String[]{daemonExe.getAbsolutePath(), "//DS//360Works"}, null, dir360WorksInternal);
                }
                catch (Exception e) {
                    WebAppInstaller.log.log(Level.INFO, "The 360Works Windows service could not be removed by the installer: " + e.getMessage(), e);
                }
            }
        }
lbl44:
        // 7 sources

        if (removeAdminApplication) {
            dt.markTime("Removing admin application and ProscTomcatDaemon files");
            new File(dir360WorksInternal, "ProscTomcatDaemon.jar").delete();
            new File(dir360WorksInternal, "ProscTomcatDaemon.exe").delete();
            new File(this.daemonInstallDir, "360Works Admin.jar").delete();
            if (Platform.isMac()) {
                IOUtils.deleteRecursive(new File("/Applications/360Works Admin.app"));
                IOUtils.deleteRecursive(new File(this.daemonInstallDir, "360Works Admin.app"));
            } else {
                IOUtils.deleteRecursive(new File(this.daemonInstallDir, "360Works Admin"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyResourceNamed(String resource, File destination) throws IOException {
        InputStream input = debugMode && "/360Works Admin.jar".equals(resource) ? new FileInputStream("../../ProscTomcatAdmin_jar/360Works Admin.jar") : (debugMode && "/ProscTomcatDaemon.jar".equals(resource) ? new FileInputStream("../../ProscTomcatDaemon_jar/ProscTomcatDaemon.jar") : (debugMode && "/ProscTomcatDaemon.exe".equals(resource) ? new FileInputStream("../../../../../ProscLib/ProscTomcatDaemon/ProscTomcatDaemon.exe") : this.getClass().getResourceAsStream(resource)));
        if (input == null) {
            throw new FileNotFoundException("Could not locate resource " + resource);
        }
        if (destination.isDirectory()) {
            String filename = new File(resource).getName();
            destination = new File(destination, filename);
        }
        FileOutputStream output = new FileOutputStream(destination);
        try {
            IOUtils.writeInputToOutput(input, (OutputStream)output, 8192);
        }
        finally {
            input.close();
            output.close();
        }
        return destination;
    }

    private void chown(File whichFile, String newOwner, boolean recursive) {
        if (Platform.isMac()) {
            try {
                String[] args = recursive ? new String[]{"chown", "-R", newOwner, whichFile.getAbsolutePath()} : new String[]{"chown", newOwner, whichFile.getAbsolutePath()};
                ProcessUtils.doShellCommand(args, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean checkForWhitespace(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            if (!Character.isWhitespace(fileName.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static {
        CR = System.getProperty("line.separator");
    }

    private class StatusUpdateThread
    extends Thread {
        public StatusUpdateThread() {
            super("Status update thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                int failCount = 0;
                while (true) {
                    block5: {
                        try {
                            WebAppInstaller.this.updateStatus(((WebAppInstaller)WebAppInstaller.this).cachedDaemon.getInfo().currentStatus);
                        }
                        catch (RemoteException e) {
                            log.log(Level.WARNING, "Unable to update status from daemon", e);
                            if (++failCount != 100) break block5;
                            log.log(Level.SEVERE, "StatusUpdateThread failCount is " + failCount + "; exiting update");
                        }
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class CenteredFileChooser
    extends JFileChooser {
        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            JDialog result = super.createDialog(parent);
            if (parent.getWidth() == 0 || parent.getHeight() == 0) {
                result.setLocationRelativeTo(null);
            }
            return result;
        }
    }
}

