/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.servlet.installer;

import com.prosc.Platform;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.LogUtils;
import com.prosc.servlet.admin.DaemonUtils;
import com.prosc.servlet.installer.AbstractInstaller;
import com.prosc.servlet.installer.IEProcessLaunchException;
import com.prosc.servlet.installer.InstallerAbortException;
import com.prosc.servlet.installer.LaunchBrowser;
import com.prosc.shared.ExceptionUtils;
import com.prosc.windows.NoSuchRegistryEntryException;
import com.prosc.windows.WindowsRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class InstallerGUI {
    private static final Logger log = Logger.getLogger(InstallerGUI.class.getName());
    private boolean shouldCallFinishedHandler = false;
    private final AbstractInstaller installer;
    private JButton installButton;
    private JEditorPane instructionsLabel;
    private JLabel versionInfo;
    private JEditorPane finishedPane;
    private HyperlinkListener hyperlinkListener;
    private JButton removeButton;
    private JFrame frame;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.prosc.servlet.installer.strings");

    public InstallerGUI(AbstractInstaller installer) {
        this.installer = installer;
    }

    public void run(String[] args) throws Exception {
        log.info(LogUtils.getSystemInfo(false, true, true));
        if (Platform.isWin()) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        this.installer.checkConfiguration();
        log.info("Command line arguments: " + Arrays.asList(args));
        if (args.length > 0) {
            if ("install".equals(args[0])) {
                if (Platform.isWin()) {
                    this.installer.overrideInstallLocation(args.length > 1 && args[1] != null ? new File(args[1]) : this.showOverrideInstallLocationUI());
                }
                this.installer.runInstaller(null, null);
                this.installer.installFinished();
                System.exit(0);
            } else if ("uninstall".equals(args[0])) {
                this.installer.runUninstaller();
                System.exit(0);
            } else if ("hostinstall".equals(args[0])) {
                this.installer.overrideApplicationName(null);
                if (Platform.isWin()) {
                    this.installer.overrideInstallLocation(args.length > 1 && args[1] != null ? new File(args[1]) : this.showOverrideInstallLocationUI());
                }
                this.installer.runInstaller(null, null);
                this.installer.installFinished();
                System.exit(0);
            } else if ("hostuninstall".equals(args[0])) {
                this.installer.overrideApplicationName(null);
                this.installer.runUninstaller();
                System.exit(0);
            } else {
                System.err.println("Valid commands: install, uninstall, hostinstall, hostuninstall");
                System.exit(-1);
            }
        } else {
            final JButton cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
            this.removeButton = new JButton(this.resourceBundle.getString("installer.remove"));
            final JButton finishButton = new JButton(this.resourceBundle.getString("installer.finish"));
            this.installButton = new JButton();
            this.instructionsLabel = new JEditorPane("text/html", "");
            this.instructionsLabel.setEditable(false);
            this.instructionsLabel.setOpaque(false);
            this.versionInfo = new JLabel();
            this.finishedPane = new JEditorPane("text/html", null);
            final JPanel installPanel = new JPanel(new BorderLayout());
            this.hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            new LaunchBrowser().launch(e.getURL());
                        }
                        catch (IEProcessLaunchException e1) {
                            ExceptionUtils.reportAndLogException(Level.WARNING, installPanel, "", e1);
                        }
                    }
                }
            };
            this.instructionsLabel.addHyperlinkListener(this.hyperlinkListener);
            this.applyFontRuleToEditorPane(this.instructionsLabel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.add(cancelButton);
            buttonPanel.add(this.removeButton);
            buttonPanel.add(this.installButton);
            JPanel versionPanel = new JPanel(new FlowLayout(2));
            versionPanel.add(this.versionInfo);
            installPanel.add((Component)versionPanel, "North");
            installPanel.add((Component)this.instructionsLabel, "Center");
            installPanel.add((Component)buttonPanel, "South");
            installPanel.setPreferredSize(new Dimension(570, 340));
            installPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel finishedPanel = new JPanel(new BorderLayout());
            finishedPanel.add((Component)this.finishedPane, "Center");
            buttonPanel = new JPanel(new FlowLayout(1));
            buttonPanel.add(finishButton);
            finishedPanel.add((Component)buttonPanel, "South");
            this.frame = new JFrame();
            this.frame.setDefaultCloseOperation(3);
            final CardLayout cardLayout = new CardLayout(10, 20);
            this.frame.getContentPane().setLayout(cardLayout);
            this.frame.getContentPane().add((Component)installPanel, "one");
            this.frame.getContentPane().add((Component)finishedPanel, "two");
            this.frame.pack();
            this.frame.setLocationRelativeTo(null);
            this.frame.setVisible(true);
            this.updateUI();
            ActionListener installAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String finishedMessage;
                        if (e.getSource() == InstallerGUI.this.installButton) {
                            InstallerGUI.this.installer.runInstaller(InstallerGUI.this.frame, e);
                            finishedMessage = InstallerGUI.this.installer.getSuccessMessage();
                            InstallerGUI.this.shouldCallFinishedHandler = true;
                        } else {
                            InstallerGUI.this.installer.runUninstaller();
                            finishedMessage = InstallerGUI.this.installer.getUninstallMessage();
                        }
                        InstallerGUI.this.finishedPane.setText(finishedMessage);
                        cardLayout.next(InstallerGUI.this.frame.getContentPane());
                        InstallerGUI.this.frame.getRootPane().setDefaultButton(finishButton);
                    }
                    catch (UserCanceledException | InterruptedException finishedMessage) {
                    }
                    catch (InstallerAbortException e1) {
                        ExceptionUtils.reportAndLogException(Level.SEVERE, null, "Installation failed: " + e1.getMessage(), e1);
                    }
                    catch (Throwable t) {
                        ExceptionUtils.reportAndLogException(Level.SEVERE, null, "Installation failed: " + t, t);
                    }
                    InstallerGUI.this.updateUI();
                }
            };
            this.installButton.addActionListener(installAction);
            this.removeButton.addActionListener(installAction);
            ActionListener closeFrame = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallerGUI.this.frame.dispose();
                    if (e.getSource() == cancelButton) {
                        System.exit(-1);
                    } else {
                        if (InstallerGUI.this.shouldCallFinishedHandler) {
                            InstallerGUI.this.installer.installFinished();
                        }
                        System.exit(0);
                    }
                }
            };
            cancelButton.addActionListener(closeFrame);
            finishButton.addActionListener(closeFrame);
            this.frame.getRootPane().setDefaultButton(this.installButton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File showOverrideInstallLocationUI() throws UserCanceledException {
        File newInstallLocation;
        File dir360;
        Object[] options = new Object[]{"Yes", "Change"};
        boolean registryValueSet = false;
        String location = null;
        try {
            location = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\360Works\\MirrorSync", "InstallLocation");
        }
        catch (NoSuchRegistryEntryException | IOException e) {
            log.log(Level.INFO, "Could not read registry location, likely because our services has never been installed before.");
        }
        if (location != null) {
            dir360 = new File(location);
            registryValueSet = true;
        } else {
            dir360 = DaemonUtils.get360dir();
        }
        int result = JOptionPane.showOptionDialog(null, "<html>Would you like to use the " + (registryValueSet ? "previous" : "default") + " install location, currently set to: <code>" + dir360 + "</code>", "", -1, 3, null, options, options[0]);
        if (result == 0) {
            return dir360;
        }
        String title = "Select the install location";
        if (System.getProperty("os.name").startsWith("Mac")) {
            FileDialog dialog;
            String propKey = "apple.awt.fileDialogForDirectories";
            String oldPropValue = null;
            try {
                oldPropValue = System.getProperty("apple.awt.fileDialogForDirectories");
                System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(1));
                Frame frame = JOptionPane.getFrameForComponent(null);
                dialog = new FileDialog(frame, title);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
            finally {
                if (oldPropValue != null) {
                    System.setProperty("apple.awt.fileDialogForDirectories", oldPropValue);
                } else {
                    System.getProperties().remove("apple.awt.fileDialogForDirectories");
                }
            }
            if (dialog.getFile() == null) {
                throw new UserCanceledException();
            }
            newInstallLocation = new File(dialog.getDirectory() + dialog.getFile());
        } else {
            JFileChooser chooser = new JFileChooser(){

                @Override
                protected JDialog createDialog(Component parent) throws HeadlessException {
                    JDialog result = super.createDialog(parent);
                    result.setLocationRelativeTo(null);
                    return result;
                }
            };
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(title);
            int choice = chooser.showDialog(null, "Select");
            if (choice == 0 && chooser.getSelectedFile() != null) {
                newInstallLocation = chooser.getSelectedFile();
            } else {
                throw new UserCanceledException();
            }
        }
        return newInstallLocation;
    }

    private void updateUI() {
        boolean isInstalled;
        boolean canRemove;
        this.frame.setTitle(this.installer.getProductTitle() + " Installer");
        try {
            canRemove = this.installer.canRemove();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not determine whether the application can be removed", e);
            canRemove = false;
        }
        try {
            isInstalled = this.installer.isInstalled();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not determine whether the application is already installed", e);
            isInstalled = false;
        }
        this.removeButton.setVisible(canRemove);
        this.installButton.setText(isInstalled ? this.resourceBundle.getString("installer.upgrade") : this.resourceBundle.getString("installer.install"));
        String instructions = this.installer.getInstallInstructions();
        this.instructionsLabel.setText(instructions);
        try {
            String versionInfoString = this.installer.getVersionInfo();
            if (versionInfoString != null) {
                this.versionInfo.setText(versionInfoString);
                this.versionInfo = new JLabel(versionInfoString);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not get version info", e);
        }
        this.finishedPane.setEditable(false);
        this.finishedPane.setOpaque(false);
        this.finishedPane.addHyperlinkListener(this.hyperlinkListener);
        this.applyFontRuleToEditorPane(this.finishedPane);
    }

    private void applyFontRuleToEditorPane(JEditorPane editorPane) {
        Font font = editorPane.getFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        if (editorPane.getDocument() instanceof HTMLDocument) {
            ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        }
    }
}

