/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.ForeignKeyInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableInfo
implements Serializable,
Comparable<TableInfo> {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String tableName;
    private final String tableSchemaHash;
    @JsonSerialize(using=ColumnInfoToName.class)
    @Nullable
    private final ColumnInfo pkColumn1;
    @JsonSerialize(using=ColumnInfoToName.class)
    @Nullable
    private final ColumnInfo pkColumn2;
    @JsonSerialize(using=MapToList.class)
    private final Map<String, ColumnInfo> columns;
    @JsonSerialize(using=ColumnInfoToName.class)
    private ColumnInfo modStampColumn;
    @JsonSerialize(using=ColumnInfoToName.class)
    private ColumnInfo creationStampColumn;
    @NotNull
    private final String tableOccurrenceName;
    @NotNull
    private List<ForeignKeyInfo> foreignKeys;
    private boolean readOnly;
    private final boolean isSchemaless;
    @JsonSerialize(using=ColumnInfoToName.class)
    private final ColumnInfo writeback;

    public TableInfo(@JsonProperty(value="tableName") @NotNull String tableName, @JsonProperty(value="tableOccurrenceName") @NotNull String tableOccurrenceName, @JsonProperty(value="pkColumn1") String pkColumn1, @JsonProperty(value="pkColumn2") String pkColumn2, @JsonProperty(value="modStampColumn") String modStampColumn, @JsonProperty(value="creationStampColumn") String creationStampColumn, @JsonProperty(value="columns") List<ColumnInfo> columns, @JsonProperty(value="foreignKeys") @NotNull List<ForeignKeyInfo> foreignKeys, @JsonProperty(value="tableSchemaHash") String tableSchemaHash, @JsonProperty(value="writeback") String writeback, @JsonProperty(value="isSchemaless") boolean isSchemaless) {
        this.tableName = tableName;
        this.tableOccurrenceName = tableOccurrenceName;
        this.columns = new LinkedHashMap<String, ColumnInfo>(columns.size());
        for (ColumnInfo column : columns) {
            String matchingKey = column.getName();
            this.columns.put(matchingKey, column);
            if (column.getAutoEnter() == AutoEnter.CreationTimestamp && creationStampColumn == null) {
                creationStampColumn = column.getName();
                continue;
            }
            if (column.getAutoEnter() != AutoEnter.ModificationTimestamp || modStampColumn != null) continue;
            modStampColumn = column.getName();
        }
        this.foreignKeys = foreignKeys;
        this.pkColumn1 = this.getColumnWithName(pkColumn1, true).orElse(null);
        this.pkColumn2 = this.getColumnWithName(pkColumn2, true).orElse(null);
        ColumnInfo potentialModStamp = this.getColumnWithName(modStampColumn, true).orElse(null);
        this.modStampColumn = potentialModStamp != null && (potentialModStamp.getDataType() == 93 || potentialModStamp.getDataType() == -5 || potentialModStamp.getDataType() == 8) ? potentialModStamp : null;
        ColumnInfo potentialCreationStamp = this.getColumnWithName(creationStampColumn, true).orElse(null);
        this.creationStampColumn = potentialCreationStamp != null && (potentialCreationStamp.getDataType() == 93 || potentialCreationStamp.getDataType() == -5 || potentialCreationStamp.getDataType() == 8) ? potentialCreationStamp : null;
        this.writeback = this.columns.get(writeback);
        this.isSchemaless = isSchemaless;
        this.tableSchemaHash = tableSchemaHash;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public String getTableOccurrenceName() {
        return this.tableOccurrenceName;
    }

    @Deprecated
    @NotNull
    public List<ColumnInfo> getColumns() {
        return this.getColumns(false);
    }

    public List<ColumnInfo> getColumns(boolean limitedToFieldsOnLayout) {
        return this.columns.values().stream().filter(col -> col.isPresentOnLayout() || !limitedToFieldsOnLayout).collect(Collectors.toList());
    }

    @NotNull
    public Optional<ColumnInfo> getPkColumn1() {
        return Optional.ofNullable(this.pkColumn1);
    }

    @NotNull
    public Optional<ColumnInfo> getPkColumn2() {
        return Optional.ofNullable(this.pkColumn2);
    }

    @NotNull
    public List<ForeignKeyInfo> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(@NotNull List<ForeignKeyInfo> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public Optional<ColumnInfo> getModStampColumn() {
        return Optional.ofNullable(this.modStampColumn);
    }

    public void setModStampColumn(ColumnInfo modStampColumn) {
        this.modStampColumn = modStampColumn;
    }

    public String getTableSchemaHash() {
        return this.tableSchemaHash;
    }

    @NotNull
    public Optional<ColumnInfo> getCreationStampColumn() {
        return Optional.ofNullable(this.creationStampColumn);
    }

    public void setCreationStampColumn(ColumnInfo creationStampColumn) {
        this.creationStampColumn = creationStampColumn;
    }

    @Override
    public int compareTo(TableInfo o) {
        return this.tableName.compareTo(o.tableName);
    }

    public Optional<ColumnInfo> getColumnWithName(String name, boolean exactMatch) {
        if (name == null) {
            return Optional.empty();
        }
        ColumnInfo result = this.columns.get(name);
        if (result == null && !exactMatch) {
            String nameNormalized = name.toLowerCase().replace(" ", "").replace("_", "");
            for (Map.Entry<String, ColumnInfo> entry : this.columns.entrySet()) {
                String eachColumnNormalized = entry.getKey().toLowerCase().replace(" ", "").replace("_", "");
                if (!nameNormalized.equals(eachColumnNormalized)) continue;
                return Optional.ofNullable(entry.getValue());
            }
        }
        return Optional.ofNullable(result);
    }

    public String toString() {
        return "TableInfo{tableName='" + this.tableName + '\'' + ", tableOccurrenceName='" + this.tableOccurrenceName + '\'' + ", pkColumn1=" + this.pkColumn1 + ", columns=" + this.columns.size() + ", foreignKeys=" + this.foreignKeys.size() + '}';
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSchemaless() {
        return this.isSchemaless;
    }

    public Optional<ColumnInfo> getWriteback() {
        return Optional.ofNullable(this.writeback);
    }

    public static class MapToList
    extends JsonSerializer<Map<?, ?>> {
        public void serialize(Map value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartArray();
            for (Object val : value.values()) {
                gen.writeObject(val);
            }
            gen.writeEndArray();
        }
    }

    public static class ColumnInfoToName
    extends JsonSerializer<ColumnInfo> {
        public void serialize(ColumnInfo value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeObject((Object)value.getName());
        }
    }
}

