/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.core.FeedbackException;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.ConflictStrategy;
import com.prosc.mirror.model.DeletionOption;
import com.prosc.mirror.model.ForeignKeyInfo;
import com.prosc.mirror.model.TableInfo;
import com.prosc.shared.Bool;
import com.prosc.sync.SyncDirection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableConfig
implements Serializable,
Comparable<TableConfig>,
Cloneable {
    private static final long serialVersionUID = 5L;
    private static final Logger log = Logger.getLogger(TableConfig.class.getName());
    public static final ColumnInfo MISSING_COLUMN = new ColumnInfo("MISSING_COLUMN", 12);
    private String tableName;
    @NotNull
    private final List<ForeignKeyInfo> foreignKeys;
    private transient boolean hub;
    private String tableOccurrenceName;
    private String pkGenerationSql;
    private String customWhereClause;
    private boolean customWhereClauseDistinct = false;
    @Nullable
    private ColumnInfo modTimestampColumn;
    private ColumnInfo creationTimestampColumn;
    private ColumnInfo writeback;
    @Nullable
    private DeletionOption deletionOption = DeletionOption.bothDirections;
    @Nullable
    private ColumnInfo deletedColumn;
    @NotNull
    private List<ColumnInfo> dataColumns;
    @Nullable
    private String tableSchemaHash;
    private List<ColumnInfo> primaryKeys;
    private transient PropertyChangeSupport pcs = null;
    private SyncDirection syncDirection2;
    private ConflictStrategy conflictStrategy = ConflictStrategy.UserPicks;
    private boolean uuid = false;
    private boolean autoMergeEnabled = true;
    private String syncDirectionLabel;
    private boolean preserveModification = false;
    private Set<String> ignoredFields = new HashSet<String>();
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.prosc.strings");
    private boolean createSchema;
    private boolean duplicate = false;
    private boolean virtual = false;
    private boolean limitedToFieldsOnLayout = false;

    public TableConfig() {
        this.primaryKeys = new ArrayList<ColumnInfo>(2);
        this.foreignKeys = new LinkedList<ForeignKeyInfo>();
        this.dataColumns = new LinkedList<ColumnInfo>();
        this.setSyncDirection(SyncDirection.readWrite);
    }

    public TableConfig(@NotNull TableInfo tableInfo) {
        this();
        this.setTableName(tableInfo.getTableName());
        this.setTableOccurrenceName(tableInfo.getTableOccurrenceName());
        this.setPrimaryKey1(tableInfo.getPkColumn1().orElse(null));
        this.setPrimaryKey2(tableInfo.getPkColumn2().orElse(null));
        this.setUUID(tableInfo.getPkColumn1().map(col -> col.getAutoEnter() != AutoEnter.Sequential && col.isWriteable()).orElse(false));
        this.setModTimestampColumn(tableInfo.getModStampColumn().orElse(null));
        this.setCreationTimestampColumn(tableInfo.getCreationStampColumn().orElse(null));
        this.setTableSchemaHash(tableInfo.getTableSchemaHash());
        this.getForeignKeys().addAll(tableInfo.getForeignKeys());
        tableInfo.getWriteback().ifPresent(this::setWriteback);
    }

    public TableConfig clone() {
        try {
            return (TableConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TableConfig(@NotNull String tableName, @Nullable String tableOccurrenceName, @NotNull ColumnInfo primaryKey1, @Nullable ColumnInfo primaryKey2, @Nullable ColumnInfo modTimestampColumn, @Nullable ColumnInfo creationTimestampColumn, @NotNull List<ColumnInfo> dataColumns, @NotNull List<ForeignKeyInfo> foreignKeys, boolean hub, SyncDirection syncDirection, ConflictStrategy conflictStrategy, boolean uuid, boolean autoMergeEnabled) throws FeedbackException {
        this.tableName = tableName;
        this.tableOccurrenceName = tableOccurrenceName;
        this.modTimestampColumn = modTimestampColumn;
        this.creationTimestampColumn = creationTimestampColumn;
        this.dataColumns = new ArrayList<ColumnInfo>(dataColumns);
        this.foreignKeys = foreignKeys;
        this.hub = hub;
        this.primaryKeys = new ArrayList<ColumnInfo>(2);
        this.setPrimaryKey1(primaryKey1);
        this.setPrimaryKey2(primaryKey2);
        this.setSyncDirection(syncDirection);
        this.setConflictStrategy(conflictStrategy);
        this.setUUID(uuid);
        this.setAutoMergeEnabled(autoMergeEnabled);
        this.validate();
    }

    @NotNull
    public List<ColumnInfo> getDataColumns() {
        return Collections.unmodifiableList(this.dataColumns);
    }

    public void clearDataColumns() {
        this.dataColumns.clear();
    }

    public void addDataColumn(ColumnInfo columnToAdd) {
        this.dataColumns.add(columnToAdd);
    }

    @Deprecated
    public void removeDataColumn(ColumnInfo columnToAdd) {
        this.dataColumns.remove(columnToAdd);
    }

    public boolean dataColumnsContain(ColumnInfo whichColumn) {
        return this.dataColumns.contains(whichColumn);
    }

    public int getDataColumnsCount() {
        return this.dataColumns.size();
    }

    @Nullable
    public ColumnInfo getModTimeColumn() {
        return this.modTimestampColumn;
    }

    public String getPkGenerationSql() {
        return this.pkGenerationSql;
    }

    public void setPkGenerationSql(String pkGenerationSql) {
        this.pkGenerationSql = pkGenerationSql;
    }

    public String getCustomWhereClause() {
        return this.customWhereClause;
    }

    public void setCustomWhereClause(String customWhereClause) {
        this.customWhereClause = customWhereClause;
        this.getPcs().firePropertyChange("customWhereClause", this.customWhereClause, this.customWhereClause);
    }

    public boolean isCustomWhereClauseDistinct() {
        return this.customWhereClauseDistinct;
    }

    public void setCustomWhereClauseDistinct(boolean customWhereClauseDistinct) {
        this.customWhereClauseDistinct = customWhereClauseDistinct;
        this.getPcs().firePropertyChange("customWhereClauseDistinct", this.customWhereClauseDistinct, this.customWhereClauseDistinct);
    }

    @Nullable
    public String getTableSchemaHash() {
        return this.tableSchemaHash;
    }

    public void setTableSchemaHash(@Nullable String tableSchemaHash) {
        this.tableSchemaHash = tableSchemaHash;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public List<ForeignKeyInfo> getForeignKeys() {
        return this.foreignKeys;
    }

    public String toString() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public void setModTimestampColumn(@Nullable ColumnInfo modTimestampColumn) {
        this.modTimestampColumn = modTimestampColumn;
        this.getPcs().firePropertyChange("modTimestampColumn", this.modTimestampColumn, this.modTimestampColumn);
    }

    public void setCreationTimestampColumn(@Nullable ColumnInfo creationTimestampColumn) {
        this.creationTimestampColumn = creationTimestampColumn;
    }

    @Nullable
    public ColumnInfo getCreationTimestampColumn() {
        return this.creationTimestampColumn;
    }

    public void setWriteback(ColumnInfo writeback) {
        this.writeback = writeback;
    }

    @Nullable
    public ColumnInfo getWriteback() {
        return this.writeback;
    }

    public void setHub(boolean hub) {
        this.hub = hub;
    }

    @Nullable
    public ColumnInfo getPrimaryKey1() {
        if (this.primaryKeys.size() == 0) {
            return null;
        }
        return this.primaryKeys.get(0);
    }

    public final void setPrimaryKey1(@Nullable ColumnInfo primaryKey1) {
        if (primaryKey1 == null) {
            if (this.primaryKeys.size() < 1) {
                return;
            }
            this.primaryKeys.remove(0);
        } else if (this.primaryKeys.size() == 0) {
            this.primaryKeys.add(primaryKey1);
        } else {
            this.primaryKeys.set(0, primaryKey1);
        }
    }

    @Nullable
    public ColumnInfo getPrimaryKey2() {
        if (this.primaryKeys.size() < 2) {
            return null;
        }
        return this.primaryKeys.get(1);
    }

    public final void setPrimaryKey2(@Nullable ColumnInfo primaryKey2) {
        if (primaryKey2 == null) {
            if (this.primaryKeys.size() < 2) {
                return;
            }
            this.primaryKeys.remove(1);
        } else if (this.primaryKeys.size() < 2) {
            this.primaryKeys.add(primaryKey2);
        } else {
            this.primaryKeys.set(1, primaryKey2);
        }
    }

    public boolean isPrimaryKeysSharedWithData() {
        return !Collections.disjoint(this.dataColumns, this.primaryKeys);
    }

    public List<ColumnInfo> getPrimaryKeys() {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>(2);
        if (this.getPrimaryKey1() != null) {
            result.add(this.getPrimaryKey1());
            if (this.getPrimaryKey2() != null) {
                result.add(this.getPrimaryKey2());
            }
        }
        return result;
    }

    public String getTableOccurrenceName() {
        return this.tableOccurrenceName;
    }

    public void refreshFrom(TableInfo info) {
        if (!info.isSchemaless()) {
            this.primaryKeys = this.replaceListFrom(this.primaryKeys, info, false);
            if (this.primaryKeys.isEmpty()) {
                info.getPkColumn1().ifPresent(this.primaryKeys::add);
            }
            this.dataColumns = this.replaceListFrom(this.dataColumns, info, this.isLimitedToFieldsOnLayout());
            if (this.modTimestampColumn == null) {
                this.modTimestampColumn = info.getModStampColumn().orElse(null);
            } else {
                this.setModTimestampColumn(info.getColumnWithName(this.modTimestampColumn.getName(), true).orElse(null));
            }
            if (this.creationTimestampColumn == null) {
                this.creationTimestampColumn = info.getCreationStampColumn().orElse(null);
            } else {
                this.setCreationTimestampColumn(info.getColumnWithName(this.creationTimestampColumn.getName(), true).orElse(null));
            }
            if (this.writeback != null) {
                this.setWriteback(info.getColumnWithName(this.writeback.getName(), true).orElse(null));
            }
        }
        this.setTableSchemaHash(info.getTableSchemaHash());
        this.setTableOccurrenceName(info.getTableOccurrenceName());
    }

    private List<ColumnInfo> replaceListFrom(List<ColumnInfo> columns, TableInfo info, boolean onlyFieldsOnLayout) {
        ArrayList<ColumnInfo> missingColumns = new ArrayList<ColumnInfo>(columns);
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>(missingColumns.size());
        HashSet<String> alreadyAdded = new HashSet<String>();
        Iterator<ColumnInfo> iterator = missingColumns.iterator();
        while (iterator.hasNext()) {
            ColumnInfo column = iterator.next();
            if (column == null) {
                log.warning("One of the columns passed to replaceListFrom contains a null element. This should not happen: " + columns);
                continue;
            }
            if (column == MISSING_COLUMN || "MISSING_COLUMN".equals(column.getName())) {
                result.add(MISSING_COLUMN);
                iterator.remove();
                continue;
            }
            Optional<ColumnInfo> columnOptional = info.getColumnWithName(column.getName(), true);
            if (columnOptional.isPresent()) {
                ColumnInfo col = columnOptional.get();
                if (onlyFieldsOnLayout && !col.isPresentOnLayout()) {
                    log.finest("Skipping field " + col.getName() + " because it's not on the layout, and the table config only allows fields on the sync layout");
                    result.add(MISSING_COLUMN);
                    continue;
                }
                if (alreadyAdded.add(column.getName().toLowerCase())) {
                    result.add(col);
                    iterator.remove();
                    continue;
                }
                log.log(Level.WARNING, "Duplicate column name '" + column + "' for " + info + ". Full column list: " + columns);
                result.add(MISSING_COLUMN);
                continue;
            }
            result.add(MISSING_COLUMN);
        }
        if (missingColumns.size() > 0) {
            log.log(Level.WARNING, "replaceListFrom was called on " + this.getTableName() + ", but some columns ar missing.\nInput columns: " + columns + "\nTableInfo columns: " + info.getColumns(onlyFieldsOnLayout) + "\nMissing columns: " + missingColumns);
        }
        return result;
    }

    public void setTableOccurrenceName(@NotNull String tableOccurrenceName) {
        this.tableOccurrenceName = tableOccurrenceName;
    }

    public boolean isPreserveModification() {
        return this.preserveModification;
    }

    public void setPreserveModification(boolean preserveModification) {
        this.preserveModification = preserveModification;
    }

    public List<String> getAllColumnNames(List<ColumnInfo> columnsInSyncOrder) {
        ArrayList<String> result = new ArrayList<String>(columnsInSyncOrder.size() + 4);
        for (ColumnInfo eachDataColumn : columnsInSyncOrder) {
            result.add(eachDataColumn.getName());
        }
        for (ColumnInfo columnInfo : this.getPrimaryKeys()) {
            result.add(columnInfo.getName());
        }
        if (this.modTimestampColumn != null) {
            result.add(this.modTimestampColumn.getName());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfig config = (TableConfig)o;
        return this.customWhereClauseDistinct == config.customWhereClauseDistinct && this.uuid == config.uuid && this.autoMergeEnabled == config.autoMergeEnabled && this.preserveModification == config.preserveModification && this.createSchema == config.createSchema && this.duplicate == config.duplicate && Objects.equals(this.tableName, config.tableName) && this.foreignKeys.equals(config.foreignKeys) && Objects.equals(this.tableOccurrenceName, config.tableOccurrenceName) && Objects.equals(this.pkGenerationSql, config.pkGenerationSql) && Objects.equals(this.customWhereClause, config.customWhereClause) && Objects.equals(this.modTimestampColumn, config.modTimestampColumn) && Objects.equals(this.creationTimestampColumn, config.creationTimestampColumn) && Objects.equals(this.writeback, config.writeback) && this.deletionOption == config.deletionOption && Objects.equals(this.deletedColumn, config.deletedColumn) && this.dataColumns.equals(config.dataColumns) && Objects.equals(this.primaryKeys, config.primaryKeys) && this.syncDirection2 == config.syncDirection2 && this.conflictStrategy == config.conflictStrategy && Objects.equals(this.syncDirectionLabel, config.syncDirectionLabel) && Objects.equals(this.ignoredFields, config.ignoredFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tableName, this.foreignKeys, this.tableOccurrenceName, this.pkGenerationSql, this.customWhereClause, this.customWhereClauseDistinct, this.modTimestampColumn, this.creationTimestampColumn, this.writeback, this.deletionOption, this.deletedColumn, this.dataColumns, this.primaryKeys, this.syncDirection2, this.conflictStrategy, this.uuid, this.autoMergeEnabled, this.syncDirectionLabel, this.preserveModification, this.ignoredFields, this.createSchema, this.duplicate});
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(listener);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPcs().firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isContainsBinaryFields() {
        for (ColumnInfo eachDataColumn : this.dataColumns) {
            if (!eachDataColumn.isBinary()) continue;
            return true;
        }
        return false;
    }

    public ForeignKeyInfo[] getOrderedForeignKeyArray(List<ColumnInfo> columns) {
        ForeignKeyInfo[] result = new ForeignKeyInfo[columns.size()];
        for (ForeignKeyInfo foreignKey : this.getForeignKeys()) {
            int index = -1;
            int n = 0;
            for (ColumnInfo column : columns) {
                if (Bool.equals(foreignKey.getFromColumn(), column.getName())) {
                    index = n;
                    break;
                }
                ++n;
            }
            if (index == -1) {
                throw new IllegalStateException("Foreign key " + foreignKey + " does not exist in data columns for table " + this.getTableName() + ". Columns: " + columns);
            }
            result[index] = foreignKey;
        }
        return result;
    }

    public void setSyncDirection(SyncDirection syncDirection) {
        this.syncDirection2 = syncDirection;
        this.firePropertyChange("syncDirection", this.syncDirection2, this.syncDirection2);
        String label = null;
        if (syncDirection == SyncDirection.readWrite) {
            label = resourceBundle.getString("syncDirection.readWrite");
        } else if (syncDirection == SyncDirection.writeOnlyRelaxed || syncDirection == SyncDirection.writeOnlyStrict) {
            label = resourceBundle.getString("syncDirection.writeOnly");
        } else if (syncDirection == SyncDirection.readOnly) {
            label = resourceBundle.getString("syncDirection.readOnly");
        }
        this.setSyncDirectionLabel(label);
    }

    public SyncDirection getSyncDirection() {
        return this.syncDirection2;
    }

    public void setSyncDirectionLabel(String syncDirectionLabel) {
        this.syncDirectionLabel = syncDirectionLabel;
        this.getPcs().firePropertyChange("syncDirectionLabel", this.syncDirectionLabel, this.syncDirectionLabel);
    }

    public String getSyncDirectionLabel() {
        return this.syncDirectionLabel;
    }

    public ConflictStrategy getConflictStrategy() {
        return this.conflictStrategy;
    }

    public void setConflictStrategy(ConflictStrategy conflictStrategy) {
        this.conflictStrategy = conflictStrategy;
        this.getPcs().firePropertyChange("conflictStrategy", (Object)this.conflictStrategy, (Object)this.conflictStrategy);
    }

    public boolean isUUID() {
        return this.uuid;
    }

    public void setUUID(boolean uuid) {
        this.uuid = uuid;
        this.getPcs().firePropertyChange("UUID", this.uuid, this.uuid);
    }

    public boolean isAutoMergeEnabled() {
        return this.autoMergeEnabled;
    }

    public void setAutoMergeEnabled(boolean autoMergeEnabled) {
        this.autoMergeEnabled = autoMergeEnabled;
        this.getPcs().firePropertyChange("autoMergeEnabled", this.autoMergeEnabled, this.autoMergeEnabled);
    }

    public boolean isWriteable(boolean hub) {
        return hub && this.syncDirection2.isReadable() || !hub && this.syncDirection2.isWriteable();
    }

    public boolean isReadable(boolean hub) {
        return hub && this.syncDirection2.isWriteable() || !hub && this.syncDirection2.isReadable();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ignoredFields == null) {
            this.ignoredFields = new HashSet<String>();
        }
    }

    @NotNull
    public Set<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    @Override
    public int compareTo(TableConfig o) {
        return this.tableName.compareTo(o.tableName);
    }

    public void validate() throws FeedbackException {
        if (this.primaryKeys.isEmpty()) {
            throw new FeedbackException("There is no primary key configured for table '" + this.tableName + "'");
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (ColumnInfo dataColumn : this.dataColumns) {
            if (!dupCheck.add(dataColumn.getName().toLowerCase())) {
                // empty if block
            }
            dataColumn.validate();
            if (!this.isLimitedToFieldsOnLayout() || dataColumn.isPresentOnLayout()) continue;
            throw new FeedbackException("Column '" + dataColumn.getName() + "' is present in the sync configuration, but is not on the sync layout.");
        }
        for (ForeignKeyInfo foreignKey : this.foreignKeys) {
            foreignKey.validate();
        }
        ArrayList<ColumnInfo> allColumns = new ArrayList<ColumnInfo>(this.dataColumns.size() + 5);
        allColumns.addAll(this.primaryKeys);
        allColumns.add(this.modTimestampColumn);
        allColumns.add(this.creationTimestampColumn);
        allColumns.addAll(this.dataColumns);
        Optional<ColumnInfo> missingColumn = allColumns.stream().filter(Objects::nonNull).filter(col -> MISSING_COLUMN.getName().equals(col.getName())).findAny();
        if (missingColumn.isPresent()) {
            throw new FeedbackException("One of the columns in table '" + this.tableName + "' has been removed or re-named, please edit the configuration to correct this.");
        }
        log.finest("Table '" + this.getTableName() + "' passed validation");
    }

    public void setBestPk(List<ColumnInfo> candidates) {
        if (candidates.size() == 1) {
            this.setPrimaryKey1(candidates.get(0));
        } else if (candidates.size() != 0) {
            Comparator<ColumnInfo> pkComparator = new Comparator<ColumnInfo>(){

                @Override
                public int compare(ColumnInfo o1, ColumnInfo o2) {
                    int score1 = 0;
                    int score2 = 0;
                    if (TableConfig.this.isUUID()) {
                        if (o1.getAutoEnter() == AutoEnter.UUID) {
                            score1 += 1000;
                        }
                        if (o2.getAutoEnter() == AutoEnter.UUID) {
                            score2 += 1000;
                        }
                        if (o1.isText()) {
                            score1 += 10;
                        }
                        if (o2.isText()) {
                            score2 += 10;
                        }
                    } else {
                        if (o1.getAutoEnter() == AutoEnter.Sequential) {
                            score1 += 1000;
                        }
                        if (o2.getAutoEnter() == AutoEnter.Sequential) {
                            score2 += 1000;
                        }
                        if (o1.isNumber()) {
                            score1 += 10;
                        }
                        if (o2.isNumber()) {
                            score2 += 10;
                        }
                    }
                    if (!o1.isIndexed()) {
                        score1 -= 2000;
                    }
                    if (!o2.isIndexed()) {
                        score2 -= 2000;
                    }
                    if (o1.getAutoEnter() != AutoEnter.None) {
                        score1 += 50;
                    }
                    if (o2.getAutoEnter() != AutoEnter.None) {
                        score2 += 50;
                    }
                    if (o1.getName().toLowerCase().startsWith("id") || o1.getName().toLowerCase().contains("pk")) {
                        score1 += 100;
                    }
                    if (o2.getName().toLowerCase().startsWith("id") || o2.getName().toLowerCase().contains("pk")) {
                        score2 += 100;
                    }
                    return score1 - score2;
                }
            };
            ArrayList<ColumnInfo> sortedList = new ArrayList<ColumnInfo>(candidates);
            sortedList.sort(pkComparator);
            ColumnInfo bestCandidate = sortedList.get(sortedList.size() - 1);
            ColumnInfo nextCandidate = sortedList.get(sortedList.size() - 2);
            if (pkComparator.compare(bestCandidate, nextCandidate) != 0) {
                this.setPrimaryKey1(bestCandidate);
            }
        }
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public boolean isLimitedToFieldsOnLayout() {
        return this.limitedToFieldsOnLayout;
    }

    public void setLimitedToFieldsOnLayout(boolean limitedToFieldsOnLayout) {
        if (limitedToFieldsOnLayout && !this.limitedToFieldsOnLayout) {
            if (this.getPrimaryKey1() != null && !this.getPrimaryKey1().isPresentOnLayout()) {
                log.warning("Removing primary key column from table configuration " + this + " becauase the sync is set to only include fields on the layout, and that field is not present: " + this.getPrimaryKey1());
                this.setPrimaryKey1(null);
            }
            if (this.getPrimaryKey2() != null && !this.getPrimaryKey2().isPresentOnLayout()) {
                log.warning("Removing primary key 2 column from table configuration " + this + " becauase the sync is set to only include fields on the layout, and that field is not present: " + this.getPrimaryKey2());
                this.setPrimaryKey2(null);
            }
            if (this.getModTimeColumn() != null && !this.getModTimeColumn().isPresentOnLayout()) {
                log.warning("Removing mod timestamp column from table configuration " + this + " becauase the sync is set to only include fields on the layout, and that field is not present: " + this.getModTimeColumn());
                this.setModTimestampColumn(null);
            }
            if (this.getCreationTimestampColumn() != null && !this.getCreationTimestampColumn().isPresentOnLayout()) {
                log.warning("Removing creation timestamp column from table configuration " + this + " becauase the sync is set to only include fields on the layout, and that field is not present: " + this.getCreationTimestampColumn());
                this.setCreationTimestampColumn(null);
            }
            if (this.getWriteback() != null && !this.getWriteback().isPresentOnLayout()) {
                log.warning("Removing writeback column from table configuration " + this + " becauase the sync is set to only include fields on the layout, and that field is not present: " + this.getWriteback());
                this.setWriteback(null);
            }
            this.dataColumns.removeIf(eachColumn -> !eachColumn.isPresentOnLayout());
            this.foreignKeys.removeIf(eachKey -> this.dataColumns.stream().map(ColumnInfo::getName).noneMatch(columnName -> columnName.equals(eachKey.getFromColumn())));
        }
        this.limitedToFieldsOnLayout = limitedToFieldsOnLayout;
        this.getPcs().firePropertyChange("limitedToFieldsOnLayout", this.limitedToFieldsOnLayout, this.limitedToFieldsOnLayout);
    }

    @Nullable
    public ColumnInfo getDeletedColumn() {
        return this.deletedColumn;
    }

    public void setDeletedColumn(@Nullable ColumnInfo deletedColumn) {
        this.deletedColumn = deletedColumn;
    }

    public boolean isPrimaryKeyAlsoData() {
        return this.getPrimaryKey2() != null;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    @Nullable
    public DeletionOption getDeletionOption() {
        if (this.deletionOption == null) {
            this.deletionOption = DeletionOption.bothDirections;
        }
        return this.deletionOption;
    }

    public void setDeletionOption(@Nullable DeletionOption deletionOption) {
        this.deletionOption = deletionOption;
        this.getPcs().firePropertyChange("deletionOption", (Object)this.deletionOption, (Object)this.deletionOption);
    }

    public void updateOptionsFrom(TableConfig otherConfig) {
        this.setUUID(otherConfig.isUUID());
        this.setAutoMergeEnabled(otherConfig.autoMergeEnabled);
        this.setConflictStrategy(otherConfig.conflictStrategy);
        this.setDeletionOption(otherConfig.deletionOption);
        this.setPreserveModification(otherConfig.preserveModification);
        this.setSyncDirection(otherConfig.getSyncDirection());
        this.setSyncDirectionLabel(otherConfig.getSyncDirectionLabel());
        this.setLimitedToFieldsOnLayout(otherConfig.limitedToFieldsOnLayout);
    }

    public Optional<ColumnInfo> getDataColumnWithName(String name) {
        for (ColumnInfo dataColumn : this.dataColumns) {
            if (!dataColumn.getName().equals(name)) continue;
            return Optional.of(dataColumn);
        }
        return Optional.empty();
    }
}

