/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.sync.InitialSyncModeUnspecifiedException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import org.jetbrains.annotations.Nullable;

public class SyncStatus
implements Serializable {
    private static final long serialVersionUID = 4L;
    private static final Logger log = Logger.getLogger(SyncStatus.class.getName());
    private String text;
    private boolean syncActive;
    private BoundedRangeModel progress;
    private String exceptionMesssage;
    private String demoWarning;
    private transient Object engine;
    private Short licenseMajorVersion;
    private String cancelMessage;
    private InitialSyncModeUnspecifiedException initialSyncModeUnspecifiedException;
    private String configName;
    private String hubName;
    private String firstSpokeName;

    public synchronized String getText() {
        if (this.text == null && this.demoWarning == null) {
            return null;
        }
        if (this.text == null) {
            return this.demoWarning;
        }
        if (this.demoWarning == null) {
            return this.text;
        }
        return this.text + "\n\n" + this.demoWarning;
    }

    public synchronized void setText(String text, boolean shouldLog) {
        if (shouldLog) {
            log.info(text);
        }
        this.text = text;
        this.notifyAll();
    }

    public synchronized boolean isSyncActive() {
        return this.syncActive;
    }

    public synchronized void setSyncActive(boolean syncActive) {
        this.syncActive = syncActive;
    }

    public BoundedRangeModel getProgress() {
        return this.progress;
    }

    public void setProgress(@Nullable BoundedRangeModel progress) {
        this.progress = progress;
    }

    public synchronized InitialSyncModeUnspecifiedException getInitialSyncModeUnspecifiedException() {
        return this.initialSyncModeUnspecifiedException;
    }

    public synchronized void setInitialSyncModeUnspecifiedException(InitialSyncModeUnspecifiedException initialSyncModeUnspecifiedException) {
        this.initialSyncModeUnspecifiedException = initialSyncModeUnspecifiedException;
    }

    public synchronized void setException(@Nullable Throwable e) {
        if (e == null) {
            this.exceptionMesssage = null;
        } else {
            log.log(Level.WARNING, "Exception during sync", e);
            this.exceptionMesssage = e instanceof RuntimeException || e instanceof Error ? e.toString() : e.getMessage();
        }
    }

    public synchronized String getExceptionMesssage() {
        return this.exceptionMesssage;
    }

    public synchronized void setDemoWarning(String demoWarning) {
        this.demoWarning = demoWarning;
    }

    public synchronized String getDemoWarning() {
        return this.demoWarning;
    }

    public void setEngine(@Nullable Object engine) {
        this.engine = engine;
    }

    public Object getEngine() {
        return this.engine;
    }

    public void setLicenseMajorVersion(Short licenseMajorVersion) {
        this.licenseMajorVersion = licenseMajorVersion;
    }

    @Nullable
    public Short getLicenseMajorVersion() {
        return this.licenseMajorVersion;
    }

    public synchronized void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    public synchronized String getCancelMessage() {
        return this.cancelMessage;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getHubName() {
        return this.hubName;
    }

    public void setHubName(String hubName) {
        this.hubName = hubName;
    }

    public String getFirstSpokeName() {
        return this.firstSpokeName;
    }

    public void setFirstSpokeName(String firstSpokeName) {
        this.firstSpokeName = firstSpokeName;
    }
}

