/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.prosc.core.FeedbackException;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.shared.StringUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.Nullable;

public class SqlProperties
implements DatabaseProperties,
Cloneable {
    private static final long serialVersionUID = 2L;
    private transient DesSupport des = null;
    private String hostname;
    private String username;
    private String password;
    private String database;
    private String schema;
    private boolean ssl;
    @JsonIgnore
    private IDatabaseType type2;
    private String portNumberOverride;
    private transient PropertyChangeSupport pcs;
    @Nullable
    private String nickname;
    @Nullable
    private UUID uniqueId;

    public SqlProperties(@Nullable UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public SqlProperties(SqlProperties properties) {
        this.uniqueId = properties.uniqueId;
        this.hostname = properties.hostname;
        this.username = properties.username;
        this.password = properties.password;
        this.database = properties.database;
        this.schema = properties.schema;
        this.ssl = properties.ssl;
        this.nickname = properties.nickname;
        this.portNumberOverride = properties.portNumberOverride;
        this.type2 = properties.type2;
    }

    @Override
    public SqlProperties clone() throws CloneNotSupportedException {
        return (SqlProperties)super.clone();
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    public String getNickname() {
        return StringUtils.isEmpty(this.nickname) ? this.getName() : this.nickname;
    }

    public void setNickname(@Nullable String nickname) {
        this.nickname = nickname;
    }

    @Override
    public void validate() throws FeedbackException {
        if (!(this.getType().getClass().getName().endsWith("FileMakerClient") || this.hostname != null && this.hostname.length() != 0)) {
            throw new FeedbackException("Database hostname must not be empty");
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.getPcs().firePropertyChange("hostname", this.hostname, this.hostname);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.getPcs().firePropertyChange("username", this.username, this.username);
    }

    public String getPassword_encrypted() {
        return this.password;
    }

    public String getPassword() {
        String result = this.password;
        if (result != null) {
            result = this.getDes().decrypt(result);
        }
        return result;
    }

    public void setPassword(@Nullable String newPassword) {
        String encryptedPassword = newPassword;
        if (encryptedPassword != null) {
            encryptedPassword = this.getDes().encrypt(encryptedPassword);
        }
        String oldValue = this.getPassword();
        this.password = encryptedPassword;
        this.getPcs().firePropertyChange("password", oldValue, newPassword);
    }

    protected DesSupport getDes() {
        if (this.des == null) {
            this.des = new DesSupport(new SecretKeySpec(new String(new char[]{'i', 'n', 's', 'e', 'c', 'u', 'r', '3'}).getBytes(), "DES"));
        }
        return this.des;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
        this.getPcs().firePropertyChange("ssl", this.ssl, this.ssl);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (schema != null && schema.length() == 0) {
            schema = null;
        }
        this.schema = schema;
        this.pcs.firePropertyChange("schema", this.schema, this.schema);
    }

    @Nullable
    public String getPortNumberOverride() {
        return this.portNumberOverride;
    }

    public void setPortNumberOverride(String portNumberOverride) {
        this.portNumberOverride = portNumberOverride;
        this.getPcs().firePropertyChange("portNumberverride", this.portNumberOverride, this.portNumberOverride);
    }

    public void setDatabase(String database) {
        this.database = database;
        this.getPcs().firePropertyChange("database", this.database, this.database);
    }

    @Override
    public IDatabaseType getType() {
        return this.type2;
    }

    public String toString() {
        return "SqlProperties{name='" + this.getName() + '\'' + ", hostname='" + this.hostname + '\'' + ", username='" + this.username + '\'' + ", database='" + this.database + '\'' + ", type=" + this.getType() + '}';
    }

    @Override
    public String getDescription() {
        return this.getHostname() + " / " + this.getDatabase() + " (" + this.getNickname() + ")";
    }

    @Override
    @Nullable
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlProperties that = (SqlProperties)o;
        if (this.ssl != that.ssl) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.database != null ? !this.database.equals(that.database) : that.database != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return this.portNumberOverride != null ? this.portNumberOverride.equals(that.portNumberOverride) : that.portNumberOverride == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.ssl ? 1 : 0);
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + (this.portNumberOverride != null ? this.portNumberOverride.hashCode() : 0);
        return result;
    }

    public DatabaseProperties cloneWith(String username, String password) {
        try {
            SqlProperties result = this.clone();
            result.setUsername(username);
            result.setPassword(password);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    protected PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getSyncStoreIdentifier() {
        return this.getHostname() + "_" + this.getDatabase();
    }

    @Override
    public void writeFields(JsonGenerator gen) throws IOException {
        gen.writeStringField("type2ClassName", this.getType().getClass().getName());
        gen.writeStringField("hostname", this.hostname);
        gen.writeStringField("username", this.username);
        gen.writeStringField("password", this.password);
        gen.writeStringField("database", this.database);
        if (this.schema != null) {
            gen.writeStringField("schema", this.schema);
        }
        gen.writeBooleanField("ssl", this.ssl);
        if (this.portNumberOverride != null) {
            gen.writeStringField("portNumberOverride", this.portNumberOverride);
        }
        if (this.nickname != null) {
            gen.writeStringField("nickname", this.nickname);
        }
        if (this.uniqueId != null) {
            gen.writeStringField("uniqueId", this.uniqueId.toString());
        }
    }

    @Override
    public void readFields(JsonNode node, JsonParser p) {
        this.hostname = node.at("/hostname").asText(null);
        this.username = node.at("/username").asText(null);
        this.password = node.at("/password").asText(null);
        this.database = node.at("/database").asText(null);
        this.schema = node.at("/schema").asText(null);
        this.ssl = node.get("ssl").asBoolean(false);
        this.portNumberOverride = Optional.ofNullable(node.get("portNumberOverride")).map(JsonNode::textValue).orElse(null);
        this.nickname = node.at("/nickname").asText(null);
        this.uniqueId = Optional.ofNullable(node.get("uniqueId")).map(JsonNode::textValue).map(UUID::fromString).orElse(null);
    }

    public static class DesSupport {
        private Cipher ecipher;
        private Cipher dcipher;

        public DesSupport(SecretKey key) {
            try {
                this.ecipher = Cipher.getInstance("DES");
                this.dcipher = Cipher.getInstance("DES");
                this.ecipher.init(1, key);
                this.dcipher.init(2, key);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String encrypt(String str) {
            try {
                byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
                byte[] enc = this.ecipher.doFinal(utf8);
                return Base64.getEncoder().encodeToString(enc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String decrypt(String str) {
            try {
                byte[] dec = Base64.getDecoder().decode(str);
                byte[] utf8 = this.dcipher.doFinal(dec);
                return new String(utf8, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

