/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.core.FeedbackException;
import com.prosc.mirror.config.client.WizardModel;
import com.prosc.shared.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SetupState
implements Serializable {
    private static final long serialVersionUID = 3L;
    boolean syncTableExists;
    boolean syncScriptExists;
    boolean syncLayoutIsSetup;
    private boolean syncScriptVersionOK;
    private boolean tablesPresent;
    private String warningMessage;
    @Nullable
    private String configId;
    private String layoutWarning;
    private final List<String> syncTableNames = new LinkedList<String>();
    private String tableWarning;
    private String scriptWarning;
    private String errorMessage;
    private int errorCode = 0;
    private String syncUrl;
    private String syncUrlExternal;
    private String syncUrlStatus;
    private String syncUrlExternalStatus;
    private boolean layoutDamaged;

    public boolean isSyncTableExists() {
        return this.syncTableExists;
    }

    public boolean isSyncScriptExists() {
        return this.syncScriptExists;
    }

    public boolean isSyncLayoutIsSetup() {
        return this.syncLayoutIsSetup;
    }

    public void setSyncTableExists(boolean syncTableExists) {
        this.syncTableExists = syncTableExists;
    }

    public void setSyncScriptExists(boolean syncScriptExists) {
        this.syncScriptExists = syncScriptExists;
    }

    public void setSyncLayoutIsSetup(boolean syncLayoutIsSetup) {
        this.syncLayoutIsSetup = syncLayoutIsSetup;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isAllOkay() {
        return this.syncTableExists && this.syncScriptExists && this.syncLayoutIsSetup && this.syncScriptVersionOK && (this.tablesPresent || this.syncTableNames.isEmpty());
    }

    public boolean isSyncScriptVersionOK() {
        return this.syncScriptVersionOK;
    }

    public void setSyncScriptVersionOK(boolean syncScriptVersionOK) {
        this.syncScriptVersionOK = syncScriptVersionOK;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(@Nullable String warningMessage) {
        this.warningMessage = warningMessage;
    }

    @Nullable
    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(@Nullable String configId) {
        this.configId = configId;
    }

    public String getLayoutWarning() {
        return this.layoutWarning;
    }

    public void setLayoutWarning(@Nullable String layoutWarning) {
        this.layoutWarning = layoutWarning;
    }

    public void setTableWarning(String tableWarning) {
        this.tableWarning = tableWarning;
    }

    public String getTableWarning() {
        return this.tableWarning;
    }

    public String getScriptWarning() {
        return this.scriptWarning;
    }

    public void setScriptWarning(String scriptWarning) {
        this.scriptWarning = scriptWarning;
    }

    public boolean isTablesPresent() {
        return this.tablesPresent;
    }

    public void setTablesPresent(boolean tablesPresent) {
        this.tablesPresent = tablesPresent;
    }

    public void setSyncTableNames(Collection<String> syncTableNames) {
        this.syncTableNames.clear();
        this.syncTableNames.addAll(syncTableNames);
    }

    public List<String> getSyncTableNames() {
        return Collections.unmodifiableList(this.syncTableNames);
    }

    public void validate(boolean validateSyncScript, WizardModel model) throws FeedbackException {
        if (this.isAllOkay()) {
            return;
        }
        if (!this.syncTableExists) {
            throw new FeedbackException("MirrorSync table does not exist");
        }
        if (!this.syncScriptExists) {
            throw new FeedbackException("The MirrorSync script does not exist");
        }
        String expectedSyncUrl = model.getSyncServerUrlFromSpoke(true).toString();
        if (!this.syncUrl.equals(expectedSyncUrl)) {
            this.syncUrlStatus = StringUtils.isEmpty(this.syncUrl) ? "Sync URL is not set in the MirrorSync script" : (this.syncUrl.equalsIgnoreCase(expectedSyncUrl) ? "Sync URL is set, but the capitalization does not match. Please copy and paste the value exactly." : "Sync URL does not match the expected value. Please copy and paste the value exactly.");
            throw new FeedbackException(this.syncUrlStatus);
        }
        this.syncUrlStatus = "OK";
        if (model.getCurrentConfig().isExternalAddressesDifferent()) {
            String expectedExternalSyncUrl = model.getSyncServerUrlFromSpoke(false).toString();
            if (this.syncUrlExternal.equals(expectedExternalSyncUrl)) {
                this.syncUrlExternalStatus = "OK";
            } else {
                this.syncUrlExternalStatus = StringUtils.isEmpty(this.syncUrlExternal) ? "External Sync URL is not set in the MirrorSync script" : (this.syncUrlExternal.equalsIgnoreCase(expectedExternalSyncUrl) ? "External Sync URL is set, but the capitalization does not match. Please copy and paste the value exactly." : "External Sync URL does not match the expected value. Please copy and paste the value exactly.");
                throw new FeedbackException(this.syncUrlExternalStatus);
            }
        }
        if (!this.syncLayoutIsSetup) {
            throw new FeedbackException("MirrorSync layout is missing required elements");
        }
        if (validateSyncScript && !this.syncScriptVersionOK) {
            throw new FeedbackException("MirrorSync script is out of date or missing script steps");
        }
    }

    public String getSyncUrlStatus() {
        return this.syncUrlStatus;
    }

    public String getSyncUrlExternalStatus() {
        return this.syncUrlExternalStatus;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setSyncUrl(String url) {
        this.syncUrl = url;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void setSyncUrlExternal(String external) {
        this.syncUrlExternal = external;
    }

    public String getSyncUrlExternal() {
        return this.syncUrlExternal;
    }

    public boolean noWarnings() {
        return StringUtils.isEmpty(this.getLayoutWarning()) && StringUtils.isEmpty(this.getScriptWarning()) && StringUtils.isEmpty(this.getTableWarning()) && StringUtils.isEmpty(this.getWarningMessage());
    }

    public void setLayoutDamaged(boolean layoutDamaged) {
        this.layoutDamaged = layoutDamaged;
    }

    public boolean getLayoutDamaged() {
        return this.layoutDamaged;
    }
}

