/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.core.FeedbackException;
import com.prosc.deployment.DeploymentInfo;
import com.prosc.exception.UserCanceledException;
import com.prosc.io.InputStreamInfo;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.mirror.config.NoSuchTableException;
import com.prosc.mirror.model.DatabaseDownloadInfo;
import com.prosc.mirror.model.DatabaseInfo;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.FMServerPropertiesV6;
import com.prosc.mirror.model.ForeignKeyInfo;
import com.prosc.mirror.model.HostedDatabaseOrFolder;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.LicenseInfo;
import com.prosc.mirror.model.MirrorConfig;
import com.prosc.mirror.model.MirrorSyncException;
import com.prosc.mirror.model.ServerStatus;
import com.prosc.mirror.model.ServerUnavailableException;
import com.prosc.mirror.model.SetupState;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.SyncAlreadyRunningException;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.TableInfo;
import com.prosc.mirror.model.ValidationParam;
import com.prosc.security.LoginFailedException;
import com.prosc.sync.InitialSyncMode;
import com.prosc.sync.MissingConfigurationException;
import com.prosc.sync.NoSuchDatabaseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MirrorConfigServer
extends Remote,
Closeable {
    public ServerStatus getServerStatus() throws RemoteException, MirrorSyncException;

    public List<DatabaseInfo> getDatabases(DatabaseProperties var1) throws RemoteException, MirrorSyncException;

    public List<String> getSchemas(DatabaseProperties var1) throws RemoteException, MirrorSyncException;

    @NotNull
    public Collection<String> getTableNames(DatabaseProperties var1) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public TableInfo getTableDetailInfo(DatabaseProperties var1, String var2) throws RemoteException, MirrorSyncException, NoSuchTableException;

    public Collection<TableInfo> getTableDetailInfos(DatabaseProperties var1, Collection<String> var2) throws RemoteException, MirrorSyncException, NoSuchTableException;

    public void addConfig(MirrorConfig var1, boolean var2) throws RemoteException, IOException, InvalidLicenseException, UserCanceledException, MirrorSyncException;

    public void removeConfig(UUID var1) throws RemoteException, MissingConfigurationException, UserCanceledException;

    public void removeSyncData(UUID var1) throws IOException, MissingConfigurationException, UserCanceledException;

    public void clearConfigurationCaches(MirrorConfig var1) throws MirrorSyncException, RemoteException;

    @NotNull
    public Map<UUID, Integer> getSchedules() throws RemoteException;

    public void setSchedule(UUID var1, int var2) throws RemoteException;

    public void removeScheduledSync(UUID var1) throws RemoteException;

    public void previewSync(MirrorConfig var1) throws RemoteException, SyncAlreadyRunningException;

    public void doSync(@NotNull MirrorConfig var1, InitialSyncMode var2, Object var3) throws RemoteException;

    public void pauseAllSync(boolean var1) throws RemoteException;

    public void startAllSync() throws RemoteException;

    public void createDatabase(DatabaseProperties var1, String var2, String var3) throws RemoteException, MirrorSyncException, UnsupportedOperationException;

    public void createTimestamp(DatabaseProperties var1, String var2, String var3, boolean var4) throws RemoteException, MirrorSyncException, UnsupportedOperationException, NoSuchDatabaseException;

    public void createPrimaryKey(DatabaseProperties var1, String var2, String var3, boolean var4) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public String createTableSQL(DatabaseProperties var1, @Nullable DatabaseProperties var2, List<TableConfig> var3) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public void executeSql(DatabaseProperties var1, String var2) throws RemoteException, MirrorSyncException, UnsupportedOperationException, NoSuchDatabaseException;

    public SetupState getSetupState(String var1, DatabaseProperties var2, SetupState var3, boolean var4) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public MirrorConfig validateSyncConfiguration(MirrorConfig var1, @Nullable EnumSet<ValidationParam> var2, int var3, boolean var4, boolean var5, boolean var6) throws RemoteException, MirrorSyncException, NoSuchDatabaseException, InvalidLicenseException;

    public InputStreamInfo downloadDatabases(MirrorConfig var1) throws RemoteException, IOException, LoginFailedException, ServerUnavailableException, UserCanceledException, MirrorSyncException;

    public DatabaseDownloadInfo createDownloadURL(String var1, boolean var2, boolean var3) throws RemoteException, MissingConfigurationException, UserCanceledException, FeedbackException;

    public void validateFmsAdminCredentials(@NotNull MirrorConfig var1, String var2, String var3, boolean var4) throws RemoteException, LoginFailedException, ServerUnavailableException;

    public MirrorConfig revokeDownloadURL(String var1) throws RemoteException, UserCanceledException, MissingConfigurationException;

    public Serializable getDatabaseMetaData(DatabaseProperties var1) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public void cacheDatabaseForProperties(DatabaseProperties var1) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public List<MirrorConfig> getConfigurations() throws RemoteException;

    public LicenseInfo setRegistration(String var1, String var2) throws RemoteException, InvalidLicenseException;

    public LicenseInfo getLicenseInfo(boolean var1, boolean var2) throws RemoteException, IOException;

    public LicenseInfo removeDevices(List<Integer> var1) throws RemoteException;

    public void validateAdditionalSolutionAllowed(@Nullable MirrorConfig var1) throws RemoteException, IOException, InvalidLicenseException;

    public HostedDatabaseOrFolder getDbStructure(MirrorConfig var1, FMServerPropertiesV6 var2) throws RemoteException, MirrorSyncException;

    public Collection<IDatabaseType> getDatabaseTypes() throws RemoteException;

    public void testConnectionTo(SqlProperties var1) throws RemoteException, MirrorSyncException;

    public Map<String, Set<ForeignKeyInfo>> autoDetectForeignKeys(DatabaseProperties var1, List<TableConfig> var2, Collection<TableInfo> var3, String var4) throws RemoteException, MirrorSyncException;

    public String getContextName() throws RemoteException;

    public void rebuildSyncData(MirrorConfig var1, Date var2) throws RemoteException;

    public DeploymentInfo getVersionInfo() throws RemoteException;

    public boolean isDownloadPasswordRequired() throws RemoteException;

    public String generateSetupScriptsXml(Integer var1, Locale var2, String var3) throws RemoteException;

    public void rewindSyncTime(MirrorConfig var1, Date var2, Collection<String> var3) throws RemoteException, MirrorSyncException, UserCanceledException;

    public boolean isSpokeSchemaNeeded(MirrorConfig var1) throws RemoteException;

    public int runExampleQuery(MirrorConfig var1, TableConfig var2, boolean var3, String var4, String var5, Date var6) throws RemoteException, MirrorSyncException;

    public void compactSyncData(UUID var1) throws RemoteException, IOException, MissingConfigurationException, MirrorSyncException, UserCanceledException;

    public void repairSyncData(UUID var1) throws RemoteException, MirrorSyncException;

    public TableConfig duplicateTableConfiguration(DatabaseProperties var1, MirrorConfig var2, TableConfig var3) throws RemoteException;

    public List<TableInfo> duplicateTableInfos(@NotNull DatabaseProperties var1, List<TableInfo> var2) throws RemoteException;

    public List<TableConfig> postProcessTableConfiguration(DatabaseProperties var1, MirrorConfig var2, List<TableConfig> var3) throws RemoteException, MirrorSyncException, NoSuchDatabaseException;

    public void enableXmlWebPublishing(String var1, String var2, String var3) throws RemoteException, MirrorSyncException;

    public String invalidDataCheck(UUID var1) throws UserCanceledException, MissingConfigurationException, MirrorSyncException, InvalidLicenseException, RemoteException;
}

