/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.MirrorConfig;
import com.prosc.mirror.model.TableConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MirrorConfigDiff {
    Collection<String> addedTables;
    Collection<String> removedTables;
    Map<String, List<ColumnDiff>> columnDifferencesByTable = new LinkedHashMap<String, List<ColumnDiff>>();

    MirrorConfigDiff(@NotNull MirrorConfig oldConfig, @NotNull MirrorConfig newConfig) {
        List oldTableNames = oldConfig.getHubTables().stream().map(TableConfig::getTableName).collect(Collectors.toList());
        List newTableNames = newConfig.getHubTables().stream().map(TableConfig::getTableName).collect(Collectors.toList());
        this.addedTables = new HashSet(newTableNames);
        this.addedTables.removeAll(oldTableNames);
        this.removedTables = new HashSet(oldTableNames);
        this.removedTables.removeAll(newTableNames);
        for (TableConfig eachOldTable : oldConfig.getHubTables()) {
            if (this.removedTables.contains(eachOldTable.getTableName())) continue;
            TableConfig newHubTable = newConfig.getHubTableWithName(eachOldTable.getTableName());
            HashSet<String> oldColumnNames = new HashSet<String>();
            for (ColumnInfo oldColumn : eachOldTable.getDataColumns()) {
                oldColumnNames.add(oldColumn.getName());
                ColumnInfo newColumn = newHubTable.getDataColumnWithName(oldColumn.getName()).orElse(null);
                if (this.columnsAreExactlyEqual(oldColumn, newColumn)) continue;
                List columnDiffs = this.columnDifferencesByTable.computeIfAbsent(eachOldTable.getTableName(), k -> new ArrayList());
                columnDiffs.add(new ColumnDiff(oldColumn, newColumn));
            }
            for (ColumnInfo newColumn : newHubTable.getDataColumns()) {
                if (oldColumnNames.contains(newColumn.getName())) continue;
                List columnDiffs = this.columnDifferencesByTable.computeIfAbsent(eachOldTable.getTableName(), k -> new ArrayList());
                columnDiffs.add(new ColumnDiff(null, newColumn));
            }
        }
    }

    private boolean columnsAreExactlyEqual(ColumnInfo oldColumn, ColumnInfo newColumn) {
        if (oldColumn == null || newColumn == null) {
            return false;
        }
        return oldColumn.equals(newColumn);
    }

    public static final class ColumnDiff {
        @Nullable
        public final ColumnInfo oldColumn;
        @Nullable
        public final ColumnInfo newColumn;

        public ColumnDiff(@Nullable ColumnInfo oldColumn, @Nullable ColumnInfo newColumn) {
            this.oldColumn = oldColumn;
            this.newColumn = newColumn;
        }

        public String toString() {
            if (this.oldColumn == null) {
                return "Added " + this.newColumn;
            }
            if (this.newColumn == null) {
                return "Removed " + this.oldColumn;
            }
            return "Changes to " + this.oldColumn.getName();
        }
    }
}

