/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.prosc.core.FeedbackException;
import com.prosc.io.SerializeUtils;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.DatabaseType2;
import com.prosc.mirror.model.FMServerPropertiesV6;
import com.prosc.mirror.model.FileMakerGoPropertiesV6;
import com.prosc.mirror.model.FileMakerPropertiesV6;
import com.prosc.mirror.model.ForeignKeyInfo;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.ServerInitialSyncData;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.SyncType;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.dbtypes.FileMakerGo;
import com.prosc.mirror.model.dbtypes.FileMakerGoV6;
import com.prosc.mirror.model.dbtypes.FileMakerServer;
import com.prosc.mirror.model.dbtypes.FileMakerServerV6;
import com.prosc.mirror.model.dbtypes.Oracle;
import com.prosc.shared.StringUtils;
import com.prosc.sync.SyncDirection;
import com.prosc.util.UrlUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MirrorConfig
implements Serializable,
Cloneable,
Comparable<MirrorConfig> {
    private static final Logger log = Logger.getLogger(MirrorConfig.class.getName());
    private static final long serialVersionUID = 6L;
    public static final ObjectMapper jsonConfigMapper;
    private UUID id = UUID.randomUUID();
    private final int version = 2;
    private Date created;
    private Date modified;
    private String name;
    private DatabaseProperties hubDatabaseProperties;
    @NotNull
    private List<DatabaseProperties> spokesDatabaseProperties = new ArrayList<DatabaseProperties>();
    private final List<TableConfig> hubTables;
    private final List<TableConfig> spokeTables;
    private String syncServerInternalAddress = null;
    private String syncServerExternalAddress = null;
    private boolean externalAddressesDifferent = false;
    private boolean schemaMapped = false;
    private boolean useHubCredentials;
    private Float fmVersion;
    private final boolean offersDownload = true;
    private String awsAccessKey = null;
    private String awsSecretKey = null;
    private boolean cloudWatchNotifications = false;
    private Set<String> cloudWatchMetrics = null;
    private String snsErrorTopic = null;
    private String awsRegionName = null;
    private boolean detectLayouts = true;
    private String layoutScanPrefix = "Sync_";
    private boolean expressSetup = true;
    @JsonIgnore
    private LocalTime serverCopyStart;
    @JsonIgnore
    private LocalTime serverCopyEnd;
    private boolean serverCopyAnytime = false;
    private Integer msVersion = 6;
    private transient PropertyChangeSupport pcs = null;
    private final Collection<String> fullDownloadUUIDs = new ArrayList<String>();
    private final Collection<String> cloneDownloadUUIDs = new ArrayList<String>();
    private Collection<String> fullInitialSyncUUIDs = new ArrayList<String>();
    private Collection<String> cloneInitialSyncUUIDs = new ArrayList<String>();
    private final Collection<String> triggerUUIDs = new ArrayList<String>();
    private final Collection<String> autoupdateUUIDs = new ArrayList<String>();
    private final Collection<ServerInitialSyncData> serverInitialSyncUUIDs = new ArrayList<ServerInitialSyncData>();
    private String downloadUsername;
    private String downloadPassword;
    @Deprecated
    @NotNull
    private final Collection<String> dbNames;
    private transient boolean brandNew;
    private String adminEmail;
    private Level adminEmailLevel = Level.SEVERE;
    @Nullable
    private Boolean multipleTimeZones = null;
    private static final ResourceBundle resourceBundle;
    private SyncType syncType;
    private Collection<String> additionalDatabases;

    public MirrorConfig() {
        this.hubTables = new ArrayList<TableConfig>();
        this.spokeTables = new ArrayList<TableConfig>();
        this.modified = this.created = new Date();
        this.dbNames = Collections.emptyList();
        this.serverCopyStart = LocalTime.of(23, 0);
        this.serverCopyEnd = LocalTime.of(3, 0);
        this.setExternalAddressesDifferent(false);
    }

    public Date getCreated() {
        return this.created;
    }

    public Integer getMsVersion() {
        return this.msVersion;
    }

    public void setMsVersion(Integer msVersion) {
        this.msVersion = msVersion;
    }

    public void setCreated(Date created) {
        this.created = created;
        this.firePropertyChange("created", this.created, this.created);
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
        this.firePropertyChange("modified", this.modified, this.modified);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.getPcs().firePropertyChange("name", this.name, this.name);
    }

    public String getAwsRegionName() {
        return this.awsRegionName;
    }

    public void setAwsRegionName(String awsRegionName) {
        this.awsRegionName = awsRegionName;
        this.getPcs().firePropertyChange("awsRegionName", this.awsRegionName, this.awsRegionName);
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        if (awsAccessKey != null) {
            awsAccessKey = awsAccessKey.trim();
        }
        this.awsAccessKey = awsAccessKey;
        this.getPcs().firePropertyChange("awsAccessKey", this.awsAccessKey, this.awsAccessKey);
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        if (awsSecretKey != null) {
            awsSecretKey = awsSecretKey.trim();
        }
        this.awsSecretKey = awsSecretKey;
        this.getPcs().firePropertyChange("awsSecretKey", this.awsSecretKey, this.awsSecretKey);
    }

    public boolean isCloudWatchNotifications() {
        return this.cloudWatchNotifications;
    }

    public void setCloudWatchNotifications(boolean cloudWatchNotifications) {
        this.cloudWatchNotifications = cloudWatchNotifications;
        this.getPcs().firePropertyChange("cloudWatchNotifications", this.cloudWatchNotifications, this.cloudWatchNotifications);
    }

    public Set<String> getCloudWatchMetrics() {
        return this.cloudWatchMetrics;
    }

    public void setCloudWatchMetrics(Set<String> cloudWatchMetrics) {
        this.cloudWatchMetrics = cloudWatchMetrics;
        this.getPcs().firePropertyChange("cloudWatchMetrics", this.cloudWatchMetrics, this.cloudWatchMetrics);
    }

    public String getSnsErrorTopic() {
        return this.snsErrorTopic;
    }

    public void setSnsErrorTopic(String snsErrorTopic) {
        this.snsErrorTopic = snsErrorTopic;
        this.getPcs().firePropertyChange("snsErrorTopic", this.snsErrorTopic, this.snsErrorTopic);
    }

    public void validateAWSSettings() throws FeedbackException {
        boolean isAwsUnset;
        boolean bl = isAwsUnset = StringUtils.isEmpty(this.awsAccessKey) && StringUtils.isEmpty(this.awsSecretKey);
        if (isAwsUnset) {
            if (!StringUtils.isEmpty(this.awsAccessKey)) {
                throw new FeedbackException("You cannot set just the AWS access key; either set it to empty or also set the AWS secret key");
            }
            if (!StringUtils.isEmpty(this.awsSecretKey)) {
                throw new FeedbackException("You cannot set just the AWS secret key; either set it to empty or also set the AWS secret key");
            }
            if (this.isCloudWatchNotifications()) {
                throw new FeedbackException("You cannot enable CloudWatch notifications without also setting the AWS access and secret keys");
            }
            if (!StringUtils.isEmpty(this.getSnsErrorTopic())) {
                throw new FeedbackException("You cannot set the SNS error topic without also setting the AWS access and secret keys");
            }
        } else {
            if (StringUtils.isEmpty(this.awsAccessKey)) {
                throw new FeedbackException("You cannot set just the AWS secret key; either set it to empty or also set the AWS secret key");
            }
            if (StringUtils.isEmpty(this.awsSecretKey)) {
                throw new FeedbackException("You cannot set just the AWS access key; either set it to empty or also set the AWS secret key");
            }
            if (StringUtils.isEmpty(this.awsRegionName)) {
                throw new FeedbackException("An AWS region is required in order to send notifications.");
            }
        }
    }

    public UUID getId() {
        if (this.id == null) {
            log.log(Level.WARNING, "Creating non-null id for " + this + ", be sure to save your changes to persist the id");
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
        this.firePropertyChange("id", this.id, this.id);
    }

    public int getVersion() {
        return 2;
    }

    public List<TableConfig> getHubTables() {
        return Collections.unmodifiableList(this.hubTables);
    }

    public List<TableConfig> getSpokeTables() {
        return Collections.unmodifiableList(this.spokeTables);
    }

    public DatabaseProperties getHubDatabaseProperties() {
        return this.hubDatabaseProperties;
    }

    public void setHubDatabaseProperties(@Nullable DatabaseProperties hubDatabaseProperties) {
        this.hubDatabaseProperties = hubDatabaseProperties;
    }

    public DatabaseProperties getFirstSpokeProperties() {
        return this.spokesDatabaseProperties.get(0);
    }

    @NotNull
    public List<DatabaseProperties> getSpokesDatabaseProperties() {
        return Collections.unmodifiableList(this.spokesDatabaseProperties);
    }

    public void addSpokeDatabaseProperties(DatabaseProperties spokeProperties) {
        this.spokesDatabaseProperties.add(spokeProperties);
    }

    public void setSpokesDatabaseProperties(@NotNull List<DatabaseProperties> spokesDatabaseProperties) {
        if (spokesDatabaseProperties.size() == 0) {
            throw new IllegalArgumentException("spoke databases list must contain at least one item");
        }
        this.spokesDatabaseProperties = spokesDatabaseProperties;
    }

    public String getSyncServerInternalAddress() {
        return this.syncServerInternalAddress;
    }

    public void setSyncServerInternalAddress(String syncServerInternalAddress) {
        this.syncServerInternalAddress = syncServerInternalAddress;
        this.getPcs().firePropertyChange("syncServerInternalAddress", this.syncServerInternalAddress, this.syncServerInternalAddress);
        if (!this.externalAddressesDifferent) {
            this.setSyncServerExternalAddress(this.getSyncServerInternalAddress());
        }
    }

    public String getSyncServerExternalAddress() {
        return this.syncServerExternalAddress;
    }

    public void setSyncServerExternalAddress(String syncServerExternalAddress) {
        this.syncServerExternalAddress = syncServerExternalAddress;
        this.getPcs().firePropertyChange("syncServerExternalAddress", this.syncServerExternalAddress, this.syncServerExternalAddress);
    }

    public boolean isExternalAddressesDifferent() {
        return this.externalAddressesDifferent;
    }

    public void setExternalAddressesDifferent(boolean externalAddressesDifferent) {
        this.externalAddressesDifferent = externalAddressesDifferent;
        if (!externalAddressesDifferent) {
            this.setSyncServerExternalAddress(this.getSyncServerInternalAddress());
        }
    }

    public boolean isUseHubCredentials() {
        return this.useHubCredentials;
    }

    public void setUseHubCredentials(boolean useHubCredentials) {
        this.useHubCredentials = useHubCredentials;
        this.getPcs().firePropertyChange("useHubCredentials", this.useHubCredentials, this.useHubCredentials);
    }

    public boolean isSchemaMapped() {
        return this.schemaMapped;
    }

    public boolean isFileMakerSpokeDuplicateOfHub() {
        return !this.schemaMapped && this.isFileMakerHub() && this.isFileMakerSpoke();
    }

    public void setSchemaMapped(boolean schemaMapped) {
        this.schemaMapped = schemaMapped;
        this.getPcs().firePropertyChange("schemaMapped", this.schemaMapped, this.schemaMapped);
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public Level getAdminEmailLevel() {
        return this.adminEmailLevel;
    }

    public void setAdminEmailLevel(Level adminEmailLevel) {
        this.adminEmailLevel = adminEmailLevel;
    }

    public String getGroupNameForTable(String table, boolean isHub) {
        if (isHub) {
            return table;
        }
        int n = 0;
        for (TableConfig eachTable : this.spokeTables) {
            if (table.equals(eachTable.getTableName())) {
                return this.hubTables.get(n).getTableName();
            }
            ++n;
        }
        throw new IllegalArgumentException("No table named " + table + " was found in the spoke database");
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._afterDeserialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toJSON() {
        try (StringWriter stringWriter = new StringWriter();){
            if (this.msVersion == null) {
                this.msVersion = 5;
            }
            jsonConfigMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)stringWriter, (Object)this);
            String result = stringWriter.toString();
            try {
                MirrorConfig clone = (MirrorConfig)jsonConfigMapper.readValue(result, MirrorConfig.class);
                if (!this.equals(clone)) {
                    log.warning("Writing and reading JSON resulted in a non-equal result for config " + this.getName());
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, result, e);
            }
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MirrorConfig fromJSON(Reader json) {
        try {
            return (MirrorConfig)jsonConfigMapper.readValue(json, MirrorConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void _afterDeserialize() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addTablesToSync(@NotNull TableConfig hubTable, @NotNull TableConfig spokeTable) {
        if (this.isFileMakerHub() && this.isFileMakerSpoke() && !this.isSchemaMapped() && !hubTable.getTableName().equalsIgnoreCase(spokeTable.getTableName())) {
            throw new IllegalStateException("Adding tables to configuration " + this.name + "; hubTable name '" + hubTable.getTableName() + "' does not match spoke table name '" + spokeTable + "'");
        }
        this.hubTables.add(hubTable);
        this.spokeTables.add(spokeTable);
    }

    public void removeAllTablesToSync() {
        this.hubTables.clear();
        this.spokeTables.clear();
    }

    public String toString() {
        return "MirrorConfig{id=" + this.id + ", name='" + this.getName() + '\'' + '}';
    }

    public MirrorConfig cloneWithHubCredentials(String username, String password) {
        MirrorConfig result = this.clone();
        if (result.hubDatabaseProperties instanceof SqlProperties) {
            result.hubDatabaseProperties = ((SqlProperties)result.hubDatabaseProperties).cloneWith(username, password);
        }
        return result;
    }

    public final MirrorConfig clone() {
        try {
            return (MirrorConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final MirrorConfig deepClone() {
        return (MirrorConfig)SerializeUtils.deepCopy((Object)this);
    }

    public ArrayList<ColumnInfo> getDataColumnsInSyncOrder(TableConfig whichTable) {
        TableConfig hubTable;
        TableConfig spokeTable = null;
        boolean hub = this.isHub(whichTable);
        if (hub) {
            hubTable = whichTable;
        } else {
            spokeTable = whichTable;
            hubTable = this.hubTables.get(this.spokeTables.indexOf(whichTable));
            if (hubTable.getDataColumnsCount() != spokeTable.getDataColumnsCount()) {
                throw new IllegalStateException("Hub table " + hubTable.getTableName() + " column count does not match spoke table " + spokeTable.getTableName() + " column count. Hub columns: " + hubTable.getDataColumns() + "; spoke columns: " + spokeTable.getDataColumns());
            }
        }
        ArrayList<ColumnInfo[]> columnPairs = new ArrayList<ColumnInfo[]>(hubTable.getDataColumns().size());
        Iterator<ColumnInfo> hubIt = hubTable.getDataColumns().iterator();
        Iterator<ColumnInfo> spokeIt = null;
        if (spokeTable != null) {
            spokeIt = spokeTable.getDataColumns().iterator();
        }
        boolean isSpokeOracle = false;
        if (spokeTable != null && spokeTable.isVirtual() && this.getFirstSpokeProperties().getType() instanceof Oracle) {
            isSpokeOracle = true;
        }
        while (hubIt.hasNext()) {
            ColumnInfo[] columnPair = new ColumnInfo[2];
            columnPairs.add(columnPair);
            columnPair[0] = hubIt.next();
            if (columnPair[0] == null) {
                throw new IllegalStateException("Hub table " + hubTable.getTableName() + " contains null data columns, cannot sync.");
            }
            if (spokeIt == null) continue;
            columnPair[1] = spokeIt.next();
            if (columnPair[0] == null) {
                throw new IllegalStateException("Spoke table " + spokeTable.getTableName() + " contains null data columns, cannot sync.");
            }
            if (isSpokeOracle && columnPair[1].getDataType() != 92) continue;
        }
        final HashSet<String> keyNames = new HashSet<String>(hubTable.getForeignKeys().size());
        for (ForeignKeyInfo foreignKeyInfo : hubTable.getForeignKeys()) {
            keyNames.add(foreignKeyInfo.getFromColumn());
        }
        for (ColumnInfo pk : hubTable.getPrimaryKeys()) {
            keyNames.add(pk.getName());
        }
        columnPairs.sort(new Comparator<ColumnInfo[]>(){

            @Override
            public int compare(ColumnInfo[] o1, ColumnInfo[] o2) {
                boolean isAutoEnter2;
                boolean isKey1 = keyNames.contains(o1[0].getName());
                boolean isKey2 = keyNames.contains(o2[0].getName());
                if (isKey1 && !isKey2) {
                    return -1;
                }
                if (isKey2 && !isKey1) {
                    return 1;
                }
                if (o1[0].isBinary() && !o2[0].isBinary()) {
                    return 1;
                }
                if (!o1[0].isBinary() && o2[0].isBinary()) {
                    return -1;
                }
                boolean isAutoEnter1 = o1[0].getAutoEnter() != AutoEnter.None && o1[0].getAutoEnter() != AutoEnter.Unknown;
                boolean bl = isAutoEnter2 = o2[0].getAutoEnter() != AutoEnter.None && o2[0].getAutoEnter() != AutoEnter.Unknown;
                if (isAutoEnter1 && !isAutoEnter2) {
                    return 1;
                }
                if (!isAutoEnter1 && isAutoEnter2) {
                    return -1;
                }
                return o1[0].getName().compareToIgnoreCase(o2[0].getName());
            }
        });
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>(columnPairs.size());
        for (ColumnInfo[] pair : columnPairs) {
            if (whichTable == hubTable) {
                result.add(pair[0]);
                continue;
            }
            result.add(pair[1]);
        }
        return result;
    }

    public SyncDirection getSyncDirectionAdjusted(TableConfig whichTable, boolean isHub) {
        SyncDirection syncDirection = whichTable.getSyncDirection();
        return isHub ? syncDirection.inverseDirection() : syncDirection;
    }

    public void setDownloadData(@Nullable String uuid, @Nullable Boolean clone, Boolean syncOnServer) {
        if (clone == null || syncOnServer == null) {
            this.autoupdateUUIDs.add(uuid);
        } else if (clone.booleanValue()) {
            if (syncOnServer.booleanValue()) {
                this.getCloneInitialSyncUUIDs();
                this.cloneInitialSyncUUIDs.add(uuid);
            } else {
                this.cloneDownloadUUIDs.add(uuid);
            }
        } else if (syncOnServer.booleanValue()) {
            this.getFullInitialSyncUUIDs();
            this.fullInitialSyncUUIDs.add(uuid);
        } else {
            this.fullDownloadUUIDs.add(uuid);
        }
    }

    public void revokeAllDownloadURLs() {
        log.info("Revoking download URLs for config " + this);
        this.fullDownloadUUIDs.clear();
        this.cloneDownloadUUIDs.clear();
        this.autoupdateUUIDs.clear();
    }

    public Collection<String> getFullDownloadUUIDs() {
        return Collections.unmodifiableCollection(this.fullDownloadUUIDs);
    }

    public Collection<String> getTriggerUUIDs() {
        return Collections.unmodifiableCollection(this.triggerUUIDs);
    }

    public void addTriggerUUID(String newTriggerUUID) {
        this.getTriggerUUIDs();
        this.triggerUUIDs.add(newTriggerUUID);
    }

    public Collection<String> getCloneDownloadUUIDs() {
        return Collections.unmodifiableCollection(this.cloneDownloadUUIDs);
    }

    public Collection<String> getFullInitialSyncUUIDs() {
        if (this.fullInitialSyncUUIDs == null) {
            this.fullInitialSyncUUIDs = new ArrayList<String>();
        }
        return Collections.unmodifiableCollection(this.fullInitialSyncUUIDs);
    }

    public Collection<String> getCloneInitialSyncUUIDs() {
        if (this.cloneInitialSyncUUIDs == null) {
            this.cloneInitialSyncUUIDs = new ArrayList<String>();
        }
        return Collections.unmodifiableCollection(this.cloneInitialSyncUUIDs);
    }

    public Collection<String> getAutoupdateUUIDs() {
        return Collections.unmodifiableCollection(this.autoupdateUUIDs);
    }

    boolean isDownloadAvailable(String uuid) {
        return this.fullDownloadUUIDs.contains(uuid) || this.cloneDownloadUUIDs.contains(uuid) || this.fullInitialSyncUUIDs != null && this.fullInitialSyncUUIDs.contains(uuid) || this.cloneInitialSyncUUIDs != null && this.cloneInitialSyncUUIDs.contains(uuid) || this.autoupdateUUIDs.contains(uuid);
    }

    public String getDownloadUsername() {
        return this.downloadUsername;
    }

    public void setDownloadUsername(String downloadUsername) {
        this.downloadUsername = downloadUsername;
    }

    public void setDownloadPassword(String password) {
        SqlProperties.DesSupport des = new SqlProperties.DesSupport(new SecretKeySpec(new String(new char[]{'i', 'n', 's', 'e', 'c', 'u', 'r', '3'}).getBytes(), "DES"));
        this.downloadPassword = des.encrypt(password);
    }

    public String getEncryptedDownloadPassword() {
        return this.downloadPassword;
    }

    @Nullable
    public Boolean getMultipleTimeZones() {
        return this.multipleTimeZones;
    }

    public void setMultipleTimeZones(@Nullable Boolean multipleTimeZones) {
        this.multipleTimeZones = multipleTimeZones;
    }

    @NotNull
    public TableConfig getHubTableWithName(@NotNull String tableName) throws IllegalArgumentException {
        for (TableConfig eachHubTable : this.hubTables) {
            if (!tableName.equals(eachHubTable.getTableName())) continue;
            return eachHubTable;
        }
        throw new IllegalArgumentException("Unknown hub table: " + tableName);
    }

    @NotNull
    public TableConfig getSpokeTableWithName(String tableName) throws IllegalArgumentException {
        for (TableConfig eachHubTable : this.spokeTables) {
            if (!tableName.equals(eachHubTable.getTableName())) continue;
            return eachHubTable;
        }
        throw new IllegalArgumentException("Unknown spoke table: " + tableName);
    }

    public boolean isBrandNew() {
        return this.brandNew;
    }

    public void setBrandNew(boolean brandNew) {
        this.brandNew = brandNew;
    }

    public boolean isServerToServer() {
        IDatabaseType firstSpokeType = this.getSpokesDatabaseProperties().get(0).getType();
        return !(firstSpokeType instanceof FileMakerGo) && !(firstSpokeType instanceof FileMakerGoV6);
    }

    public boolean isHub(TableConfig tableConfig) {
        return this.hubTables.contains(tableConfig);
    }

    public Float getFmVersion() {
        return this.fmVersion;
    }

    public void setFmVersion(float fmVersion) {
        this.fmVersion = Float.valueOf(fmVersion);
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public void setSyncType(SyncType syncType) {
        this.syncType = syncType;
    }

    public boolean isSpokeDuplicate() {
        if (this.isSchemaMapped()) {
            return false;
        }
        boolean hubIsFileMaker = this.getHubDatabaseProperties().getType() instanceof FileMakerServer || this.getHubDatabaseProperties().getType() instanceof FileMakerServerV6;
        IDatabaseType firstSpokeType = this.getFirstSpokeProperties().getType();
        boolean spokeIsFileMaker = firstSpokeType instanceof FileMakerServer || firstSpokeType instanceof FileMakerGo || firstSpokeType instanceof FileMakerServerV6 || firstSpokeType instanceof FileMakerGoV6;
        return hubIsFileMaker && spokeIsFileMaker;
    }

    public boolean isSeparateMobileFile() {
        IDatabaseType firstSpokeType = this.getFirstSpokeProperties().getType();
        boolean spokeIsFileMaker = firstSpokeType instanceof FileMakerGo || firstSpokeType instanceof FileMakerServer || firstSpokeType instanceof FileMakerGoV6 || firstSpokeType instanceof FileMakerServerV6;
        return spokeIsFileMaker && !this.isSpokeDuplicate();
    }

    public MirrorConfig duplicate(String newName) {
        MirrorConfig newConfig = this.deepClone();
        newConfig.setCreated(new Date());
        newConfig.setId(UUID.randomUUID());
        newConfig.setName(newName);
        newConfig.autoupdateUUIDs.clear();
        newConfig.cloneDownloadUUIDs.clear();
        newConfig.cloneInitialSyncUUIDs.clear();
        newConfig.fullDownloadUUIDs.clear();
        newConfig.fullInitialSyncUUIDs.clear();
        newConfig.triggerUUIDs.clear();
        return newConfig;
    }

    public boolean isDetectLayouts() {
        return this.detectLayouts;
    }

    public void setDetectLayouts(boolean detectLayouts) {
        this.detectLayouts = detectLayouts;
        this.getPcs().firePropertyChange("detectLayouts", this.detectLayouts, this.detectLayouts);
    }

    public String getLayoutScanPrefix() {
        return this.layoutScanPrefix;
    }

    public void setLayoutScanPrefix(String layoutScanPrefix) {
        this.layoutScanPrefix = layoutScanPrefix;
        this.getPcs().firePropertyChange("layoutScanPrefix", this.layoutScanPrefix, this.layoutScanPrefix);
    }

    public boolean isExpressSetupEligible() {
        return !this.schemaMapped && this.getMsVersion() != null;
    }

    public boolean isExpressSetup() {
        return this.expressSetup;
    }

    public void setExpressSetup(boolean expressSetup) {
        this.expressSetup = expressSetup;
        this.getPcs().firePropertyChange("expressSetup", this.expressSetup, this.expressSetup);
    }

    public LocalTime getServerCopyStart() {
        return this.serverCopyStart;
    }

    public void setServerCopyStart(LocalTime serverCopyStart) {
        this.serverCopyStart = serverCopyStart;
        this.getPcs().firePropertyChange("serverCopyStart", this.serverCopyStart, this.serverCopyStart);
    }

    public LocalTime getServerCopyEnd() {
        return this.serverCopyEnd;
    }

    public void setServerCopyEnd(LocalTime serverCopyEnd) {
        this.serverCopyEnd = serverCopyEnd;
        this.getPcs().firePropertyChange("serverCopyEnd", this.serverCopyEnd, this.serverCopyEnd);
    }

    public boolean isServerCopyAnytime() {
        return this.serverCopyAnytime;
    }

    public void setServerCopyAnytime(boolean serverCopyAnytime) {
        this.serverCopyAnytime = serverCopyAnytime;
        this.getPcs().firePropertyChange("serverCopyAnytime", this.serverCopyAnytime, this.serverCopyAnytime);
    }

    public boolean isFileMakerServerToFileMakerServer() {
        return this.hubDatabaseProperties instanceof FMServerPropertiesV6 && this.getFirstSpokeProperties() instanceof FMServerPropertiesV6;
    }

    @Nullable
    public Collection<String> getAdditionalDatabases() {
        return this.additionalDatabases;
    }

    public void setAdditionalDatabases(Collection<String> additionalDatabases) {
        this.additionalDatabases = additionalDatabases;
        this.getPcs().firePropertyChange("additionalDatabases", this.additionalDatabases, this.additionalDatabases);
    }

    @JsonIgnore
    public Collection<String> getAllDatabaseNames() {
        Collection<Object> additionalDatabasesNoNull = this.additionalDatabases == null ? Collections.emptyList() : this.additionalDatabases;
        int count = additionalDatabasesNoNull.size() + 1;
        ArrayList<String> result = new ArrayList<String>(count);
        if (this.getFirstSpokeProperties() instanceof FileMakerPropertiesV6) {
            result.add(((FileMakerPropertiesV6)this.getFirstSpokeProperties()).getServerProperties().getDatabase());
        }
        result.addAll(additionalDatabasesNoNull);
        return result;
    }

    public boolean isFileMakerHub() {
        return this.hubDatabaseProperties instanceof FMServerPropertiesV6;
    }

    public boolean isFileMakerSpoke() {
        return this.getFirstSpokeProperties() instanceof FileMakerPropertiesV6;
    }

    public boolean isFileMakerClient() {
        return this.getFirstSpokeProperties() instanceof FileMakerGoPropertiesV6;
    }

    public FMServerPropertiesV6 getDatabaseDownloadProperties() {
        if (this.isFileMakerSpokeDuplicateOfHub()) {
            return (FMServerPropertiesV6)this.getHubDatabaseProperties();
        }
        if (this.getFirstSpokeProperties() instanceof FileMakerPropertiesV6) {
            return ((FileMakerPropertiesV6)this.getFirstSpokeProperties()).getServerProperties();
        }
        throw new IllegalStateException("The spoke is not a FileMaker database, so it doesn't make sense to download a copy of the database to sync with.");
    }

    public URL getSyncUrl(String context, boolean internal) {
        String syncAddress;
        String string = syncAddress = internal ? this.getSyncServerInternalAddress() : this.getSyncServerExternalAddress();
        if (syncAddress.endsWith(context)) {
            syncAddress = syncAddress + "/";
        } else if (!syncAddress.endsWith(context + "/")) {
            syncAddress = syncAddress.endsWith("/") ? syncAddress + context + "/" : syncAddress + "/" + context + "/";
        }
        boolean ssl = true;
        return UrlUtil.convertToURL(syncAddress, ssl);
    }

    public void validate() throws FeedbackException {
        if (this.isFileMakerSpoke() && this.isFileMakerHub() && !this.isSchemaMapped()) {
            if (this.hubTables.size() != this.spokeTables.size()) {
                log.log(Level.WARNING, "Hub tables size: " + this.hubTables.size() + "\n" + this.hubTables + "\nSpoke tables size: " + this.spokeTables.size() + "\nSpoke tables: " + this.spokeTables);
                throw new FeedbackException("The hub database has " + this.hubTables.size() + ", but the spoke database has " + this.spokeTables.size() + ". These should be the same.");
            }
            Iterator<TableConfig> hubIterator = this.hubTables.iterator();
            Iterator<TableConfig> spokeIterator = this.spokeTables.iterator();
            while (hubIterator.hasNext()) {
                TableConfig hubTable = hubIterator.next();
                TableConfig spokeTable = spokeIterator.next();
                if (hubTable == null) {
                    log.warning("Hub tables: " + this.hubTables);
                    throw new FeedbackException("The list of hub tables has at least one empty value");
                }
                if (spokeTable == null) {
                    log.warning("Spoke tables: " + this.spokeTables);
                    throw new FeedbackException("The list of spoke tables has at least one empty value");
                }
                hubTable.validate();
                spokeTable.validate();
                if (!hubTable.getTableName().equalsIgnoreCase(spokeTable.getTableName())) {
                    log.warning("Hub tables: " + this.hubTables + "\n" + this.spokeTables);
                    throw new FeedbackException("The hub and spoke tables in this configuration are somehow out of order with each other! Please contact support@360works.com to report ths problem.");
                }
                if (hubTable.getDataColumnsCount() != spokeTable.getDataColumnsCount()) {
                    throw new FeedbackException("For table '" + hubTable.getTableName() + "', the hub has " + hubTable.getDataColumnsCount() + "; the spoke has " + spokeTable.getDataColumnsCount() + ". These should always match.");
                }
                Set hubFkNames = hubTable.getForeignKeys().stream().map(ForeignKeyInfo::getFromColumn).collect(Collectors.toSet());
                Set spokeFKNames = spokeTable.getForeignKeys().stream().map(ForeignKeyInfo::getFromColumn).collect(Collectors.toSet());
                Iterator<ColumnInfo> hubColumnIterator = hubTable.getDataColumns().iterator();
                Iterator<ColumnInfo> spokeColumnIterator = spokeTable.getDataColumns().iterator();
                while (hubColumnIterator.hasNext()) {
                    ColumnInfo hubColumn = hubColumnIterator.next();
                    ColumnInfo spokeColumn = spokeColumnIterator.next();
                    if (hubFkNames.remove(hubColumn.getName()) && !spokeFKNames.remove(spokeColumn.getName())) {
                        throw new FeedbackException("On the hub table '" + hubTable.getTableName() + "', column '" + hubColumn.getName() + "' is configured as a foreign key, but spoke column '" + spokeColumn + "' is not. These must either both be configured as foreign keys, or neither should.");
                    }
                    if (hubFkNames.remove(hubColumn.getName()) || !spokeFKNames.remove(spokeColumn.getName())) continue;
                    throw new FeedbackException("On the hub, column '" + hubColumn.getName() + "' is not configured as a foreign key, but spoke column '" + spokeColumn + "' is. These must either both be configured as foreign keys, or neither should.");
                }
                if (!hubFkNames.isEmpty()) {
                    throw new FeedbackException("The hub table '" + hubTable.getTableName() + "' has foreign keys configured, but without any actual syncing columns matching up: " + hubFkNames);
                }
                if (!spokeFKNames.isEmpty()) {
                    throw new FeedbackException("The spoke table '" + spokeTable.getTableName() + "' has foreign keys configured, but without any actual syncing columns matching up: " + spokeFKNames);
                }
                if (hubTable.getPrimaryKeys().size() == spokeTable.getPrimaryKeys().size()) continue;
                throw new FeedbackException("The hub table '" + hubTable.getTableName() + "' has " + hubTable.getPrimaryKeys().size() + " configured, but the spoke table '" + spokeTable.getTableName() + "' has " + spokeTable.getPrimaryKeys().size() + ". These should match.");
            }
        }
    }

    public ForeignKeyInfo translateForeignKeyInfo(TableConfig config1, TableConfig config2, ForeignKeyInfo foreignKeyInfo, boolean isForeignKeyInfoFromHub) throws IllegalArgumentException {
        if (foreignKeyInfo.getToTable() == null) {
            throw new IllegalArgumentException("toTable is null for foreign key: " + foreignKeyInfo + "; table config: " + config1 + " / foreign keys: " + config1.getForeignKeys() + "; isFromHub: " + isForeignKeyInfoFromHub + "; express setup: " + this.isExpressSetup());
        }
        Iterator<ColumnInfo> it = config1.getDataColumns().iterator();
        for (ColumnInfo destColumn : config2.getDataColumns()) {
            String sourceColumnName = it.next().getName();
            if (!sourceColumnName.equals(foreignKeyInfo.getFromColumn())) continue;
            String parentTable = isForeignKeyInfoFromHub ? this.lookupSpokeTableForHubTable(this.getHubTableWithName(foreignKeyInfo.getToTable())).getTableName() : this.lookupHubTableForSpokeTable(this.getSpokeTableWithName(foreignKeyInfo.getToTable())).getTableName();
            return new ForeignKeyInfo(destColumn.getName(), parentTable);
        }
        log.log(Level.WARNING, "sourceconfig foreign keys: " + config1.getForeignKeys() + "\nsourceconfig data columns: " + config1.getDataColumns() + "\ndestconfig data columns: " + config2.getDataColumns());
        for (ColumnInfo columnInfo : config1.getDataColumns()) {
            if (!columnInfo.getName().equals(foreignKeyInfo.getFromColumn())) continue;
            throw new IllegalArgumentException("The foreign key field " + foreignKeyInfo.getFromColumn() + " on the server does not have a corresponding field on the client.");
        }
        throw new IllegalArgumentException("The foreign key field '" + foreignKeyInfo.getFromColumn() + "' in table '" + config1.getTableName() + "' on the server is not set to sync. Check to make sure that it is mapped between hub and spoke, and that it is writeable.");
    }

    private TableConfig lookupSpokeTableForHubTable(TableConfig whichHubTable) {
        Iterator<TableConfig> it = this.spokeTables.iterator();
        for (TableConfig eachHubTable : this.hubTables) {
            TableConfig eachSpokeTable = it.next();
            if (eachHubTable != whichHubTable) continue;
            return eachSpokeTable;
        }
        throw new IllegalStateException("There is no hub table in this MirrorSync configuration for " + whichHubTable);
    }

    private TableConfig lookupHubTableForSpokeTable(TableConfig whichSpokeTable) {
        Iterator<TableConfig> it = this.spokeTables.iterator();
        for (TableConfig eachHubTable : this.hubTables) {
            TableConfig eachSpokeTable = it.next();
            if (eachSpokeTable != whichSpokeTable) continue;
            return eachHubTable;
        }
        throw new IllegalStateException("There is no spoke table in this MirrorSync configuration for " + whichSpokeTable);
    }

    public String toStringDetailed() {
        return "MirrorConfig{created=" + this.created + ", modified=" + this.modified + ", name='" + this.getName() + '\'' + ", id='" + this.id + '\'' + ", version='" + 2 + '\'' + ", hubDatabaseProperties=" + this.hubDatabaseProperties + ", spokesDatabaseProperties=" + this.spokesDatabaseProperties + ", hubTables=" + this.hubTables + ", spokeTables=" + this.spokeTables + '}';
    }

    @Override
    public int compareTo(MirrorConfig o) {
        return this.created.compareTo(o.created);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(propertyName, listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorConfig config = (MirrorConfig)o;
        return this.externalAddressesDifferent == config.externalAddressesDifferent && this.schemaMapped == config.schemaMapped && this.useHubCredentials == config.useHubCredentials && true == config.offersDownload && this.cloudWatchNotifications == config.cloudWatchNotifications && Objects.equals(this.id, config.id) && Objects.equals(this.created, config.created) && Objects.equals(this.name, config.name) && Objects.equals(this.hubDatabaseProperties, config.hubDatabaseProperties) && Objects.equals(this.spokesDatabaseProperties, config.spokesDatabaseProperties) && Objects.equals(this.hubTables, config.hubTables) && Objects.equals(this.spokeTables, config.spokeTables) && Objects.equals(this.syncServerInternalAddress, config.syncServerInternalAddress) && Objects.equals(this.syncServerExternalAddress, config.syncServerExternalAddress) && Objects.equals(this.fmVersion, config.fmVersion) && Objects.equals(this.awsAccessKey, config.awsAccessKey) && Objects.equals(this.awsSecretKey, config.awsSecretKey) && Objects.equals(this.cloudWatchMetrics, config.cloudWatchMetrics) && Objects.equals(this.snsErrorTopic, config.snsErrorTopic) && Objects.equals(this.awsRegionName, config.awsRegionName) && this.dbNames.equals(config.dbNames) && Objects.equals(this.adminEmail, config.adminEmail) && Objects.equals(this.adminEmailLevel, config.adminEmailLevel) && this.syncType == config.syncType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.created, this.name, this.hubDatabaseProperties, this.spokesDatabaseProperties, this.hubTables, this.spokeTables, this.syncServerInternalAddress, this.syncServerExternalAddress, this.externalAddressesDifferent, this.schemaMapped, this.useHubCredentials, this.fmVersion, true, this.awsAccessKey, this.awsSecretKey, this.cloudWatchNotifications, this.cloudWatchMetrics, this.snsErrorTopic, this.awsRegionName, this.dbNames, this.adminEmail, this.adminEmailLevel, this.syncType});
    }

    static {
        resourceBundle = ResourceBundle.getBundle("com.prosc.strings");
        jsonConfigMapper = new ObjectMapper();
        jsonConfigMapper.setVisibility(jsonConfigMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        jsonConfigMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        jsonConfigMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonConfigMapper.registerModule((Module)new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, final JsonDeserializer<?> deserializer) {
                Class beanClass = beanDesc.getBeanClass();
                if (DatabaseProperties.class.isAssignableFrom(beanClass)) {
                    return new StdDeserializer<Object>(beanClass){

                        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                            JsonNode node = (JsonNode)p.readValueAsTree();
                            JsonNode type2ClassNode = node.get("type2ClassName");
                            if (type2ClassNode == null) {
                                throw new IllegalArgumentException("There is no type2ClassName attribute in this JSON: " + node.toString());
                            }
                            String type2ClassName = type2ClassNode.textValue();
                            try {
                                DatabaseType2 dbType = (DatabaseType2)Class.forName(type2ClassName).newInstance();
                                DatabaseProperties result = dbType.createDatabaseProperties();
                                result.readFields(node, p);
                                return result;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                if (Level.class.isAssignableFrom(beanClass)) {
                    return new StdDeserializer<Object>(beanClass){

                        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                            JsonNode node = (JsonNode)p.readValueAsTree();
                            String logName = node.get("name").asText();
                            return Level.parse(logName);
                        }
                    };
                }
                if (Date.class.isAssignableFrom(beanClass)) {
                    return new StdDeserializer<Object>(beanClass){

                        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                            try {
                                return deserializer.deserialize(p, ctxt);
                            }
                            catch (InvalidFormatException e) {
                                String unparseableDate = String.valueOf(e.getValue());
                                try {
                                    return new SimpleDateFormat("MMM dd, yyyy h:mm:ss a").parse(unparseableDate);
                                }
                                catch (ParseException parseException) {
                                    throw e;
                                }
                            }
                        }
                    };
                }
                return super.modifyDeserializer(config, beanDesc, deserializer);
            }
        }));
    }

    private static class Interner<E> {
        List<E> list = new ArrayList();

        private Interner() {
        }

        public E intern(E object) {
            int index = this.list.indexOf(object);
            if (index == -1) {
                this.list.add(object);
                return object;
            }
            return this.list.get(index);
        }
    }
}

