/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JacksonUtils {
    private static final Logger log = Logger.getLogger(JacksonUtils.class.getName());
    private static final Map<TypeCacheEntry, JavaType> jsonTypeCache = new HashMap<TypeCacheEntry, JavaType>();
    public final ObjectMapper objectMapper;

    public JacksonUtils(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Set<String> readMultipleValues(Parameter[] params, Object[] paramValues, InputStream input) throws IOException {
        Set<String> result;
        if (params.length == 1) {
            paramValues[0] = this.readSingleValue(params[0].getType(), params[0].getParameterizedType(), IOUtils.inputStreamAsBytes(input));
            result = Collections.emptySet();
        } else {
            JsonNode inputNode = this.objectMapper.readTree(input);
            LinkedList jsonParamNames = new LinkedList();
            inputNode.fieldNames().forEachRemaining(jsonParamNames::add);
            result = new HashSet<String>(jsonParamNames);
            for (int n = 0; n < params.length; ++n) {
                String paramName = params[n].getName();
                if (inputNode.has(paramName)) {
                    JsonNode paramNode = inputNode.get(paramName);
                    result.remove(paramName);
                    paramValues[n] = this.readSingleValue(params[n].getType(), params[n].getParameterizedType(), paramNode);
                    continue;
                }
                if (n != 0 || !"arg0".equals(paramName)) continue;
                throw new RuntimeException("The parameter names are not available in the bytecode; delegate class must be compiled with the -parameters compiler flag.");
            }
        }
        return result;
    }

    public Object readSingleValue(Class<?> rawClass, Type genericType, byte[] input) throws IOException {
        try {
            return this.objectMapper.readerFor(this.getJavaType(rawClass, genericType)).readValue(input);
        }
        catch (JsonMappingException e) {
            if (rawClass == Serializable.class) {
                log.fine("Failed to parse as an object of type " + genericType + "; will try as a raw Object");
                try {
                    return this.objectMapper.readValue(input, Object.class);
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public <T> T readSingleValue(Class<T> rawClass, Type genericType, JsonNode node) throws IOException {
        return (T)this.objectMapper.readerFor(this.getJavaType(rawClass, genericType)).readValue(node);
    }

    public void registerThrowableModule() {
        SimpleModule result = new SimpleModule();
        result.setSerializerModifier(new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                if (Throwable.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return beanProperties.stream().filter(property -> !"cause".equals(property.getName())).collect(Collectors.toCollection(ArrayList::new));
                }
                return beanProperties;
            }
        });
        this.objectMapper.registerModule((Module)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaType getJavaType(Class<?> rawType, @Nullable Type parameterizedType) {
        Map<TypeCacheEntry, JavaType> map = jsonTypeCache;
        synchronized (map) {
            TypeCacheEntry key = new TypeCacheEntry(rawType, parameterizedType);
            JavaType result = jsonTypeCache.get(key);
            if (result == null) {
                Type[] mapTypes;
                if (parameterizedType instanceof ParameterizedType && Collection.class.isAssignableFrom(rawType)) {
                    Type[] collectionType = ((ParameterizedType)parameterizedType).getActualTypeArguments();
                    JavaType javaType = this.getJavaType((Class)(collectionType[0] instanceof ParameterizedType ? ((ParameterizedType)collectionType[0]).getRawType() : collectionType[0]), collectionType[0]);
                    return this.objectMapper.getTypeFactory().constructCollectionType(rawType, javaType);
                }
                if (parameterizedType instanceof ParameterizedType && Map.class.isAssignableFrom(rawType) && (mapTypes = ((ParameterizedType)parameterizedType).getActualTypeArguments()).length >= 2) {
                    JavaType[] javaTypes = new JavaType[]{this.getJavaType((Class)(mapTypes[0] instanceof ParameterizedType ? ((ParameterizedType)mapTypes[0]).getRawType() : mapTypes[0]), mapTypes[0]), this.getJavaType((Class)(mapTypes[1] instanceof ParameterizedType ? ((ParameterizedType)mapTypes[1]).getRawType() : mapTypes[1]), mapTypes[1])};
                    return this.objectMapper.getTypeFactory().constructMapType(rawType, javaTypes[0], javaTypes[1]);
                }
                result = this.objectMapper.getTypeFactory().constructType(rawType);
                jsonTypeCache.put(key, result);
            }
            return result;
        }
    }

    public void writeSingleValue(@Nullable Object data, @Nullable Type genericType, OutputStream baos) throws IOException {
        if (data == null) {
            this.objectMapper.writeValue(baos, null);
        } else {
            this.objectMapper.writerFor(this.getJavaType(data.getClass(), genericType)).writeValue(baos, data);
        }
    }

    public void writeSingleValue(@Nullable Object data, @Nullable Type genericType, String fieldName, JsonGenerator gen) throws IOException {
        if (data == null) {
            gen.writeNullField(fieldName);
        } else {
            gen.writeFieldName(fieldName);
            this.objectMapper.writerFor(this.getJavaType(data.getClass(), genericType)).writeValue(gen, data);
        }
    }

    private static class TypeCacheEntry {
        private final Class<?> rawType;
        private final Type parameterizedType;

        public TypeCacheEntry(Class<?> rawType, Type parameterizedType) {
            this.rawType = rawType;
            this.parameterizedType = parameterizedType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeCacheEntry entry = (TypeCacheEntry)o;
            return this.rawType.equals(entry.rawType) && Objects.equals(this.parameterizedType, entry.parameterizedType);
        }

        public int hashCode() {
            return Objects.hash(this.rawType, this.parameterizedType);
        }
    }
}

