/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.FMServerPropertiesV6;
import com.prosc.mirror.model.FileMakerGoProperties;
import com.prosc.mirror.model.FileMakerPropertiesV6;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.dbtypes.FileMakerGoV6;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileMakerGoPropertiesV6
implements DatabaseProperties,
FileMakerPropertiesV6,
Cloneable {
    private static final long serialVersionUID = 2L;
    private static final IDatabaseType databaseType = new FileMakerGoV6();
    private boolean ssl = false;
    @NotNull
    private FMServerPropertiesV6 serverFile;
    private transient PropertyChangeSupport pcs = null;

    public FileMakerGoPropertiesV6() {
        this.serverFile = new FMServerPropertiesV6((UUID)null);
    }

    public FileMakerGoPropertiesV6(FileMakerGoProperties properties) {
        this.serverFile = new FMServerPropertiesV6(properties);
        this.serverFile.setIgnoreSslWarnings(true);
    }

    @Override
    public String getName() {
        return "FileMaker Pro/Go";
    }

    @Override
    public String getDescription() {
        return (this.serverFile.getDatabase() == null ? "" : this.serverFile.getDatabase() + " on ") + "FileMaker Pro/Go";
    }

    @Override
    public void validate() {
    }

    @Override
    @NotNull
    public IDatabaseType getType() {
        return databaseType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMakerGoPropertiesV6 v6 = (FileMakerGoPropertiesV6)o;
        return this.ssl == v6.ssl && Objects.equals(this.serverFile, v6.serverFile);
    }

    public int hashCode() {
        return Objects.hash(this.ssl, this.serverFile);
    }

    @Override
    @NotNull
    public FMServerPropertiesV6 getServerProperties() {
        this.serverFile.setIgnoreSslWarnings(true);
        return this.serverFile;
    }

    @Override
    public FileMakerGoPropertiesV6 clone() throws CloneNotSupportedException {
        return (FileMakerGoPropertiesV6)super.clone();
    }

    @Override
    @Nullable
    public UUID getUniqueId() {
        return null;
    }

    @Override
    @Nullable
    public String getSyncStoreIdentifier() {
        return null;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
        this.getPcs().firePropertyChange("ssl", this.ssl, this.ssl);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void writeFields(JsonGenerator gen) throws IOException {
        gen.writeStringField("type2ClassName", this.getType().getClass().getName());
        gen.writeBooleanField("ssl", this.ssl);
        gen.writeObjectField("serverFile", (Object)this.serverFile);
    }

    @Override
    public void readFields(JsonNode node, JsonParser p) {
        this.ssl = node.get("ssl").asBoolean(false);
        try {
            this.serverFile = (FMServerPropertiesV6)p.getCodec().treeToValue((TreeNode)node.get("serverFile"), FMServerPropertiesV6.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FileMaker Pro/Go";
    }
}

