/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.prosc.core.FeedbackException;
import com.prosc.io.IOUtils;
import com.prosc.mirror.model.DatabaseType2;
import com.prosc.mirror.model.FMServerProperties;
import com.prosc.mirror.model.FileMakerPropertiesV6;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.dbtypes.FileMakerServerV6;
import com.prosc.util.UrlUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FMServerPropertiesV6
extends SqlProperties
implements FileMakerPropertiesV6 {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static final DatabaseType2 type = new FileMakerServerV6();
    private String dbServerExternalIp;
    private boolean hub = true;
    private boolean webServerSeparate = false;
    private boolean ignoreSslWarnings = false;
    private String adminUsername;
    private String adminPassword;

    public FMServerPropertiesV6(@Nullable UUID uniqueId) {
        super(uniqueId);
    }

    public FMServerPropertiesV6(FMServerProperties properties) {
        super(properties);
        this.dbServerExternalIp = properties.getDbServerExternalIp();
        this.hub = properties.isHub();
        this.webServerSeparate = properties.isWebServerSeparate();
    }

    @Override
    public void setHostname(String hostname) {
        super.setHostname(hostname);
        if (!this.webServerSeparate) {
            this.setDbServerExternalIp(hostname);
        }
    }

    @Override
    @NotNull
    public FMServerPropertiesV6 getServerProperties() {
        return this;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getAdminPassword() {
        String result = this.adminPassword;
        if (result != null) {
            result = this.getDes().decrypt(result);
        }
        return result;
    }

    public void setAdminPassword(@Nullable String newPassword) {
        String encryptedPassword = newPassword;
        if (encryptedPassword != null) {
            encryptedPassword = this.getDes().encrypt(encryptedPassword);
        }
        String oldValue = this.getPassword();
        this.adminPassword = encryptedPassword;
        this.getPcs().firePropertyChange("adminPassword", oldValue, newPassword);
    }

    public String getDbServerExternalIp() {
        return this.dbServerExternalIp;
    }

    public void setDbServerExternalIp(String dbServerExternalIp) {
        this.dbServerExternalIp = dbServerExternalIp;
        this.getPcs().firePropertyChange("dbServerExternalIp", this.dbServerExternalIp, this.dbServerExternalIp);
    }

    public boolean isHub() {
        return this.hub;
    }

    public void setHub(boolean hub) {
        this.hub = hub;
        this.getPcs().firePropertyChange("hub", this.hub, this.hub);
    }

    public boolean isWebServerSeparate() {
        return this.webServerSeparate;
    }

    public void setWebServerSeparate(boolean webServerSeparate) {
        this.webServerSeparate = webServerSeparate;
        this.getPcs().firePropertyChange("webServerSeparate", this.webServerSeparate, this.webServerSeparate);
    }

    public boolean isIgnoreSslWarnings() {
        return this.ignoreSslWarnings;
    }

    public void setIgnoreSslWarnings(boolean ignoreSslWarnings) {
        this.ignoreSslWarnings = ignoreSslWarnings;
        this.getPcs().firePropertyChange("ignoreSslWarnings", this.ignoreSslWarnings, this.ignoreSslWarnings);
    }

    @Override
    @JsonIgnore
    public IDatabaseType getType() {
        return type;
    }

    @Override
    public void validate() throws FeedbackException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FMServerPropertiesV6 v6 = (FMServerPropertiesV6)o;
        return this.webServerSeparate == v6.webServerSeparate && this.ignoreSslWarnings == v6.ignoreSslWarnings && Objects.equals(this.dbServerExternalIp, v6.dbServerExternalIp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dbServerExternalIp, this.webServerSeparate, this.ignoreSslWarnings);
    }

    @Override
    public String toString() {
        return "FMServerPropertiesV6{dbServerExternalIp='" + this.dbServerExternalIp + '\'' + ", hub=" + this.hub + "} " + super.toString();
    }

    public String getFmOpenUrl(Integer serverVersion) {
        String urlPrefix = serverVersion < 12 ? "fmp7://" : "fmp://";
        return urlPrefix + this.getHostname() + "/" + IOUtils.urlEncoded(this.getDatabase(), new Object[0]);
    }

    @Override
    public void writeFields(JsonGenerator gen) throws IOException {
        super.writeFields(gen);
        gen.writeStringField("dbServerExternalIp", this.dbServerExternalIp);
        gen.writeBooleanField("hub", this.hub);
        gen.writeBooleanField("webServerSeparate", this.webServerSeparate);
        gen.writeBooleanField("ignoreSslWarnings", this.ignoreSslWarnings);
        gen.writeStringField("adminUsername", this.adminUsername);
        gen.writeStringField("adminPassword", this.adminPassword);
    }

    @Override
    public void readFields(JsonNode node, JsonParser p) {
        super.readFields(node, p);
        this.dbServerExternalIp = node.get("dbServerExternalIp").textValue();
        this.hub = node.get("hub").booleanValue();
        this.webServerSeparate = node.get("webServerSeparate").booleanValue();
        this.ignoreSslWarnings = node.get("ignoreSslWarnings").booleanValue();
        this.adminUsername = node.get("adminUsername").textValue();
        this.adminPassword = node.get("adminPassword").textValue();
    }

    public URL getHostURL() {
        return UrlUtil.convertToURL(this.getHostname(), this.isSsl());
    }

    public URL getHostURLExternal() {
        return UrlUtil.convertToURL(this.getDbServerExternalIp(), this.isSsl());
    }
}

