/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class Device
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final long firstSyncTimestamp;
    private final long lastSyncTimestamp;
    private final String lastIpAddress;
    private final String name;
    private final String type;
    private long rowCount;
    private long totalSize;
    private long fileCount;
    private long allRowCount;

    public Device(int id, String name, long firstSyncTimestamp, long lastSyncTimestamp, String lastIpAddress, String type) {
        this.id = id;
        this.name = name;
        this.firstSyncTimestamp = firstSyncTimestamp;
        this.lastSyncTimestamp = lastSyncTimestamp;
        this.lastIpAddress = lastIpAddress;
        this.type = type;
    }

    private Device() {
        this.id = 0;
        this.firstSyncTimestamp = 0L;
        this.lastSyncTimestamp = 0L;
        this.lastIpAddress = null;
        this.name = null;
        this.type = null;
    }

    public int getId() {
        return this.id;
    }

    public Date getFirstSyncTimestampDate() {
        return new Date(this.firstSyncTimestamp);
    }

    public String getFirstSyncTimestamp() {
        return DateFormat.getDateTimeInstance(3, 3).format(this.getFirstSyncTimestampDate());
    }

    public Date getLastSyncTimestampDate() {
        return new Date(this.lastSyncTimestamp);
    }

    public String getLastSyncTimestamp() {
        return DateFormat.getDateTimeInstance(3, 3).format(this.getLastSyncTimestampDate());
    }

    public String getLastIpAddress() {
        return this.lastIpAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSize() {
        if (this.allRowCount == 0L) {
            return 0L;
        }
        return this.totalSize * this.rowCount / this.allRowCount;
    }

    public void setAllRowCount(long allRowCount) {
        this.allRowCount = allRowCount;
    }
}

