/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.infrastructure.ClassUtils;
import com.prosc.mirror.model.DatabaseClassification;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.IDatabaseType;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseType2
implements IDatabaseType,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DatabaseType2.class.getName());
    private transient ImageIcon icon;
    private final boolean isSchemaCreationSupported;
    private final boolean isFileMakerJdbc;
    private final String selectionInfo;
    private final boolean supportsSchemaModification;
    private final boolean supportsListDatabases;
    private final boolean canBeHub;
    private final boolean supportsSchema;
    private final boolean understandsFieldTypes;
    private final boolean requiresModificationTimestamp;
    private final DatabaseClassification classification;
    private final boolean configureFields;
    private final String name;
    private boolean canBeSpoke = true;

    public DatabaseType2(String name, DatabaseClassification classification, boolean fileMakerJdbc, boolean supportsSchemaModification, @Nullable String selectionInfo, boolean supportsListDatabases, boolean supportsSchema, boolean canBeHub, boolean configureFields, boolean requiresModificationTimestamp, boolean understandFieldTypes, boolean canCreateSchema) {
        this.name = name;
        this.isFileMakerJdbc = fileMakerJdbc;
        this.supportsSchemaModification = supportsSchemaModification;
        this.selectionInfo = selectionInfo;
        this.supportsListDatabases = supportsListDatabases;
        this.supportsSchema = supportsSchema;
        this.canBeHub = canBeHub;
        this.configureFields = configureFields;
        this.classification = classification;
        this.requiresModificationTimestamp = requiresModificationTimestamp;
        this.understandsFieldTypes = understandFieldTypes;
        this.isSchemaCreationSupported = canCreateSchema;
    }

    private DatabaseType2() {
        this.isSchemaCreationSupported = false;
        this.isFileMakerJdbc = false;
        this.selectionInfo = null;
        this.supportsSchemaModification = false;
        this.supportsListDatabases = false;
        this.canBeHub = false;
        this.supportsSchema = false;
        this.understandsFieldTypes = false;
        this.requiresModificationTimestamp = false;
        this.classification = null;
        this.configureFields = false;
        this.name = null;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.icon == null) {
            String unqualifiedName = this.getClass().getName();
            unqualifiedName = unqualifiedName.substring(unqualifiedName.lastIndexOf(46) + 1);
            try {
                this.icon = ClassUtils.getResource(this.getClass(), "/com/prosc/mirror/model/images/" + unqualifiedName + ".png").map(ImageIcon::new).orElse(null);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not load icon for " + this);
                this.icon = new ImageIcon();
            }
        }
        return this.icon;
    }

    @Override
    public boolean isUnderstandsFieldTypes() {
        return this.understandsFieldTypes;
    }

    @Override
    public boolean isRequiresModificationTimestamp() {
        return this.requiresModificationTimestamp;
    }

    @Override
    public final boolean isFileMakerJdbc() {
        return this.isFileMakerJdbc;
    }

    @Override
    public final String getSelectionInfo() {
        return this.selectionInfo;
    }

    @Override
    public final boolean isSupportsListDatabases() {
        return this.supportsListDatabases;
    }

    @Override
    public final boolean isCanBeHub() {
        return this.canBeHub;
    }

    @Override
    public boolean isSchemaCreationSupported() {
        return this.isSchemaCreationSupported;
    }

    @Override
    public boolean isCanBeSpoke() {
        return this.canBeSpoke;
    }

    public void setCanBeSpoke(boolean canBeSpoke) {
        this.canBeSpoke = canBeSpoke;
    }

    public boolean supportsCustomQualifier(DatabaseProperties properties) {
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public DatabaseClassification getDatabaseClassification() {
        return this.classification;
    }

    @Override
    public final boolean supportsSchemaModification() {
        return this.supportsSchemaModification;
    }

    @Override
    public final boolean isSupportsSchema() {
        return this.supportsSchema;
    }

    @Override
    public final boolean isConfigureFields() {
        return this.configureFields;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getSelectionName() {
        return this.getName();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().getName().equals(this.getClass().getName());
    }
}

