/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.prosc.mirror.model.DatabaseType2;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.dbtypes.GenericSQL;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomJDBCProperties
extends SqlProperties {
    private static final long serialVersionUID = 5720151121132292737L;
    private static final Logger log = Logger.getLogger(CustomJDBCProperties.class.getName());
    private static final DatabaseType2 type2 = new GenericSQL();
    private String driverClassName;
    private String jdbcURL;

    public CustomJDBCProperties(IDatabaseType type, UUID uniqueId) {
        super(uniqueId);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if ("".equals(driverClassName)) {
            driverClassName = null;
        }
        if (driverClassName != null) {
            // empty if block
        }
        this.driverClassName = driverClassName;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    @Override
    public void writeFields(JsonGenerator gen) throws IOException {
        super.writeFields(gen);
        gen.writeStringField("driverClassName", this.driverClassName);
        gen.writeStringField("jdbcURL", this.jdbcURL);
    }

    @Override
    public void readFields(JsonNode node, JsonParser p) {
        super.readFields(node, p);
        this.driverClassName = node.get("driverClassName").textValue();
        this.jdbcURL = node.get("jdbcURL").textValue();
    }

    public void setJdbcURL(String jdbcURL) {
        String hostName;
        this.jdbcURL = jdbcURL;
        String[] str = jdbcURL.split("://");
        String[] str2 = str[1].split("/");
        String[] str3 = str2[0].split(":");
        String dbName = str2[1].split(";")[0];
        try {
            InetAddress.getByName(str3[0]);
            hostName = str2[0];
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not set Hostname to " + str2[0] + " so set it to " + jdbcURL, e);
            hostName = jdbcURL;
        }
        this.setHostname(hostName);
        this.setDatabase(dbName);
    }

    @Override
    public IDatabaseType getType() {
        return type2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomJDBCProperties that = (CustomJDBCProperties)o;
        if (this.driverClassName != null ? !this.driverClassName.equals(that.driverClassName) : that.driverClassName != null) {
            return false;
        }
        return this.jdbcURL != null ? this.jdbcURL.equals(that.jdbcURL) : that.jdbcURL == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.driverClassName != null ? this.driverClassName.hashCode() : 0);
        result = 31 * result + (this.jdbcURL != null ? this.jdbcURL.hashCode() : 0);
        return result;
    }
}

