/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prosc.core.FeedbackException;
import com.prosc.data.BasicTypeConverter;
import com.prosc.database.JDBCUtils;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.TableConfig;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnInfo
implements Serializable,
Cloneable {
    private static final Logger log = Logger.getLogger(ColumnInfo.class.getName());
    private static final long serialVersionUID = 1L;
    private final String name;
    private boolean isIndexed;
    private final boolean isAutoIncrement;
    private boolean isNullable;
    private final Integer size;
    private final Integer precision;
    private final int maxRepetitions;
    private final boolean isSummary;
    private boolean isGlobal;
    private final boolean isCaseSensitive;
    private boolean isCalculation;
    private final String comment;
    private final String typeName;
    private AutoEnter autoEnter;
    private final String defaultValue;
    @Nullable
    private final String nodeJavaClassName;
    @Nullable
    private transient Class<?> _nodeJavaClass;
    private final boolean isEnum;
    private final boolean presentOnLayout;
    private int dataType;
    private boolean writeable;
    private transient ExternalTypeConverter externalTypeConverter;
    static final ExternalTypeConverter noConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            return input;
        }
    };
    static final ExternalTypeConverter stringConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                String result = BasicTypeConverter.convertObjectToString(input, columnInfo.isNullable());
                if (result == null && !columnInfo.isNullable()) {
                    result = "";
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to integer for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter integerConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToInteger(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to integer for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter floatConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToFloat(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to float for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter longConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToLong(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to long for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter doubleConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToDouble(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to double for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter booleanConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToBoolean(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to boolean for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter byteConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToByte(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to byte for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter shortConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToShort(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to short for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter timestampConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToTimestamp(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to timestamp for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter dateConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToDate(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to java.sql.Date for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter timeConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToTime(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to java.sql.Time for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter bigDecimalConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToBigDecimal(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to BigDecimal for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter numberConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToNumber(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to number for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter clobConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToCharacterStream(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to character stream for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    static final ExternalTypeConverter xmlGregorianCalendarConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object input, ColumnInfo columnInfo, String tableName) {
            try {
                return BasicTypeConverter.convertObjectToXMLGregorianCalendar(input, columnInfo.isNullable());
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error when converting input value '" + input + "' to timestamp for destination column '" + columnInfo.getName() + "' in table '" + tableName + "'", e);
                return input;
            }
        }
    };
    @JsonIgnore
    final ExternalTypeConverter enumConverter = new ExternalTypeConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object convertExternalValueToStatedDataType(Object o, ColumnInfo columnInfo, String tableName) {
            String stringValue = (String)stringConverter.convertExternalValueToStatedDataType(o, columnInfo, tableName);
            ColumnInfo.this.checkNodeJavaClass();
            Class c = ColumnInfo.this._nodeJavaClass;
            return Enum.valueOf(c, stringValue);
        }
    };

    public ColumnInfo(String columnName, int dataType) {
        this(columnName, dataType, null, null, false, false, false, true, false, AutoEnter.None, null);
    }

    public ColumnInfo(String columnName, int dataType, Integer size, Integer precision, boolean writeable, boolean indexed, boolean autoIncrement, boolean nullable, boolean isCaseSensitive, AutoEnter autoEnter, @Nullable String typeName) {
        this(columnName, dataType, size, precision, writeable, indexed, autoIncrement, nullable, isCaseSensitive, autoEnter, 1, false, false, true, typeName);
    }

    public ColumnInfo(String columnName, int dataType, Integer size, Integer precision, boolean writeable, boolean indexed, boolean autoIncrement, boolean nullable, boolean isCaseSensitive, AutoEnter autoEnter, int maxRepetitions, boolean isSummary, boolean isGlobal, boolean presentOnLayout, @Nullable String typeName) {
        this(columnName, dataType, size, precision, writeable, indexed, autoIncrement, nullable, isCaseSensitive, autoEnter, maxRepetitions, isSummary, isGlobal, null, false, null, null, presentOnLayout, typeName);
    }

    public ColumnInfo(@JsonProperty(value="name") String columnName, @JsonProperty(value="dataType") @Nullable Integer dataType, @JsonProperty(value="size") Integer size, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="writeable") boolean writeable, @JsonProperty(value="isIndexed") boolean indexed, @JsonProperty(value="isAutoIncrement") boolean autoIncrement, @JsonProperty(value="isNullable") boolean nullable, @JsonProperty(value="isCaseSensitive") boolean isCaseSensitive, @JsonProperty(value="autoEnter") AutoEnter autoEnter, @JsonProperty(value="maxRepetitions") int maxRepetitions, @JsonProperty(value="isSummary") boolean isSummary, @JsonProperty(value="isGlobal") boolean isGlobal, @JsonProperty(value="defaultValue") @Nullable String defaultValue, @JsonProperty(value="isCalculation") boolean isCalculation, @JsonProperty(value="comment") @Nullable String comment, @JsonProperty(value="_nodeJavaClass") @Nullable String nodeJavaClassName, @JsonProperty(value="presentOnLayout") boolean presentOnLayout, @JsonProperty(value="typeName") @Nullable String typeName) {
        this.name = columnName;
        if (dataType == null) {
            log.warning("No datatype set for column '" + columnName + "', javaClassName '" + nodeJavaClassName + "'");
            this.dataType = 1111;
        } else {
            this.dataType = dataType;
        }
        this.typeName = typeName;
        this.size = size;
        this.precision = precision;
        this.writeable = writeable;
        this.isIndexed = indexed;
        this.isAutoIncrement = autoIncrement;
        this.isNullable = nullable;
        this.defaultValue = defaultValue;
        this.maxRepetitions = maxRepetitions;
        this.isSummary = isSummary;
        this.isGlobal = isGlobal;
        this.isCaseSensitive = isCaseSensitive;
        this.isCalculation = isCalculation;
        this.autoEnter = autoEnter == null ? AutoEnter.None : autoEnter;
        this.comment = comment;
        this.nodeJavaClassName = nodeJavaClassName;
        if (nodeJavaClassName != null) {
            try {
                this._nodeJavaClass = Class.forName(nodeJavaClassName);
                this.isEnum = this._nodeJavaClass != null && this._nodeJavaClass.isEnum();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("nodeJavaClassName '" + nodeJavaClassName + "' is not present at runtime", e);
            }
        } else {
            this.isEnum = false;
        }
        this.presentOnLayout = presentOnLayout;
    }

    public ColumnInfo clone() throws CloneNotSupportedException {
        return (ColumnInfo)super.clone();
    }

    public Object convertExternalValueToStatedDataType(Object input, String tableName) {
        if (input == null) {
            return null;
        }
        this.checkNodeJavaClass();
        if (this.externalTypeConverter == null) {
            if (this._nodeJavaClass == String.class) {
                this.externalTypeConverter = stringConverter;
            } else if (this._nodeJavaClass == Integer.class) {
                this.externalTypeConverter = integerConverter;
            } else if (this._nodeJavaClass == Float.class) {
                this.externalTypeConverter = floatConverter;
            } else if (this._nodeJavaClass == Long.class) {
                this.externalTypeConverter = longConverter;
            } else if (this._nodeJavaClass == Double.class) {
                this.externalTypeConverter = doubleConverter;
            } else if (this._nodeJavaClass == BigDecimal.class) {
                this.externalTypeConverter = bigDecimalConverter;
            } else if (this._nodeJavaClass == Number.class) {
                this.externalTypeConverter = numberConverter;
            } else if (this._nodeJavaClass == Boolean.class) {
                this.externalTypeConverter = booleanConverter;
            } else if (this._nodeJavaClass == Byte.class) {
                this.externalTypeConverter = byteConverter;
            } else if (this._nodeJavaClass == Short.class) {
                this.externalTypeConverter = shortConverter;
            } else if (this._nodeJavaClass == Timestamp.class) {
                this.externalTypeConverter = timestampConverter;
            } else if (this._nodeJavaClass == Date.class) {
                this.externalTypeConverter = dateConverter;
            } else if (this._nodeJavaClass == Time.class) {
                this.externalTypeConverter = timeConverter;
            } else if (this._nodeJavaClass == XMLGregorianCalendar.class) {
                this.externalTypeConverter = xmlGregorianCalendarConverter;
            } else if (this._nodeJavaClass == Clob.class) {
                this.externalTypeConverter = clobConverter;
            } else if (this.isEnum) {
                this.externalTypeConverter = this.enumConverter;
            } else if (this._nodeJavaClass == Object.class) {
                this.externalTypeConverter = noConverter;
            } else {
                log.warning("No converter could be found for Java class " + this._nodeJavaClass + "; will not do any conversions");
                this.externalTypeConverter = noConverter;
            }
        }
        return this.externalTypeConverter.convertExternalValueToStatedDataType(input, this, tableName);
    }

    private void checkNodeJavaClass() {
        if (this._nodeJavaClass == null && this.nodeJavaClassName != null) {
            try {
                this._nodeJavaClass = Class.forName(this.nodeJavaClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._nodeJavaClass == null) {
            switch (this.dataType) {
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this._nodeJavaClass = String.class;
                    break;
                }
                case 4: {
                    this._nodeJavaClass = Integer.class;
                    break;
                }
                case 6: 
                case 7: {
                    this._nodeJavaClass = Float.class;
                    break;
                }
                case -5: {
                    this._nodeJavaClass = Long.class;
                    break;
                }
                case 8: {
                    this._nodeJavaClass = Double.class;
                    break;
                }
                case 2: 
                case 3: {
                    this._nodeJavaClass = Number.class;
                    break;
                }
                case -7: 
                case 16: {
                    this._nodeJavaClass = Boolean.class;
                    break;
                }
                case -6: {
                    this._nodeJavaClass = Byte.class;
                    break;
                }
                case 5: {
                    this._nodeJavaClass = Short.class;
                    break;
                }
                case 93: {
                    this._nodeJavaClass = Timestamp.class;
                    break;
                }
                case 91: {
                    this._nodeJavaClass = Date.class;
                    break;
                }
                case 92: {
                    this._nodeJavaClass = Time.class;
                    break;
                }
                case 2005: {
                    this._nodeJavaClass = Clob.class;
                    break;
                }
                case 1111: {
                    throw new IllegalArgumentException("You must supply a non-null value for either dataType, nodeJavaClass, or both");
                }
                default: {
                    this._nodeJavaClass = Object.class;
                }
            }
        }
    }

    public Object convertToNode(Object o, String nodeName) {
        if (o != null) {
            o = this.convertExternalValueToStatedDataType(o, nodeName);
        }
        return o;
    }

    public Object convertFromNode(Object o) {
        if (o != null && this.isEnum) {
            o = ((Enum)o).name();
        }
        return o;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForCalcEngine(TableConfig tableConfig) {
        if (this.name.contains("::")) {
            int mark1 = this.name.indexOf("::");
            String toName = this.name.substring(0, mark1);
            String fieldName = this.name.substring(mark1 += 2);
            return toName + "::${" + fieldName + "}";
        }
        return tableConfig.getTableOccurrenceName() + "::${" + this.name + "}";
    }

    public String getNameWithRepetitionCount() {
        return this.getName() + (this.getMaxRepetitions() < 2 ? "" : "[" + this.getMaxRepetitions() + "]");
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public void setIndexed(boolean indexed) {
        this.isIndexed = indexed;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public boolean isSummary() {
        return this.isSummary;
    }

    public boolean isCalculation() {
        return this.isCalculation;
    }

    public void setCalculation(boolean calculation) {
        this.isCalculation = calculation;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRelated() {
        return this.name.contains("::");
    }

    public boolean isNumber() {
        return JDBCUtils.isNumber(this.dataType);
    }

    public boolean isText() {
        return JDBCUtils.isText(this.dataType);
    }

    public boolean isDate() {
        return this.dataType == 91;
    }

    public boolean isTime() {
        return this.dataType == 92;
    }

    public boolean isTimestamp() {
        return this.dataType == 93;
    }

    public boolean isBinary() {
        return this.dataType == 2004 || this.dataType == -2 || this.dataType == -3 || this.dataType == -4;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isPresentOnLayout() {
        return this.presentOnLayout;
    }

    @NotNull
    public AutoEnter getAutoEnter() {
        return this.autoEnter == null ? AutoEnter.Unknown : this.autoEnter;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo info = (ColumnInfo)o;
        return this.isIndexed == info.isIndexed && this.isAutoIncrement == info.isAutoIncrement && this.isNullable == info.isNullable && this.maxRepetitions == info.maxRepetitions && this.isSummary == info.isSummary && this.isGlobal == info.isGlobal && this.isCaseSensitive == info.isCaseSensitive && this.isCalculation == info.isCalculation && this.isEnum == info.isEnum && this.dataType == info.dataType && this.writeable == info.writeable && Objects.equals(this.name, info.name) && Objects.equals(this.size, info.size) && Objects.equals(this.precision, info.precision) && Objects.equals(this.comment, info.comment) && this.autoEnter == info.autoEnter && Objects.equals(this.defaultValue, info.defaultValue) && Objects.equals(this.nodeJavaClassName, info.nodeJavaClassName) && Objects.equals(this.externalTypeConverter, info.externalTypeConverter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.isIndexed, this.isAutoIncrement, this.isNullable, this.size, this.precision, this.maxRepetitions, this.isSummary, this.isGlobal, this.isCaseSensitive, this.isCalculation, this.comment, this.autoEnter, this.defaultValue, this.nodeJavaClassName, this.isEnum, this.dataType, this.writeable});
    }

    public boolean isPrimaryKeyEligible() {
        if (this.isRelated() || this.isGlobal() || this.isSummary()) {
            return false;
        }
        if (this.dataType == -7 || this.dataType == 16 || this.dataType == -6) {
            return false;
        }
        if (this.isNumber()) {
            return true;
        }
        return this.dataType == 1111 || this.dataType == 12 || this.dataType == 1 || this.dataType == -16 || this.dataType == -1 || this.dataType == -15 || this.dataType == -8;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void setAutoEnter(AutoEnter autoEnter) {
        this.autoEnter = autoEnter;
    }

    public void validate() throws FeedbackException {
        if (this.name == null) {
            throw new FeedbackException("Colunmn name is null: " + this.toString());
        }
    }

    public String getDataTypeName() {
        return JDBCUtils.getDataTypeName(this.dataType);
    }

    static interface ExternalTypeConverter
    extends Serializable {
        public Object convertExternalValueToStatedDataType(Object var1, ColumnInfo var2, String var3);
    }
}

