/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.installer;

import com.prosc.aws.sqs.SendMessage;
import com.prosc.exception.UserCanceledException;
import com.prosc.io.IOUtils;
import com.prosc.mirror.installer.PasswordSelectionPanel;
import com.prosc.servlet.admin.CouldNotDownloadTomcatException;
import com.prosc.servlet.installer.IEProcessLaunchException;
import com.prosc.servlet.installer.InstallerAbortException;
import com.prosc.servlet.installer.InstallerGUI;
import com.prosc.servlet.installer.LaunchBrowser;
import com.prosc.servlet.installer.WebAppInstaller;
import com.prosc.shared.ExceptionUtils;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class MirrorSyncInstaller
extends WebAppInstaller {
    private static final Logger log = Logger.getLogger(MirrorSyncInstaller.class.getName());
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.prosc.strings");
    private final String installInstructions = resourceBundle.getString("installer.installInstructions.html");
    private final String successMessage = resourceBundle.getString("installer.SuccessMessage.html");
    private final String uninstallMessage = resourceBundle.getString("installer.UninstallMessage.html");

    public static void main(final String[] args) {
        log.info("Installer started");
        if (args.length > 0 && "-debugMode".equals(args[0])) {
            WebAppInstaller.debugMode = true;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new InstallerGUI(new MirrorSyncInstaller(new File(System.getProperty("mirrorSyncWarPath", "MirrorSync.war")))).run(args);
                }
                catch (UserCanceledException e) {
                    log.log(Level.WARNING, "User canceled installation", e);
                    System.exit(4);
                }
                catch (Throwable t) {
                    String message = t.getLocalizedMessage();
                    if (message == null) {
                        message = t.toString();
                    }
                    if (ExceptionUtils.getSpecificCause(t, CouldNotDownloadTomcatException.class) != null) {
                        Object[] options = new String[]{resourceBundle.getString("HelpIntro.okButton.text"), resourceBundle.getString("installer.checkDocs")};
                        int choice = JOptionPane.showOptionDialog(null, resourceBundle.getString("installer.couldNotDownloadTomcat"), null, -1, 0, null, options, options[0]);
                        if (choice == 1) {
                            try {
                                new LaunchBrowser().launch(CouldNotDownloadTomcatException.DOCS_URL);
                                log.info("Launched docs in browser");
                            }
                            catch (IEProcessLaunchException e) {
                                log.log(Level.SEVERE, "Could not open MirrorSync docs", e);
                            }
                        } else {
                            log.info(String.valueOf(choice));
                        }
                    } else {
                        ExceptionUtils.reportAndLogException(Level.SEVERE, null, MessageFormat.format(resourceBundle.getString("installer.failed").replace("'", "''"), message), t);
                    }
                    System.exit(3);
                }
            }
        });
    }

    public MirrorSyncInstaller(File mirrorSyncWar) throws IOException, InstallerAbortException {
        super(mirrorSyncWar);
    }

    @Override
    public String getProductTitle() {
        return "360Works MirrorSync";
    }

    @Override
    public String getInstallInstructions() {
        return this.installInstructions;
    }

    @Override
    public String getSuccessMessage() {
        return this.successMessage;
    }

    @Override
    public String getUninstallMessage() {
        return this.uninstallMessage;
    }

    @Override
    protected void preInstallUI() throws IOException, UserCanceledException, InstallerAbortException {
        String message;
        JComponent label;
        int choice;
        super.preInstallUI();
        Frame rootFrame = JOptionPane.getRootFrame();
        File syncData1Folder = new File(this.get360WorksDir(), "SyncData3_" + this.getAppName());
        File syncData4Folder = new File(this.get360WorksDir(), "SyncData4_" + this.getAppName());
        if (syncData1Folder.exists() && !syncData4Folder.exists() && (choice = JOptionPane.showConfirmDialog(rootFrame, label = ExceptionUtils.createFixedWidthHtmlMessage(message = resourceBundle.getString("installer.upgrading"), 600), resourceBundle.getString("installer.upgrading.title"), 2, 2, null)) == 2) {
            throw new UserCanceledException();
        }
        final JDialog setPwDialog = new JDialog(rootFrame, resourceBundle.getString("installer.setAdminPassword"), true);
        setPwDialog.setDefaultCloseOperation(0);
        final PasswordSelectionPanel panel = new PasswordSelectionPanel();
        final boolean[] didCancel = new boolean[]{false};
        panel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                didCancel[0] = true;
                setPwDialog.dispose();
            }
        });
        panel.getSetPasswordButton().addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String username = panel.getUsernameField().getText();
                    String password = String.valueOf(panel.getPasswordField().getPassword());
                    if (username == null || username.length() == 0 || password.length() == 0) {
                        JOptionPane.showMessageDialog(panel, resourceBundle.getString("installer.requiredUsernamePassword"));
                        return;
                    }
                    log.log(Level.INFO, "Saving admin login info to preferences");
                    Properties adminProps = new Properties();
                    adminProps.put("adminusername", username);
                    String hashedString = MirrorSyncInstaller.generateMD5HashString(password);
                    adminProps.put("adminpassword", hashedString);
                    final boolean reportStats = panel.getStatsCheckbox().isSelected();
                    adminProps.put("reportStats", String.valueOf(reportStats));
                    new Thread("EnableMetrics message"){

                        @Override
                        public void run() {
                            try {
                                String queueUrl = "https://sqs.us-east-1.amazonaws.com/669916120315/SyncStats";
                                new SendMessage(null, true, queueUrl, "EnableMetrics").setMessageAttribute("enabled", String.valueOf(reportStats)).setMessageAttribute("version", MirrorSyncInstaller.this.getDeploymentInfo().getVersion()).setMessageAttribute("timestamp", System.currentTimeMillis()).setMessageAttribute("messageType", "EnableMetrics").call();
                            }
                            catch (IOException e1) {
                                log.log(Level.WARNING, "Could not contact Amazon SQS server", e1);
                            }
                        }
                    }.start();
                    File syncDataFolder = new File(MirrorSyncInstaller.this.get360WorksDir(), "SyncData4_" + MirrorSyncInstaller.this.getAppName());
                    IOUtils.ensureDirectoryIsReady(syncDataFolder);
                    File propsFile = new File(syncDataFolder, ".mirrorsync_properties");
                    try (FileOutputStream propStream = new FileOutputStream(propsFile);){
                        adminProps.store(propStream, null);
                        log.info("Prefs were successfully written");
                    }
                    setPwDialog.dispose();
                }
                catch (Exception ex) {
                    String message = MessageFormat.format(resourceBundle.getString("installer.couldNotSetAdminPassword").replace("'", "''"), ex.toString());
                    log.log(Level.SEVERE, message, ex);
                    JOptionPane.showMessageDialog(panel, message);
                }
            }
        });
        setPwDialog.getRootPane().setDefaultButton(panel.getSetPasswordButton());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        setPwDialog.setContentPane(panel);
        setPwDialog.pack();
        setPwDialog.setLocationRelativeTo(rootFrame);
        panel.getUsernameField().requestFocusInWindow();
        setPwDialog.setVisible(true);
        if (didCancel[0]) {
            throw new UserCanceledException();
        }
    }

    public static String generateMD5HashString(String theString) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(theString.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Something is wrong with JDK, cannot login", e);
            throw new IllegalStateException("Misconfiguration on server; cannot login.", e);
        }
        byte[] hash = digest.digest();
        return MirrorSyncInstaller.byteArrayToHex(hash);
    }

    public static String byteArrayToHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        return String.format("%0" + (array.length << 1) + "X", bi).toLowerCase();
    }

    @Override
    protected void install(JDialog parent) throws IOException, InstallerAbortException, InterruptedException, UserCanceledException {
        String syncDataFolderName = "SyncData4_" + this.getAppName();
        try {
            File oldSyncData;
            File fmServerHome = WebAppInstaller.fmUtils.getFmServerHome();
            File newSyncData = new File(this.get360WorksDir(), syncDataFolderName);
            if (!newSyncData.exists() && (oldSyncData = new File(fmServerHome, syncDataFolderName)).exists()) {
                this.updateStatus(resourceBundle.getString("installer.status.copyingSyncData"));
                IOUtils.copyDirectory(oldSyncData, newSyncData);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not preserve " + syncDataFolderName + " folder: ", e);
        }
        super.install(parent);
    }
}

