/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.config.client;

import com.prosc.core.FeedbackException;
import com.prosc.data.tuple.Pair;
import com.prosc.exception.UserCanceledException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.mirror.config.NoSuchTableException;
import com.prosc.mirror.config.TableConfigValidator;
import com.prosc.mirror.config.client.ConfigClientNodes;
import com.prosc.mirror.config.client.MappingRow;
import com.prosc.mirror.config.client.Table;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.ConflictStrategy;
import com.prosc.mirror.model.DatabaseClassification;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.FMServerProperties;
import com.prosc.mirror.model.FMServerPropertiesV6;
import com.prosc.mirror.model.FileMakerGoProperties;
import com.prosc.mirror.model.FileMakerGoPropertiesV6;
import com.prosc.mirror.model.FileMakerPropertiesV6;
import com.prosc.mirror.model.ForeignKeyInfo;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.MirrorConfig;
import com.prosc.mirror.model.MirrorConfigServer;
import com.prosc.mirror.model.MirrorSyncException;
import com.prosc.mirror.model.SyncType;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.TableInfo;
import com.prosc.mirror.model.ValidationParam;
import com.prosc.mirror.model.dbtypes.FileMakerGo;
import com.prosc.mirror.model.dbtypes.FileMakerGoV6;
import com.prosc.mirror.model.dbtypes.FileMakerServer;
import com.prosc.shared.StringUtils;
import com.prosc.swing.ListModelWrapper;
import com.prosc.swing.verifiers.EmailInputVerifier;
import com.prosc.sync.NoSuchDatabaseException;
import com.prosc.sync.SyncDirection;
import com.prosc.thread.ThreadUtil;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WizardModel
implements Serializable,
Cloneable,
Closeable {
    private static final Logger log = Logger.getLogger(WizardModel.class.getName());
    static final String CREATE_THIS_TABLE = "<Create this table>";
    private static final long serialVersionUID = 1L;
    @NotNull
    private final transient MirrorConfigServer configServer;
    private final ConfigClientNodes source;
    private Map<String, Table> sourceTables;
    private final ListModelWrapper<ConfigClientNodes> destinations = new ListModelWrapper(new ArrayList());
    private Map<String, Table> destinationTables;
    private final Map<String, Pair<TableConfig, TableConfig>> tableMapByName = new LinkedHashMap<String, Pair<TableConfig, TableConfig>>();
    private final Set<String> configuredTables = new HashSet<String>();
    public String newCreationTimestampName = "Creation_Timestamp";
    public String newModTimestampName = "Modification_Timestamp";
    public String newPrimaryKeyName = "id";
    private transient PropertyChangeSupport pcs;
    @NotNull
    private MirrorConfig _config;
    private final int webPort;
    private boolean createDatabase = false;
    private Integer clientVersion;
    private List<List<MappingRow>> mappings;
    NoSuchTableException noSuchTable = null;

    public WizardModel(@NotNull MirrorConfigServer configServer, int webPort, @NotNull MirrorConfig config) {
        this(configServer, webPort, config, config.getHubDatabaseProperties(), config.getSpokesDatabaseProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardModel(@NotNull MirrorConfigServer configServer, int webPort, @NotNull MirrorConfig config, @Nullable DatabaseProperties hubProperties, @NotNull List<DatabaseProperties> spokeProperties) {
        log.info("Creating new WizardModel for " + config.toString());
        this.configServer = configServer;
        this.webPort = webPort;
        this._config = config;
        if (config.getMsVersion() == null || config.getMsVersion() < 6 || config.getHubDatabaseProperties() instanceof FMServerProperties) {
            if (config.getHubDatabaseProperties() instanceof FMServerProperties) {
                config.setHubDatabaseProperties(new FMServerPropertiesV6((FMServerProperties)config.getHubDatabaseProperties()));
                hubProperties = config.getHubDatabaseProperties();
            }
            config.setSpokesDatabaseProperties(config.getSpokesDatabaseProperties().stream().map(properties -> {
                if (properties instanceof FileMakerGoProperties) {
                    return new FileMakerGoPropertiesV6((FileMakerGoProperties)properties);
                }
                if (properties instanceof FMServerProperties) {
                    return new FMServerPropertiesV6((FMServerProperties)properties);
                }
                return properties;
            }).collect(Collectors.toList()));
            Stream.concat(config.getHubTables().stream(), config.getSpokeTables().stream()).forEach(table -> table.setLimitedToFieldsOnLayout(true));
            config.setServerCopyStart(LocalTime.of(23, 0));
            config.setServerCopyEnd(LocalTime.of(3, 0));
        }
        this.source = new ConfigClientNodes(this, true, hubProperties);
        this.sourceTables = Table.map(config.getHubTables(), this.source);
        for (DatabaseProperties eachSpokeProperties : config.getSpokesDatabaseProperties()) {
            this.destinations.add((Object)new ConfigClientNodes(this, false, eachSpokeProperties));
        }
        if (this.destinations.isEmpty()) {
            this.destinations.add((Object)new ConfigClientNodes(this, false));
        }
        this.destinationTables = Table.map(config.getSpokeTables(), this.getFirstDestination());
        Map<String, Pair<TableConfig, TableConfig>> map = this.tableMapByName;
        synchronized (map) {
            Iterator<TableConfig> hubIterator = config.getHubTables().iterator();
            Iterator<TableConfig> spokeIterator = config.getSpokeTables().iterator();
            while (hubIterator.hasNext()) {
                TableConfig nextHub = hubIterator.next();
                TableConfig nextSpoke = spokeIterator.next();
                this.tableMapByName.put(nextHub.getTableName(), new Pair<TableConfig, TableConfig>(nextHub, nextSpoke));
                this.configuredTables.add(nextHub.getTableName());
            }
        }
    }

    @NotNull
    public synchronized MirrorConfig getCurrentConfig() {
        return this._config;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public synchronized void setCurrentConfig(@NotNull MirrorConfig config) {
        MirrorConfig oldValue = this._config;
        try {
            Runnable runnable = () -> {
                config.setBrandNew(this._config.isBrandNew());
                this._config = config;
                this.source.setDatabaseProperties(config.getHubDatabaseProperties());
                Iterator destinationIterator = this.destinations.iterator();
                Iterator<DatabaseProperties> spokePropertiesIterator = config.getSpokesDatabaseProperties().iterator();
                while (destinationIterator.hasNext()) {
                    ConfigClientNodes nextDest = (ConfigClientNodes)destinationIterator.next();
                    DatabaseProperties nextSpokeProperties = spokePropertiesIterator.next();
                    nextDest.setDatabaseProperties(nextSpokeProperties);
                }
                Iterator<TableConfig> hubIterator = config.getHubTables().iterator();
                Iterator<TableConfig> spokeIterator = config.getSpokeTables().iterator();
                Map<String, Pair<TableConfig, TableConfig>> map = this.tableMapByName;
                synchronized (map) {
                    this.tableMapByName.clear();
                    while (hubIterator.hasNext()) {
                        TableConfig hubConfig = hubIterator.next();
                        this.tableMapByName.put(hubConfig.getTableName(), new Pair<TableConfig, TableConfig>(hubConfig, spokeIterator.next()));
                    }
                }
                this.sourceTables = Table.map(config.getHubTables(), this.source);
                this.destinationTables = Table.map(config.getSpokeTables(), this.getFirstDestination());
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getPcs().firePropertyChange("currentConfig", oldValue, this._config);
    }

    @NotNull
    public MirrorConfig getTempConfig() {
        MirrorConfig currentConfig = this.getCurrentConfig();
        MirrorConfig tempConfig = currentConfig.deepClone();
        this.writeToConfig(tempConfig, false);
        return tempConfig;
    }

    @NotNull
    public MirrorConfigServer getConfigServer() {
        if (SwingUtilities.isEventDispatchThread()) {
            log.log(Level.INFO, "getConfigServer() should usually be called on a background thread to prevent unresponsive UI");
        }
        if (Boolean.getBoolean("com.prosc.slowmo")) {
            log.log(Level.INFO, "Simulating slow network connection");
            ThreadUtil.sleepDebug(1900L);
        }
        return this.configServer;
    }

    public Map<String, Pair<TableConfig, TableConfig>> getTableMap() {
        return this.tableMapByName;
    }

    public boolean isTableMapEmpty() {
        return this.tableMapByName.isEmpty();
    }

    @NotNull
    public ConfigClientNodes getSource() {
        return this.source;
    }

    @NotNull
    public ConfigClientNodes getFirstDestination() {
        return (ConfigClientNodes)this.destinations.get(0);
    }

    public ListModelWrapper<ConfigClientNodes> getDestinations() {
        return this.destinations;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    public String getSyncServerInternalAddress() {
        return this.getCurrentConfig().getSyncServerInternalAddress();
    }

    public void setSyncServerInternalAddress(String newAddress) {
        String oldValue = this.getCurrentConfig().getSyncServerInternalAddress();
        this.getCurrentConfig().setSyncServerInternalAddress(newAddress);
        this.getPcs().firePropertyChange("syncServerInternalAddress", oldValue, newAddress);
    }

    public String getSyncServerExternalAddress() {
        return this.getCurrentConfig().getSyncServerExternalAddress();
    }

    public void setSyncServerExternalAddress(String newAddress) {
        String oldValue = this.getCurrentConfig().getSyncServerExternalAddress();
        this.getCurrentConfig().setSyncServerExternalAddress(newAddress);
        this.getPcs().firePropertyChange("syncServerExternalAddress", oldValue, newAddress);
    }

    public boolean isExternalAddressesDifferent() {
        return this.getCurrentConfig().isExternalAddressesDifferent();
    }

    public void setExternalAddressesDifferent(boolean newValue) {
        boolean oldValue = this.getCurrentConfig().isExternalAddressesDifferent();
        this.getCurrentConfig().setExternalAddressesDifferent(newValue);
        this.getPcs().firePropertyChange("externalAddressesDifferent", oldValue, newValue);
    }

    public void writeToConfig(MirrorConfig whichConfig, boolean setDatabaseProperties) {
        if (setDatabaseProperties) {
            whichConfig.setHubDatabaseProperties(this.getSource().getDatabaseProperties());
            ArrayList<DatabaseProperties> spokesDatabaseProperties = new ArrayList<DatabaseProperties>(this.destinations.size());
            for (ConfigClientNodes eachDest : this.destinations) {
                spokesDatabaseProperties.add(eachDest.getDatabaseProperties());
            }
            whichConfig.setSpokesDatabaseProperties(spokesDatabaseProperties);
        }
        whichConfig.removeAllTablesToSync();
        for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
            if (pair.b == null) continue;
            whichConfig.addTablesToSync((TableConfig)pair.a, (TableConfig)pair.b);
        }
        this.getPcs().firePropertyChange("saved", false, true);
    }

    public void save(boolean setDatabaseProperties) throws FeedbackException, IOException, InvalidLicenseException {
        this.tableMapByName.values().stream().map(pair -> (TableConfig)pair.b).forEach(spokeConfig -> spokeConfig.setVirtual(false));
        this.writeToConfig(this.getCurrentConfig(), setDatabaseProperties);
        try {
            this.saveToServer();
        }
        catch (UserCanceledException e) {
            throw new FeedbackException("Could not validate field mappings because the MirrorSync process on the server was interrupted by an administrator", e);
        }
    }

    protected abstract void saveToServer() throws IOException, InvalidLicenseException, UserCanceledException, MirrorSyncException;

    public boolean isTableConfigured(TableConfig config) {
        return this.configuredTables.contains(config.getTableName());
    }

    public void addConfiguredTable(TableConfig config) {
        this.configuredTables.add(config.getTableName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        this.getPcs().addPropertyChangeListener(key, listener);
    }

    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        this.getPcs().removePropertyChangeListener(key, listener);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public Map<String, Table> getSourceTables() {
        return this.sourceTables;
    }

    List<TableConfig> getHubTableConfigs() {
        return this.sourceTables.values().stream().map(Table::getTableConfig).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    LinkedHashMap<TableConfig, TableInfo> fetchTableInfosForConfigs(ConfigClientNodes whichNodes, Collection<TableConfig> tableConfigs) throws MirrorSyncException, RemoteException, NoSuchTableException {
        LinkedHashMap<String, TableInfo> tableInfosByName = new LinkedHashMap<String, TableInfo>(tableConfigs.size());
        for (TableConfig config : tableConfigs) {
            if (config.isVirtual()) continue;
            tableInfosByName.put(config.getTableName(), null);
        }
        tableInfosByName.putAll(whichNodes.getTableInfos(tableInfosByName.keySet()));
        LinkedHashMap<TableConfig, TableInfo> tableConfigMap = new LinkedHashMap<TableConfig, TableInfo>(tableConfigs.size());
        for (TableConfig tableConfig : tableConfigs) {
            tableConfigMap.put(tableConfig, (TableInfo)tableInfosByName.get(tableConfig.getTableName()));
        }
        return tableConfigMap;
    }

    public Map<String, Table> getDestinationTables() {
        return this.destinationTables;
    }

    public IDatabaseType getDestinationType() {
        return ((ConfigClientNodes)this.getDestinations().get(0)).getDatabaseProperties().getType();
    }

    @Nullable
    public Integer getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(Integer clientVersion) {
        this.clientVersion = clientVersion;
    }

    public boolean isCopyOfHubDatabase(ConfigClientNodes configNodes) {
        return !configNodes.isHub() && !this.getCurrentConfig().isSchemaMapped() && configNodes.getDatabaseProperties().getType().getDatabaseClassification() == DatabaseClassification.fmServer;
    }

    public MirrorConfig validateSyncConfiguration(MirrorConfig config, @Nullable EnumSet<ValidationParam> validationParameters, boolean validateHub, boolean validateSpoke, boolean ignoreMissingSpokeDatabase, boolean cacheLogin) throws MirrorSyncException, NoSuchDatabaseException, InvalidLicenseException {
        try {
            if (cacheLogin) {
                try {
                    DatabaseProperties dbProperties;
                    if (validateHub) {
                        dbProperties = this.getCurrentConfig().getHubDatabaseProperties();
                        this.getConfigServer().cacheDatabaseForProperties(dbProperties);
                    }
                    if (validateSpoke) {
                        dbProperties = this.getCurrentConfig().getFirstSpokeProperties();
                        this.getConfigServer().cacheDatabaseForProperties(dbProperties);
                    }
                }
                catch (RemoteException e) {
                    log.log(Level.WARNING, "Could not cache database on server, this is generally caused by a newer config client with an older server.", e);
                }
            }
            if (validateSpoke && validationParameters != null) {
                validationParameters.add(ValidationParam.CHECK_LICENSE);
            }
            return this.getConfigServer().validateSyncConfiguration(config, validationParameters, this.webPort, validateHub, validateSpoke, ignoreMissingSpokeDatabase);
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, "Network error while validating sync configuration with validation parameters: " + validationParameters, e);
            throw new MirrorSyncException(e);
        }
        catch (MirrorSyncException e) {
            log.log(Level.WARNING, "Error while validating sync configuration with validation parameters: " + validationParameters, e);
            throw e;
        }
    }

    public int getFmServerVersion(ConfigClientNodes configNodes) {
        int serverVersion;
        try {
            serverVersion = (Integer)this.getConfigServer().getDatabaseMetaData(configNodes.getDatabaseProperties());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not determine FileMaker version from server; assuming 12", e);
            serverVersion = 12;
        }
        return serverVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTableMap(Collection<String> selectedHubTableNames) throws MirrorSyncException {
        try {
            HashMap<String, String> occurrenceToTableName = new HashMap<String, String>(selectedHubTableNames.size());
            LinkedHashSet<String> newTableSet = new LinkedHashSet<String>(selectedHubTableNames);
            LinkedHashMap<TableConfig, Object> newMap = new LinkedHashMap<TableConfig, Object>(selectedHubTableNames.size());
            for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
                TableConfig hubTableConfig = (TableConfig)pair.a;
                if (newTableSet.remove(hubTableConfig.getTableName())) {
                    newMap.put(hubTableConfig, pair.b);
                    occurrenceToTableName.put(hubTableConfig.getTableOccurrenceName(), hubTableConfig.getTableName());
                    continue;
                }
                log.config("A prevously configured table, '" + hubTableConfig.getTableName() + "', will not be included in the new table map because it is not in the new list of hub table names: " + selectedHubTableNames);
            }
            if (!newTableSet.isEmpty()) {
                try {
                    this.source.getTableInfos(newTableSet);
                }
                catch (NoSuchTableException noSuchTableException) {
                    // empty catch block
                }
                for (String eachTableName : newTableSet) {
                    try {
                        if (eachTableName.contains("\\")) {
                            throw new MirrorSyncException("Sync layouts cannot contain backslash characters. Re-name layout '" + eachTableName + "' (and the underlying table occurrence if it also contains a backslash) and then click the refresh button.");
                        }
                        if (eachTableName.indexOf(46) != -1) {
                            throw new MirrorSyncException("Layout names used for synchronization cannot contain a period (.) - first occurrence is '" + eachTableName + "'");
                        }
                        TableInfo tableInfo = this.source.getTableInfo(eachTableName);
                        if (tableInfo.getTableOccurrenceName().contains("\\")) {
                            throw new MirrorSyncException("Sync layouts cannot be based on TOs that contain backslash characters. Change layout '" + eachTableName + "' to a different TO or rename the '" + tableInfo.getTableOccurrenceName() + "' table occurrence and then click the refresh button.");
                        }
                        String existingTableName = occurrenceToTableName.put(tableInfo.getTableOccurrenceName(), tableInfo.getTableName());
                        if (existingTableName != null) {
                            throw new MirrorSyncException("Layouts '" + existingTableName + "' and '" + eachTableName + "' both point to table occurrence '" + tableInfo.getTableOccurrenceName() + "'. You should not specify the same table occurrence more than once.");
                        }
                        TableConfig sourceConfig = this.source.getTableConfigWithName(eachTableName, true).orElseGet(() -> this.source.createTableConfigWithName(eachTableName));
                        newMap.put(sourceConfig, null);
                        occurrenceToTableName.put(sourceConfig.getTableOccurrenceName(), sourceConfig.getTableName());
                    }
                    catch (NoSuchTableException e) {
                        this.noSuchTable = e;
                        log.log(Level.WARNING, "Table '" + eachTableName + "' will not be included in the sync; because the associated base table occurrence or base table is missing");
                    }
                }
            }
            if (this.getCurrentConfig().isDetectLayouts() && StringUtils.isEmpty(this.getCurrentConfig().getLayoutScanPrefix())) {
                throw new MirrorSyncException("To automatically detect layouts, you must enter a layout prefix.");
            }
            Map<String, Pair<TableConfig, TableConfig>> map = this.tableMapByName;
            synchronized (map) {
                this.tableMapByName.clear();
                newMap.forEach((key, value) -> this.tableMapByName.put(key.getTableName(), new Pair<TableConfig, TableConfig>((TableConfig)key, (TableConfig)value)));
            }
        }
        catch (IOException e) {
            String message = "Couldn't communicate with MirrorSync server because of an I/O error: " + e.getMessage();
            log.log(Level.WARNING, message, e);
            throw new MirrorSyncException(message);
        }
        if (this.isTableMapEmpty()) {
            if (this.noSuchTable == null) {
                throw new MirrorSyncException("You must select at least one table to sync");
            }
            throw new MirrorSyncException(this.noSuchTable);
        }
    }

    public ListModelWrapper<TableConfig> getSourceTableModel() {
        List sourceTables = this.tableMapByName.values().stream().map(pair -> (TableConfig)pair.a).sorted().collect(Collectors.toList());
        return new ListModelWrapper(sourceTables);
    }

    public ListModelWrapper<String> getDestTableModel(boolean refresh) throws MirrorSyncException {
        ArrayList<String> availableDestTables;
        try {
            availableDestTables = new ArrayList<String>(this.getFirstDestination().getTableNames(refresh));
        }
        catch (NoSuchDatabaseException e) {
            if (this.getCurrentConfig().isFileMakerSpokeDuplicateOfHub()) {
                availableDestTables = new ArrayList<String>(this.getSourceTableNames());
            }
            throw new MirrorSyncException(e);
        }
        availableDestTables.remove("MirrorSync");
        ListModelWrapper<TableConfig> sourceConfigs = this.getSourceTableModel();
        ArrayList<String> mappedDestTables = new ArrayList<String>();
        for (TableConfig sourceConfig : sourceConfigs) {
            String destName = null;
            TableConfig destConfig = (TableConfig)this.tableMapByName.get((Object)sourceConfig.getTableName()).b;
            String tableName = destConfig == null ? sourceConfig.getTableName() : destConfig.getTableName();
            if (availableDestTables.contains(tableName)) {
                destName = tableName;
                availableDestTables.remove(tableName);
            } else {
                String cookedName1 = tableName.toLowerCase().replace(" ", "").replace("_", "");
                ListIterator<String> iterator = availableDestTables.listIterator();
                while (iterator.hasNext()) {
                    String availableName = iterator.next();
                    String cookedName2 = availableName.toLowerCase().replace(" ", "").replace("_", "");
                    if (!cookedName1.equals(cookedName2)) continue;
                    destName = availableName;
                    iterator.remove();
                }
            }
            if (destName == null && this.getDestinationType().isSchemaCreationSupported() && this.getDestinationType().isConfigureFields()) {
                destName = CREATE_THIS_TABLE;
            }
            mappedDestTables.add(destName);
        }
        ArrayList<String> remainingDestTables = new ArrayList<String>(availableDestTables);
        Collections.sort(remainingDestTables);
        mappedDestTables.addAll(remainingDestTables);
        return new ListModelWrapper(mappedDestTables);
    }

    @NotNull
    public Pair<Set<String>, Set<String>> addRemoveTables() throws MirrorSyncException {
        Pair<Set<String>, Set<String>> result;
        TableConfig existingConfig1;
        Set _destSyncLayoutLowercaseNames;
        List sourceSyncLayoutNames;
        block19: {
            String layoutPrefix = this.getCurrentConfig().getLayoutScanPrefix();
            try {
                sourceSyncLayoutNames = this.source.getTableNames(false).stream().filter(name -> !this.getCurrentConfig().isDetectLayouts() || name.toLowerCase().startsWith(layoutPrefix.toLowerCase())).collect(Collectors.toList());
                try {
                    _destSyncLayoutLowercaseNames = this.getFirstDestination().getTableNames(false).stream().map(String::toLowerCase).filter(name -> !this.getCurrentConfig().isDetectLayouts() || name.startsWith(layoutPrefix.toLowerCase())).collect(Collectors.toSet());
                }
                catch (MirrorSyncException | NoSuchDatabaseException e) {
                    if ((e instanceof NoSuchDatabaseException || e.getMessage().startsWith("Unable to open file")) && !this.getCurrentConfig().isSchemaMapped() && this.getCurrentConfig().isFileMakerServerToFileMakerServer()) {
                        log.info("File has not been placed onto spoke server yet; assume identical to source");
                        _destSyncLayoutLowercaseNames = sourceSyncLayoutNames.stream().map(String::toLowerCase).collect(Collectors.toSet());
                        break block19;
                    }
                    throw e;
                }
            }
            catch (NoSuchDatabaseException e) {
                throw new MirrorSyncException(e);
            }
        }
        Set destSyncLayoutLowercaseNames = _destSyncLayoutLowercaseNames;
        ArrayList<String> beforeList = new ArrayList<String>(this.tableMapByName.keySet());
        Iterator<Object> iterator = this.tableMapByName.values().iterator();
        if (iterator.hasNext()) {
            existingConfig1 = (TableConfig)iterator.next().a;
        } else {
            ColumnInfo fakePK = new ColumnInfo("fakePK", 4);
            try {
                existingConfig1 = new TableConfig("Ignored", "Ignored", fakePK, null, null, null, Collections.emptyList(), Collections.emptyList(), false, SyncDirection.readWrite, ConflictStrategy.UserPicks, true, true);
            }
            catch (FeedbackException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCurrentConfig().isDetectLayouts()) {
            if (sourceSyncLayoutNames.size() == 0) {
                throw new MirrorSyncException("There are no tables matching the specified prefix. Change the prefix, or create layouts with a matching name, or do manual selections.");
            }
            HashSet<String> commonLayoutNames = new HashSet<String>(sourceSyncLayoutNames);
            if (!this.getFirstDestination().getDatabaseProperties().getType().isDynamicTables()) {
                commonLayoutNames.removeIf(eachName -> !destSyncLayoutLowercaseNames.contains(eachName.toLowerCase()));
                if (commonLayoutNames.size() == 0) {
                    throw new MirrorSyncException("The auto-detected layouts do not exist in the destination database. Try manually selecting the layouts instead.");
                }
            }
            this.buildTableMap(commonLayoutNames);
        } else {
            iterator = this.tableMapByName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (sourceSyncLayoutNames.contains(entry.getKey())) {
                    if (destSyncLayoutLowercaseNames.contains(((TableConfig)((Pair)entry.getValue()).b).getTableName().toLowerCase())) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
        ArrayList<String> afterList = new ArrayList<String>(this.tableMapByName.keySet());
        if (beforeList.equals(afterList)) {
            result = new Pair<Set<String>, Set<String>>(Collections.emptySet(), Collections.emptySet());
        } else {
            Set removedTables = beforeList.stream().filter(beforeName -> !afterList.contains(beforeName)).collect(Collectors.toSet());
            Set addedTables = afterList.stream().filter(afterName -> !beforeList.contains(afterName)).collect(Collectors.toSet());
            log.warning("List of tables to sync changed. \nOld list: " + beforeList + "\nNew list: " + afterList + "\nAdditions: " + addedTables + "\nSubtractions: " + removedTables);
            for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
                TableConfig hubConfig = (TableConfig)pair.a;
                if (!addedTables.contains(hubConfig.getTableName())) continue;
                @Nullable TableConfig spokeConfig = (TableConfig)pair.b;
                hubConfig.updateOptionsFrom(existingConfig1);
                if (spokeConfig == null) continue;
                spokeConfig.updateOptionsFrom(existingConfig1);
            }
            result = new Pair(addedTables, removedTables);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateTableMapping(Map<TableConfig, String> sourceConfigToDestName) throws MirrorSyncException, RemoteException, NoSuchTableException {
        if (sourceConfigToDestName.values().stream().anyMatch(Objects::isNull)) {
            throw new MirrorSyncException("Please make sure that every source table on the left is matched with a destination table on the right.");
        }
        LinkedHashMap<TableConfig, TableConfig> replacementTableMap = new LinkedHashMap<TableConfig, TableConfig>();
        ArrayList<String> destTablesToFetch = new ArrayList<String>();
        for (Map.Entry<TableConfig, String> entry : sourceConfigToDestName.entrySet()) {
            String destTable = entry.getValue();
            if (CREATE_THIS_TABLE.equals(destTable) || this.getFirstDestination().getTableConfigWithName(destTable, true).isPresent()) continue;
            destTablesToFetch.add(destTable);
        }
        this.getFirstDestination().getTableInfos(destTablesToFetch);
        for (Map.Entry<TableConfig, String> entry : sourceConfigToDestName.entrySet()) {
            TableConfig sourceConfig = entry.getKey();
            String destTable = entry.getValue();
            replacementTableMap.put(sourceConfig, this.getFirstDestination().getTableConfigWithName(destTable, true).orElseGet(() -> {
                try {
                    TableConfig result;
                    if (CREATE_THIS_TABLE.equals(destTable)) {
                        result = this.getConfigServer().duplicateTableConfiguration(this.getFirstDestination().getDatabaseProperties(), this.getCurrentConfig(), sourceConfig);
                        result.setCreateSchema(true);
                    } else {
                        result = this.getFirstDestination().createTableConfigWithName(destTable);
                    }
                    return result;
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        for (Map.Entry<TableConfig, String> entry : replacementTableMap.entrySet()) {
            Iterator<ForeignKeyInfo> hubIterator = entry.getKey().getForeignKeys().iterator();
            Iterator<ForeignKeyInfo> spokeIterator = ((TableConfig)((Object)entry.getValue())).getForeignKeys().iterator();
            while (hubIterator.hasNext()) {
                ForeignKeyInfo fk = hubIterator.next();
                ForeignKeyInfo spokeFk = spokeIterator.hasNext() ? spokeIterator.next() : null;
                if (this.tableMapByName.containsKey(fk.getToTable())) continue;
                hubIterator.remove();
                if (spokeFk == null) continue;
                spokeIterator.remove();
            }
        }
        for (Map.Entry<TableConfig, String> entry : replacementTableMap.entrySet()) {
            TableConfig hubConfig = entry.getKey();
            TableConfig spokeConfig = (TableConfig)((Object)entry.getValue());
            if (hubConfig.isUUID() && spokeConfig.isUUID()) continue;
            hubConfig.setUUID(false);
            spokeConfig.setUUID(false);
        }
        Map<String, Pair<TableConfig, TableConfig>> map = this.tableMapByName;
        synchronized (map) {
            this.tableMapByName.clear();
            replacementTableMap.forEach((key, value) -> this.tableMapByName.put(key.getTableName(), new Pair<TableConfig, TableConfig>((TableConfig)key, (TableConfig)value)));
        }
    }

    public void validateTableConfiguration(Collection<TableConfig> hubConfigs) throws FeedbackException, NoSuchTableException {
        String email = this.getCurrentConfig().getAdminEmail();
        if (StringUtils.isEmpty(email)) {
            if (this.getCurrentConfig().getSyncType() == SyncType.serverToServer) {
                throw new FeedbackException("For server-to-server syncs, an administrator email address is required.");
            }
            for (TableConfig tableConfig : hubConfigs) {
                if (!ConflictStrategy.EmailAdministrator.equals((Object)tableConfig.getConflictStrategy())) continue;
                throw new FeedbackException("Please enter an admin email address, or specify a different conflict resolution strategy.");
            }
        } else {
            if (!new EmailInputVerifier().validateEmail(email)) {
                throw new FeedbackException("Invalid email address");
            }
            this.checkAdminEmailForVerfication(email);
        }
        try {
            this.fetchTableInfosForConfigs(this.source, hubConfigs);
        }
        catch (NoSuchTableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FeedbackException(e);
        }
        for (Pair pair : this.tableMapByName.values()) {
            try {
                TableConfig hubTable = (TableConfig)pair.a;
                TableConfig spokeTable = (TableConfig)pair.b;
                if (spokeTable == null) continue;
                spokeTable.updateOptionsFrom(hubTable);
                spokeTable.setUUID(hubTable.isUUID());
                spokeTable.setSyncDirection(hubTable.getSyncDirection());
                spokeTable.setAutoMergeEnabled(hubTable.isAutoMergeEnabled());
                spokeTable.setConflictStrategy(hubTable.getConflictStrategy());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error fetching table config", e);
            }
        }
    }

    private void checkAdminEmailForVerfication(String adminEmail) {
    }

    public List<ColumnInfo> getPkEligibleColumns(@NotNull ConfigClientNodes nodes, TableInfo tableInfo, TableConfig tableConfig) {
        LinkedList<ColumnInfo> columnInfos = new LinkedList<ColumnInfo>();
        boolean isFileMaker = nodes.getDatabaseProperties() instanceof FMServerProperties || nodes.getDatabaseProperties() instanceof FMServerPropertiesV6;
        boolean isHub = nodes.isHub();
        for (ColumnInfo columnInfo : tableInfo.getColumns(tableConfig.isLimitedToFieldsOnLayout())) {
            if (!columnInfo.isPrimaryKeyEligible() && nodes.getDatabaseProperties().getType().isUnderstandsFieldTypes()) continue;
            if (tableConfig.isUUID() && this.getCurrentConfig().getSyncDirectionAdjusted(tableConfig, isHub).isWriteable() && !columnInfo.isWriteable()) {
                log.fine("Column '" + columnInfo + "' is not a valid primary key. For developer-managed keys in writeable tables, the primary key must also be writeable.");
                continue;
            }
            columnInfos.add(columnInfo);
        }
        columnInfos.sort(new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
        return columnInfos;
    }

    public Collection<ColumnInfo> getWritebackEligibleColumns(TableConfig tableConfig, TableInfo tableInfo) {
        LinkedList<ColumnInfo> columnInfos = new LinkedList<ColumnInfo>();
        for (ColumnInfo columnInfo : tableInfo.getColumns(tableConfig.isLimitedToFieldsOnLayout())) {
            if (!columnInfo.isPrimaryKeyEligible()) continue;
            columnInfos.add(columnInfo);
        }
        columnInfos.sort(new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
        return columnInfos;
    }

    public Collection<ColumnInfo> getModTimeEligibleColumns(ConfigClientNodes nodes, TableConfig config, TableInfo tableInfo) {
        LinkedList<ColumnInfo> modstampColumns = new LinkedList<ColumnInfo>();
        IDatabaseType dbType = nodes.getDatabaseProperties().getType();
        for (ColumnInfo columnInfo : tableInfo.getColumns(config.isLimitedToFieldsOnLayout())) {
            if (!columnInfo.isTimestamp()) continue;
            modstampColumns.add(columnInfo);
        }
        modstampColumns.sort(new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
        return modstampColumns;
    }

    public Collection<ColumnInfo> getCreationTimeEligibleColumns(ConfigClientNodes nodes, TableConfig config, TableInfo tableInfo) {
        LinkedList<ColumnInfo> columns = new LinkedList<ColumnInfo>();
        for (ColumnInfo columnInfo : tableInfo.getColumns(config.isLimitedToFieldsOnLayout())) {
            if (!columnInfo.isTimestamp()) continue;
            columns.add(columnInfo);
        }
        columns.sort(new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
            }
        });
        return columns;
    }

    public void validatePrimaryKeyAndModStamps() throws FeedbackException {
        for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
            TableConfig destTableConfig;
            TableConfig sourceTableConfig = (TableConfig)pair.a;
            boolean isSourceConfigurable = this.source.getDatabaseProperties().getType().isConfigureFields();
            boolean isDestConfigurable = this.getDestinationType().isConfigureFields();
            if (isSourceConfigurable) {
                this.validateTableConfig(sourceTableConfig, this.source.getDatabaseProperties(), true);
            }
            if ((destTableConfig = (TableConfig)pair.b) == null) {
                throw new RuntimeException("The destination configuration has not been created yet; it should exist by now in the setup process (validatePrimaryKeyAndModStamps). Please report this issue to support@360works.com");
            }
            if (this.getCurrentConfig().isSchemaMapped()) {
                boolean destWriteback;
                boolean sourceWriteback = sourceTableConfig.getWriteback() != null;
                boolean bl = destWriteback = destTableConfig.getWriteback() != null;
                if (sourceWriteback && !destWriteback || destWriteback && !sourceWriteback) {
                    throw new FeedbackException("Writeback column must be set for the both the source and destination, or for neither.");
                }
                if (destTableConfig.getWriteback() != null && sourceTableConfig.getWriteback() == null && !sourceTableConfig.isUUID()) {
                    sourceTableConfig.setWriteback(sourceTableConfig.getPrimaryKey1());
                }
            } else {
                destTableConfig.setPrimaryKey1(sourceTableConfig.getPrimaryKey1());
                destTableConfig.setPrimaryKey2(sourceTableConfig.getPrimaryKey2());
                destTableConfig.setModTimestampColumn(sourceTableConfig.getModTimeColumn());
                destTableConfig.setCreationTimestampColumn(sourceTableConfig.getCreationTimestampColumn());
                destTableConfig.setWriteback(sourceTableConfig.getWriteback());
            }
            if (!isDestConfigurable) continue;
            this.validateTableConfig(destTableConfig, this.getFirstDestination().getDatabaseProperties(), false);
            if (destTableConfig.getWriteback() != null && destTableConfig.getPrimaryKey1() != null && destTableConfig.getPrimaryKey1().getName().equals(destTableConfig.getWriteback().getName())) {
                if (this.getCurrentConfig().isSchemaMapped()) {
                    throw new FeedbackException("The write-back column for the spoke must not be the same field as its primary key. Consult the MirrorSync documentation at http://docs.360works.com for an explanation of the write-back process.");
                }
                throw new FeedbackException("The write-back column must not be the same field as the primary key. Consult the MirrorSync documentation at http://docs.360works.com for an explanation of the write-back process.");
            }
            if (!this.isMapFields() || sourceTableConfig.getPrimaryKey2() == null != (destTableConfig.getPrimaryKey2() != null)) continue;
            throw new FeedbackException("Secondary primary key must be specified for both sides of " + sourceTableConfig.getTableName() + "/" + destTableConfig.getTableName());
        }
    }

    private void validateTableConfig(TableConfig tableConfig, DatabaseProperties databaseProperties, boolean hub) throws FeedbackException {
        AutoEnter ae1;
        boolean timestampOptional;
        String tableName = tableConfig.getTableName();
        if (tableConfig.getPrimaryKey1() == null) {
            throw new FeedbackException("You must specify a primary key for " + tableName);
        }
        boolean bl = timestampOptional = !hub && tableConfig.getSyncDirection() == SyncDirection.writeOnlyRelaxed;
        if (databaseProperties.getType().isRequiresModificationTimestamp()) {
            if (tableConfig.getModTimeColumn() == null && !timestampOptional) {
                throw new FeedbackException("You must specify a modification timestamp column for " + tableName);
            }
            if (tableConfig.getModTimeColumn() != null && tableConfig.getModTimeColumn() == tableConfig.getCreationTimestampColumn()) {
                throw new FeedbackException("Creation and modification timestamps must be different in " + tableName);
            }
            if (databaseProperties instanceof FMServerProperties && tableConfig.getCreationTimestampColumn() == null) {
                throw new FeedbackException("You must specify a creation timestamp column for " + tableName);
            }
        }
        if (tableConfig.isWriteable(hub) && tableConfig.getPrimaryKey2() == null && !tableConfig.isUUID() && databaseProperties instanceof FileMakerPropertiesV6 && ((ae1 = tableConfig.getPrimaryKey1().getAutoEnter()) == AutoEnter.None || ae1 == AutoEnter.CreationTimestamp)) {
            if (!hub && !tableConfig.getSyncDirection().isReadable()) {
                log.log(Level.FINER, "Ignoring auto-enter requirement validation for one-way syncs to a non-hub table " + tableConfig);
            } else {
                throw new FeedbackException("For tables with one primary key, that key must be an auto-enter value, but " + tableName + "." + tableConfig.getPrimaryKey1().getName() + " is not.");
            }
        }
    }

    public boolean isMapFields() {
        return this.getCurrentConfig().isSchemaMapped() && this.getDestinationType().isConfigureFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoDetectForeignKeys(@Nullable Collection<String> hubTableNames, boolean clearExistingKeys) throws MirrorSyncException, RemoteException, NoSuchTableException {
        MirrorConfig config;
        WizardModel wizardModel = this;
        synchronized (wizardModel) {
            config = this.getCurrentConfig();
        }
        List<TableConfig> hubConfigs = this.getHubTableConfigs();
        Map<String, TableInfo> tableInfos = hubTableNames == null ? this.source.getTableInfos(this.getSourceTableNames()) : this.source.getTableInfos(hubTableNames);
        Map<String, Set<ForeignKeyInfo>> keys = this.getConfigServer().autoDetectForeignKeys(this.source.getDatabaseProperties(), hubConfigs, tableInfos.values(), config.getName());
        for (TableConfig eachTableConfig : hubConfigs) {
            if (!keys.containsKey(eachTableConfig.getTableName())) continue;
            Set<ForeignKeyInfo> detectedFKs = keys.get(eachTableConfig.getTableName());
            if (clearExistingKeys) {
                eachTableConfig.getForeignKeys().clear();
            } else {
                Iterator<ForeignKeyInfo> existingFkIterator = eachTableConfig.getForeignKeys().iterator();
                while (existingFkIterator.hasNext()) {
                    boolean isValid;
                    ForeignKeyInfo existingFk = existingFkIterator.next();
                    detectedFKs.remove(existingFk);
                    boolean bl = isValid = eachTableConfig.getDataColumnWithName(existingFk.getFromColumn()).isPresent() && existingFk.getToTable() != null;
                    if (isValid) {
                        try {
                            config.getHubTableWithName(existingFk.getToTable());
                            existingFk.validate();
                        }
                        catch (Exception e) {
                            isValid = false;
                        }
                    }
                    if (isValid) continue;
                    log.warning("Removing foreign key from " + eachTableConfig.getTableName() + " because it is not valid: " + existingFk);
                    existingFkIterator.remove();
                }
            }
            for (ForeignKeyInfo fk : detectedFKs) {
                boolean fromColumnIsInConfiguration = eachTableConfig.getDataColumns().stream().anyMatch(column -> column.getName().equals(fk.getFromColumn()));
                boolean toTableIsInConfiguration = hubConfigs.stream().anyMatch(tableConfig -> tableConfig.getTableName().equals(fk.getToTable()));
                if (fromColumnIsInConfiguration && toTableIsInConfiguration) {
                    eachTableConfig.getForeignKeys().add(fk);
                    continue;
                }
                if (!fromColumnIsInConfiguration) {
                    log.config("Not adding foreign key " + fk + " because the column is not a syncing field in that table");
                    continue;
                }
                log.config("Not adding foreign key " + fk + " because the destination table is not included in the sync");
            }
        }
    }

    public Collection<String> getSourceTableNames() {
        return Collections.unmodifiableCollection(this.tableMapByName.keySet());
    }

    @NotNull
    public List<String> getRelatedTableNames(ForeignKeyInfo foreignKey) {
        ArrayList<String> tableNames = new ArrayList<String>(this.tableMapByName.size());
        for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
            TableConfig hubTableConfig = (TableConfig)pair.a;
            if (hubTableConfig.getPrimaryKeys().size() == 1) {
                tableNames.add(hubTableConfig.getTableName());
                continue;
            }
            log.log(Level.FINE, "Excluding " + hubTableConfig + ", since count of primary keys != 1");
        }
        tableNames.sort(String.CASE_INSENSITIVE_ORDER);
        return tableNames;
    }

    public boolean isUserConflictResolutionSupported() {
        return this.getDestinationType() instanceof FileMakerGo || this.getDestinationType() instanceof FileMakerGoV6 || this.source.getDatabaseProperties().getType() instanceof FileMakerGo || this.source.getDatabaseProperties().getType() instanceof FileMakerGoV6;
    }

    public TableConfig getSourceTableNamed(String tableName) {
        TableConfig result = (TableConfig)this.tableMapByName.get((Object)tableName).a;
        if (result == null) {
            throw new IllegalArgumentException("There is no source table named " + tableName);
        }
        return result;
    }

    void setAllFieldMappings(@Nullable Integer index) throws FeedbackException, RemoteException {
        int n = 0;
        ArrayList<TableConfig> spokeConfigsToPostProcess = new ArrayList<TableConfig>(this.tableMapByName.size());
        for (Map.Entry<String, Pair<TableConfig, TableConfig>> entry : this.tableMapByName.entrySet()) {
            if (index == null || index == n) {
                Pair<TableConfig, TableConfig> pair = entry.getValue();
                TableConfig hubConfig = (TableConfig)pair.a;
                @Nullable TableConfig tableConfig = (TableConfig)pair.b;
                if (tableConfig != null) {
                    this.addFieldMappings(hubConfig, tableConfig, n);
                    this.establishForeignKeys(hubConfig, tableConfig);
                    spokeConfigsToPostProcess.add(tableConfig);
                }
            }
            ++n;
        }
        this.writeToConfig(this.getCurrentConfig(), true);
        try {
            List<TableConfig> updatedSpokeConfigs = this.getConfigServer().postProcessTableConfiguration(this.getFirstDestination().getDatabaseProperties(), this.getCurrentConfig(), spokeConfigsToPostProcess);
            for (TableConfig updatedSpokeConfig : updatedSpokeConfigs) {
                for (Map.Entry entry : this.tableMapByName.entrySet()) {
                    Pair pair = (Pair)entry.getValue();
                    if (pair.b == null || !((TableConfig)pair.b).getTableName().equals(updatedSpokeConfig.getTableName())) continue;
                    entry.setValue(new Pair(pair.a, updatedSpokeConfig));
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof NoSuchDatabaseException) {
                log.log(Level.INFO, "Couldn't run postProcessTableConfiguration on first destination database: " + this.getFirstDestination().getDatabaseProperties() + " for spoke configs: " + spokeConfigsToPostProcess + ". This is probably because the database doesn't exist on the spoke yet; so will ignore.", e);
            }
            throw new FeedbackException(e);
        }
        n = 0;
        for (Pair pair : this.tableMapByName.values()) {
            if (index == null || index == n) {
                TableConfig hubConfig = (TableConfig)pair.a;
                @Nullable TableConfig spokeConfig = (TableConfig)pair.b;
                if (spokeConfig != null) {
                    this.validateFieldMappings(hubConfig, spokeConfig);
                }
            }
            ++n;
        }
    }

    void validateFieldMappings(TableConfig hubConfig) throws FeedbackException {
        int n = 0;
        for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
            if (hubConfig == pair.a) {
                @Nullable TableConfig spokeConfig = (TableConfig)pair.b;
                if (spokeConfig == null) {
                    throw new RuntimeException("The destination configuration has not been created yet; it should exist by now in the setup process (validateFieldMappings). Please report this issue to support@360works.com");
                }
                this.addFieldMappings(hubConfig, spokeConfig, n);
                this.validateFieldMappings(hubConfig, spokeConfig);
                break;
            }
            ++n;
        }
    }

    private void addFieldMappings(@NotNull TableConfig hubConfig, @NotNull TableConfig spokeConfig, int tableIndex) throws FeedbackException {
        List<MappingRow> mappingRows = this.mappings.get(tableIndex);
        if (mappingRows == null) {
            throw new IllegalArgumentException("No mapping rows for index " + tableIndex + ". Mappings: " + this.mappings);
        }
        if (this.getCurrentConfig().getHubDatabaseProperties() != null && this.getCurrentConfig().getHubDatabaseProperties().getType() instanceof FileMakerServer) {
            for (MappingRow row : mappingRows) {
                if (row.sourceField == null || !"recid".equalsIgnoreCase(row.sourceField.getName()) || !row.isSync()) continue;
                throw new FeedbackException("You cannot sync a field named 'recid'; that is a reserved field name in FileMaker Server. Either rename the field or remove it from the sync (table " + hubConfig.getTableName() + ")");
            }
        }
        hubConfig.clearDataColumns();
        spokeConfig.clearDataColumns();
        hubConfig.getIgnoredFields().clear();
        spokeConfig.getIgnoredFields().clear();
        for (MappingRow row : mappingRows) {
            if (row.isSync() && row.dataColumn) {
                if (row.sourceField == null) {
                    log.warning("Cannot add row " + row + " to data columns, because the source field is null. Dest field: " + row.getDestField());
                    continue;
                }
                if (row.getDestField() == null) {
                    log.warning("Cannot add row " + row + " to data columns, because the dest field is null. Source field: " + row.sourceField);
                    continue;
                }
                hubConfig.addDataColumn(row.sourceField);
                spokeConfig.addDataColumn(row.getDestField());
                continue;
            }
            if (row.sourceField == null || row.getDestField() == null || !StringUtils.isEmpty(row.disabledReason) || row.map.booleanValue()) continue;
            hubConfig.getIgnoredFields().add(row.sourceField.getName());
            spokeConfig.getIgnoredFields().add(row.getDestField().getName());
        }
        if (hubConfig.getPrimaryKey2() != null) {
            if (!hubConfig.dataColumnsContain(hubConfig.getPrimaryKey1())) {
                hubConfig.addDataColumn(hubConfig.getPrimaryKey1());
            }
            if (!hubConfig.dataColumnsContain(hubConfig.getPrimaryKey2())) {
                hubConfig.addDataColumn(hubConfig.getPrimaryKey2());
            }
            if (!spokeConfig.dataColumnsContain(spokeConfig.getPrimaryKey1())) {
                spokeConfig.addDataColumn(spokeConfig.getPrimaryKey1());
            }
            if (!spokeConfig.dataColumnsContain(spokeConfig.getPrimaryKey2())) {
                spokeConfig.addDataColumn(spokeConfig.getPrimaryKey2());
            }
        }
    }

    private void validateFieldMappings(@NotNull TableConfig hubConfig, @NotNull TableConfig spokeConfig) throws FeedbackException {
        boolean validateSpoke = !spokeConfig.isVirtual();
        new TableConfigValidator().validateConfig(this.source, hubConfig);
        if (validateSpoke) {
            new TableConfigValidator().validateConfig(this.getFirstDestination(), spokeConfig);
        }
        new TableConfigValidator().validate(this, hubConfig, spokeConfig);
        if (validateSpoke && !this.isTableConfigured(hubConfig)) {
            throw new FeedbackException("You have not configured table " + hubConfig + " yet.");
        }
        if (this.getCurrentConfig().getSyncType().isClient()) {
            int fieldCount = 0;
            for (ColumnInfo info : hubConfig.getDataColumns()) {
                fieldCount += info.getMaxRepetitions();
            }
            if (fieldCount > 998) {
                this.refreshTables();
                throw new FeedbackException("There are " + fieldCount + " fields for table '" + hubConfig.getTableName() + "'. Due to limitations in the FileMaker let() function, there is a limit of 998 fields for a table.");
            }
        }
    }

    List<List<MappingRow>> getMappings() {
        return this.mappings;
    }

    public void establishForeignKeys() {
        for (Map.Entry<String, Pair<TableConfig, TableConfig>> entry : this.tableMapByName.entrySet()) {
            Pair<TableConfig, TableConfig> pair = entry.getValue();
            TableConfig hubConfig = (TableConfig)pair.a;
            @Nullable TableConfig spokeConfig = (TableConfig)pair.b;
            if (spokeConfig == null) continue;
            this.establishForeignKeys(hubConfig, spokeConfig);
        }
    }

    private void establishForeignKeys(TableConfig sourceConfig, TableConfig destConfig) {
        destConfig.getForeignKeys().clear();
        Iterator<ForeignKeyInfo> it = sourceConfig.getForeignKeys().iterator();
        while (it.hasNext()) {
            ForeignKeyInfo foreignKeyInfo = it.next();
            MirrorConfig mirrorConfig = this.getTempConfig();
            try {
                ForeignKeyInfo destForeignKey = mirrorConfig.translateForeignKeyInfo(sourceConfig, destConfig, foreignKeyInfo, true);
                destConfig.getForeignKeys().add(destForeignKey);
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Removing foreign key '" + foreignKeyInfo + "' from table config '" + sourceConfig + "' due to an error: " + e.getLocalizedMessage(), e);
                it.remove();
            }
        }
    }

    public void updateFieldMappings(@Nullable Integer tableIndex) throws MirrorSyncException, NoSuchTableException {
        if (tableIndex == null) {
            try {
                this.source.getTableInfos(this.tableMapByName.keySet());
                List<String> destTableNames = this.tableMapByName.values().stream().filter(pair -> pair.b != null).map(pair -> ((TableConfig)pair.b).getTableName()).collect(Collectors.toList());
                this.getFirstDestination().getTableInfos(destTableNames);
            }
            catch (RemoteException e) {
                throw new MirrorSyncException(e);
            }
        }
        if (tableIndex == null) {
            this.mappings = new ArrayList<List<MappingRow>>(this.tableMapByName.size());
        } else if (this.mappings == null) {
            this.mappings = new ArrayList<List<MappingRow>>(this.tableMapByName.size());
            for (int n = 0; n < this.tableMapByName.size(); ++n) {
                this.mappings.add(null);
            }
        }
        int n = -1;
        for (Pair<TableConfig, TableConfig> pair2 : this.tableMapByName.values()) {
            if (tableIndex != null && tableIndex != ++n) continue;
            TableConfig sourceConfig = (TableConfig)pair2.a;
            @Nullable TableConfig destConfig = (TableConfig)pair2.b;
            if (destConfig == null) continue;
            if (tableIndex == null) {
                this.mappings.add(null);
                this.generateRows(n, sourceConfig, destConfig);
                continue;
            }
            this.generateRows(tableIndex, sourceConfig, destConfig);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void generateRows(int whichTable, @NotNull TableConfig sourceConfig, @NotNull TableConfig destConfig) throws MirrorSyncException, NoSuchTableException {
        MirrorConfig config;
        WizardModel wizardModel = this;
        synchronized (wizardModel) {
            config = this.getCurrentConfig();
        }
        try {
            HashMap<String, void> previousMapping;
            boolean isConfigured;
            TableInfo sourceInfo = this.source.getTableInfo(sourceConfig.getTableName());
            sourceConfig.refreshFrom(sourceInfo);
            TableInfo destInfo = this.getFirstDestination().getTableInfo(destConfig.getTableName());
            destConfig.refreshFrom(destInfo);
            boolean bl = isConfigured = sourceConfig.getDataColumnsCount() > 0;
            if (isConfigured) {
                this.addConfiguredTable(sourceConfig);
            }
            int sourceInfoColumnCount = sourceInfo.getColumns(sourceConfig.isLimitedToFieldsOnLayout()).size();
            ArrayList<MappingRow> mappingRows = new ArrayList<MappingRow>(sourceInfoColumnCount);
            HashSet<String> sourceFieldsSet = new HashSet<String>(sourceInfoColumnCount);
            HashSet<String> destFieldsSet = new HashSet<String>(destInfo.isSchemaless() ? sourceInfoColumnCount : destInfo.getColumns(destConfig.isLimitedToFieldsOnLayout()).size());
            HashSet<String> lockedSourceFieldSet = new HashSet<String>(sourceInfoColumnCount);
            HashSet<String> lockedDestFieldSet = new HashSet<String>(sourceInfoColumnCount);
            if (sourceConfig.getPrimaryKey1() != null && sourceConfig.isUUID() && sourceConfig.getPrimaryKey2() == null && destConfig.getPrimaryKey1() != null) {
                mappingRows.add(new MappingRow(config, sourceConfig, destConfig, sourceConfig.getPrimaryKey1(), destConfig.getPrimaryKey1(), true, true, "Developer-managed primary keys must be mapped to each other.", false));
                sourceFieldsSet.add(sourceConfig.getPrimaryKey1().getName());
                destFieldsSet.add(destConfig.getPrimaryKey1().getName());
            } else {
                if (sourceConfig.getPrimaryKey1() != null && sourceConfig.getPrimaryKey2() == null) {
                    sourceFieldsSet.add(sourceConfig.getPrimaryKey1().getName());
                }
                if (destConfig.getPrimaryKey1() != null && destConfig.getPrimaryKey2() == null) {
                    destFieldsSet.add(destConfig.getPrimaryKey1().getName());
                }
            }
            if (sourceConfig.getWriteback() != null && sourceInfo.getColumnWithName(sourceConfig.getWriteback().getName(), false).isPresent() && destConfig.getWriteback() != null && (destInfo.isSchemaless() || destInfo.getColumnWithName(destConfig.getWriteback().getName(), false).isPresent())) {
                lockedSourceFieldSet.add(sourceConfig.getWriteback().getName());
                lockedDestFieldSet.add(destConfig.getWriteback().getName());
                mappingRows.add(new MappingRow(config, sourceConfig, destConfig, sourceConfig.getWriteback(), destConfig.getWriteback(), true, true, "Writeback columns must be mapped to each other.", true));
                sourceFieldsSet.add(sourceConfig.getWriteback().getName());
                destFieldsSet.add(destConfig.getWriteback().getName());
            }
            if (sourceConfig.getModTimeColumn() != null) {
                sourceFieldsSet.add(sourceConfig.getModTimeColumn().getName());
            }
            if (sourceConfig.getCreationTimestampColumn() != null) {
                sourceFieldsSet.add(sourceConfig.getCreationTimestampColumn().getName());
            }
            if (destConfig.getModTimeColumn() != null) {
                destFieldsSet.add(destConfig.getModTimeColumn().getName());
            }
            if (destConfig.getCreationTimestampColumn() != null) {
                destFieldsSet.add(destConfig.getCreationTimestampColumn().getName());
            }
            if (sourceConfig.getCreationTimestampColumn() != null && sourceInfo.getColumnWithName(sourceConfig.getCreationTimestampColumn().getName(), false).isPresent() && destConfig.getCreationTimestampColumn() != null && (destInfo.isSchemaless() || destInfo.getColumnWithName(destConfig.getCreationTimestampColumn().getName(), false).isPresent())) {
                mappingRows.add(new MappingRow(config, sourceConfig, destConfig, sourceConfig.getCreationTimestampColumn(), destConfig.getCreationTimestampColumn(), true, true, "Creation timestamps always sync to each other.", true));
            }
            List<MappingRow> previousMappingList = this.mappings.get(whichTable);
            if (previousMappingList != null) {
                previousMapping = new HashMap(previousMappingList.size());
                for (MappingRow mappingRow : previousMappingList) {
                    void var17_20;
                    ColumnInfo sourceField = mappingRow.sourceField;
                    if (sourceField == null || TableConfig.MISSING_COLUMN.getName().equals(sourceField.getName())) continue;
                    if (mappingRow.map.booleanValue() && mappingRow.getDestField() != null) {
                        ColumnInfo sourceColumn = sourceInfo.getColumnWithName(sourceField.getName(), false).orElse(null);
                        ColumnInfo destColumn = destInfo.getColumnWithName(mappingRow.getDestField().getName(), false).orElse(null);
                        if (destColumn == null && destInfo.isSchemaless() && sourceColumn != null) {
                            destColumn = this.duplicateSourceColumn(sourceColumn);
                        }
                        MappingRow mappingRow2 = new MappingRow(config, sourceConfig, destConfig, sourceColumn, destColumn, mappingRow.map, mappingRow.locked, mappingRow.disabledReason, true);
                    }
                    previousMapping.put(sourceField.getName(), var17_20);
                }
            } else {
                previousMapping = new HashMap<String, void>();
            }
            if (sourceConfig.getDataColumns().size() == destConfig.getDataColumns().size()) {
                Iterator<ColumnInfo> destIterator = destConfig.getDataColumns().iterator();
                for (ColumnInfo sourceColumn : sourceConfig.getDataColumns()) {
                    boolean shouldAddRow = sourceFieldsSet.add(sourceColumn.getName());
                    ColumnInfo matchingDestColumn = destIterator.next();
                    if (shouldAddRow) {
                        if (TableConfig.MISSING_COLUMN.getName().equals(sourceColumn.getName()) || TableConfig.MISSING_COLUMN.getName().equals(matchingDestColumn.getName())) {
                            log.finest("Skip sourceColumn " + sourceColumn + " and dest column " + matchingDestColumn + " because one or both has been removed from the database");
                        } else {
                            MappingRow previousRow = (MappingRow)previousMapping.get(sourceColumn.getName());
                            if (previousRow != null) {
                                mappingRows.add(previousRow);
                            } else {
                                boolean locked = lockedSourceFieldSet.contains(sourceColumn.getName());
                                mappingRows.add(new MappingRow(config, sourceConfig, destConfig, sourceColumn, matchingDestColumn, true, locked, null, true));
                            }
                        }
                    }
                    destFieldsSet.add(matchingDestColumn.getName());
                }
            } else {
                previousMapping.clear();
                String message = "Source config has " + sourceConfig.getDataColumns().size() + " columns, but dest config has " + destConfig.getDataColumns().size() + ". These are matched by index and must contain the same number of items. Will re-match all columns by name, ignoring previous custom mappings\nSource config list: " + sourceConfig.getDataColumns() + "\nDest config list: " + destConfig.getDataColumns();
                log.log(Level.WARNING, message);
            }
            for (ColumnInfo columnInfo : sourceInfo.getColumns(sourceConfig.isLimitedToFieldsOnLayout())) {
                if (sourceFieldsSet.contains(columnInfo.getName()) || TableConfig.MISSING_COLUMN.getName().equals(columnInfo.getName())) continue;
                @Nullable ColumnInfo matchingDestColumn = destInfo.getColumnWithName(columnInfo.getName(), false).orElse(null);
                if (matchingDestColumn == null && destInfo.isSchemaless()) {
                    matchingDestColumn = this.duplicateSourceColumn(columnInfo);
                }
                if (matchingDestColumn != null && destFieldsSet.contains(matchingDestColumn.getName())) {
                    matchingDestColumn = null;
                }
                MappingRow previousRow = (MappingRow)previousMapping.get(columnInfo.getName());
                if (matchingDestColumn == null && previousRow == null) {
                    if (this.isCreateDatabase()) {
                        log.info("Skipping column " + columnInfo.getName() + " because there is no matching destination column, and we're creating the destination database");
                    } else {
                        mappingRows.add(new MappingRow(config, sourceConfig, destConfig, columnInfo, null, false, false, null, true));
                    }
                } else {
                    boolean locked = lockedSourceFieldSet.contains(columnInfo.getName());
                    if (previousRow != null) {
                        mappingRows.add(previousRow);
                        matchingDestColumn = previousRow.getDestField();
                    } else if (!locked && config.isSchemaMapped() && sourceConfig.getIgnoredFields().contains(columnInfo.getName())) {
                        mappingRows.add(new MappingRow(config, sourceConfig, destConfig, columnInfo, matchingDestColumn, false, false, null, true));
                    } else if (!locked) {
                        mappingRows.add(new MappingRow(config, sourceConfig, destConfig, columnInfo, matchingDestColumn, null, false, null, true));
                    } else {
                        mappingRows.add(new MappingRow(config, sourceConfig, destConfig, columnInfo, matchingDestColumn, true, true, null, true));
                    }
                    if (matchingDestColumn != null) {
                        destFieldsSet.add(matchingDestColumn.getName());
                    }
                }
                sourceFieldsSet.add(columnInfo.getName());
            }
            if (!destInfo.isSchemaless()) {
                for (ColumnInfo columnInfo : destInfo.getColumns(destConfig.isLimitedToFieldsOnLayout())) {
                    if (destFieldsSet.contains(columnInfo.getName())) continue;
                    if (TableConfig.MISSING_COLUMN.getName().equals(columnInfo.getName())) {
                        log.finest("Removing destination missing column from sync");
                        continue;
                    }
                    boolean locked = lockedDestFieldSet.contains(columnInfo.getName());
                    if (locked) {
                        mappingRows.add(new MappingRow(config, sourceConfig, destConfig, null, columnInfo, true, true, null, true));
                        continue;
                    }
                    mappingRows.add(new MappingRow(config, sourceConfig, destConfig, null, columnInfo, false, false, null, true));
                }
            }
            mappingRows.sort(new Comparator<MappingRow>(){

                @Override
                public int compare(MappingRow o1, MappingRow o2) {
                    int result = this.compare(o1.sourceField, o2.sourceField);
                    if (result == 0) {
                        result = this.compare(o1.getDestField(), o2.getDestField());
                    }
                    return result;
                }

                @Override
                private int compare(ColumnInfo c1, ColumnInfo c2) {
                    if (c1 != null && c2 != null) {
                        return c1.getName().compareTo(c2.getName());
                    }
                    if (c1 != null) {
                        return -1;
                    }
                    if (c2 != null) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.mappings.set(whichTable, mappingRows);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private ColumnInfo duplicateSourceColumn(ColumnInfo sourceColumn) {
        ColumnInfo destColumn;
        try {
            destColumn = sourceColumn.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        destColumn.setWriteable(true);
        destColumn.setAutoEnter(AutoEnter.None);
        return destColumn;
    }

    public String generateFileMakerTableSchema(ConfigClientNodes configNodes) throws RemoteException, MirrorSyncException {
        DatabaseProperties sourceProperties = configNodes.isHub() ? null : this.getSource().getDatabaseProperties();
        List<TableConfig> configsToCreate = this.tableMapByName.values().stream().map(pair -> (TableConfig)pair.b).filter(TableConfig::isVirtual).collect(Collectors.toList());
        DatabaseProperties properties = configNodes.getDatabaseProperties();
        try {
            return this.getConfigServer().createTableSQL(properties, sourceProperties, configsToCreate);
        }
        catch (NoSuchDatabaseException e) {
            throw new MirrorSyncException(e);
        }
    }

    public String getDestinationDescriptions() {
        StringBuilder sb = new StringBuilder();
        for (ConfigClientNodes eachDest : this.destinations) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(eachDest.getDatabaseProperties().getDescription());
        }
        return sb.toString();
    }

    public void validateForeignKeys(boolean attemptRepair) throws FeedbackException {
        for (Pair<TableConfig, TableConfig> value : this.tableMapByName.values()) {
            TableConfig hubTableConfig = (TableConfig)value.a;
            Iterator<ForeignKeyInfo> iterator = hubTableConfig.getForeignKeys().iterator();
            while (iterator.hasNext()) {
                ForeignKeyInfo key = iterator.next();
                try {
                    key.validate();
                    if (!hubTableConfig.getDataColumns().stream().noneMatch(col -> col.getName().equals(key.getFromColumn()))) continue;
                    throw new FeedbackException("For table '" + hubTableConfig.getTableName() + "', the relationship to '" + key.getToTable() + "' is not valid, because the foreign key column '" + key.getFromColumn() + "' is not configured to sync.");
                }
                catch (FeedbackException e) {
                    if (attemptRepair) {
                        log.log(Level.WARNING, "Removing foreign key " + key + " because of a validation error: " + e);
                        iterator.remove();
                        continue;
                    }
                    throw e;
                }
            }
            if (hubTableConfig.isUUID() || hubTableConfig.getPrimaryKey2() == null) continue;
            HashSet<String> pkColumnNames = new HashSet<String>(2);
            for (ColumnInfo pk : hubTableConfig.getPrimaryKeys()) {
                pkColumnNames.add(pk.getName());
            }
            for (ForeignKeyInfo foreignKeyInfo : hubTableConfig.getForeignKeys()) {
                pkColumnNames.remove(foreignKeyInfo.getFromColumn());
            }
            if (pkColumnNames.size() <= 0) continue;
            throw new FeedbackException("Table '" + hubTableConfig.getTableName() + "' uses compound primary keys, and is MirrorSync-managed. All portions of the compound key should be defined as foreign keys, but these columns are not: " + pkColumnNames);
        }
    }

    public void validateNewConfigurationName(MirrorConfig config) throws FeedbackException {
        if (StringUtils.isEmpty(config.getName())) {
            throw new FeedbackException("You must provide a configuration name.");
        }
        try {
            for (MirrorConfig serverConfig : this.configServer.getConfigurations()) {
                if (!config.getName().equals(serverConfig.getName()) || config.getId().equals(serverConfig.getId())) continue;
                throw new FeedbackException("There is already a configuration named '" + config.getName() + "', please pick a different one.");
            }
        }
        catch (RemoteException e) {
            throw new FeedbackException("Cannot communicate with MirrorSync server, please quit and restart the configuration client.");
        }
    }

    public boolean isSpokeSchemaNeeded() {
        try {
            return this.configServer.isSpokeSchemaNeeded(this.getCurrentConfig());
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, "Could not get list of columns in spoke database; assuming true for isSpokeSchemaNeeded.", e);
            return true;
        }
    }

    public void cancelEdit() throws RemoteException {
    }

    public ConfigClientNodes getConfigClientNodes(boolean hub) {
        return hub ? this.source : this.getFirstDestination();
    }

    public void updateConfigFromConfigClientNodes() {
        this.getCurrentConfig().setHubDatabaseProperties(this.source.getDatabaseProperties());
        ArrayList<DatabaseProperties> spokeProperties = new ArrayList<DatabaseProperties>(1);
        for (ConfigClientNodes destination : this.destinations) {
            spokeProperties.add(destination.getDatabaseProperties());
        }
        this.getCurrentConfig().setSpokesDatabaseProperties(spokeProperties);
    }

    void refreshTables() {
        log.config("Clearing TableInfo caches");
        this.sourceTables.values().forEach(table -> table.setTableInfo(null));
        this.destinationTables.values().forEach(table -> table.setTableInfo(null));
    }

    public void updateConfiguration(@Nullable Set<String> hubTableNamesToUpdate) throws FeedbackException, RemoteException, NoSuchTableException {
        this.buildTableMap(this.tableMapByName.keySet());
        List<TableConfig> hubConfigsToUpdate = hubTableNamesToUpdate == null ? this.tableMapByName.values().stream().map(pair -> (TableConfig)pair.a).collect(Collectors.toList()) : this.tableMapByName.values().stream().map(pair -> (TableConfig)pair.a).filter(hubConfig -> hubTableNamesToUpdate.contains(hubConfig.getTableName())).collect(Collectors.toList());
        this.validateTableConfiguration(hubConfigsToUpdate);
        HashMap<TableConfig, String> sourceConfigToDestName = new HashMap<TableConfig, String>(this.tableMapByName.size());
        this.tableMapByName.values().forEach(pair -> sourceConfigToDestName.put((TableConfig)pair.a, pair.b == null ? ((TableConfig)pair.a).getTableName() : ((TableConfig)pair.b).getTableName()));
        this.validateTableMapping(sourceConfigToDestName);
        if (hubTableNamesToUpdate == null) {
            this.updateFieldMappings(null);
            this.setAllFieldMappings(null);
        } else {
            int n = 0;
            for (String eachTableName : this.tableMapByName.keySet()) {
                if (hubTableNamesToUpdate.contains(eachTableName)) {
                    this.updateFieldMappings(n);
                    this.setAllFieldMappings(n);
                }
                ++n;
            }
        }
        this.autoDetectForeignKeys(hubTableNamesToUpdate, false);
    }

    public boolean areTableOptionsConfiguredTheSame() {
        boolean didReadFirstTable = false;
        boolean areConfigsIdentical = true;
        TableConfig config1 = null;
        for (Pair<TableConfig, TableConfig> pair : this.tableMapByName.values()) {
            TableConfig tableConfig = (TableConfig)pair.a;
            if (!didReadFirstTable) {
                config1 = tableConfig;
                didReadFirstTable = true;
                continue;
            }
            if (!areConfigsIdentical) continue;
            areConfigsIdentical = tableConfig.getSyncDirection() == config1.getSyncDirection() && tableConfig.getConflictStrategy().equals((Object)config1.getConflictStrategy()) && tableConfig.isUUID() == config1.isUUID() && tableConfig.isAutoMergeEnabled() == config1.isAutoMergeEnabled() && tableConfig.isLimitedToFieldsOnLayout() == config1.isLimitedToFieldsOnLayout();
        }
        return areConfigsIdentical;
    }

    public URL getSyncServerUrlFromSpoke(boolean internal) {
        try {
            return this.getCurrentConfig().getSyncUrl(this.configServer.getContextName(), internal);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetSpecialColumns() {
        this.tableMapByName.forEach((name, pair) -> {
            try {
                TableConfig hubConfig = (TableConfig)pair.a;
                TableConfig spokeConfig = (TableConfig)pair.b;
                boolean limit = hubConfig.isLimitedToFieldsOnLayout();
                TableConfig[] configs = new TableConfig[]{hubConfig, spokeConfig};
                ConfigClientNodes[] nodes = new ConfigClientNodes[]{this.getSource(), this.getFirstDestination()};
                for (int n = 0; n < configs.length; ++n) {
                    TableConfig config = configs[n];
                    TableInfo tableInfo = nodes[n].getTableInfo(config.getTableName());
                    ColumnInfo newValue = this.filterByLayout(tableInfo.getPkColumn1().orElse(null), limit);
                    if (newValue != null) {
                        config.setPrimaryKey1(newValue);
                    }
                    if ((newValue = this.filterByLayout(tableInfo.getPkColumn2().orElse(null), limit)) != null) {
                        config.setPrimaryKey2(newValue);
                    }
                    if ((newValue = this.filterByLayout(tableInfo.getModStampColumn().orElse(null), limit)) != null) {
                        config.setModTimestampColumn(newValue);
                    }
                    if ((newValue = this.filterByLayout(tableInfo.getCreationStampColumn().orElse(null), limit)) != null) {
                        config.setCreationTimestampColumn(newValue);
                    }
                    if ((newValue = this.filterByLayout(tableInfo.getWriteback().orElse(null), limit)) == null) continue;
                    config.setWriteback(newValue);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not reset special columns", e);
            }
        });
    }

    private ColumnInfo filterByLayout(@Nullable ColumnInfo column, boolean limitToFieldsOnLayout) {
        if (column != null && column.isPresentOnLayout() || !limitToFieldsOnLayout) {
            return column;
        }
        return null;
    }

    public void cacheDatabase(DatabaseProperties databaseProperties) throws NoSuchDatabaseException, MirrorSyncException, RemoteException {
        this.getConfigServer().cacheDatabaseForProperties(databaseProperties);
    }

    @Override
    public void close() throws IOException {
        this.configServer.close();
    }
}

