/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.config.client;

import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.MirrorConfig;
import com.prosc.mirror.model.TableConfig;
import com.prosc.shared.StringUtils;
import com.prosc.sync.SyncDirection;
import org.jetbrains.annotations.Nullable;

class MappingRow {
    @Nullable
    final ColumnInfo sourceField;
    private final MirrorConfig mainConfig;
    private final TableConfig hubConfig;
    private final TableConfig destConfig;
    private final ColumnInfo hubField;
    boolean locked;
    String disabledReason;
    String disabledReasonOverride;
    String warningReason;
    String errorReason;
    boolean dataColumn;
    @Nullable
    private ColumnInfo destField;
    Boolean map;

    MappingRow(MirrorConfig mainConfig, TableConfig hubConfig, TableConfig destConfig, @Nullable ColumnInfo hubField, @Nullable ColumnInfo spokeField, Boolean map, boolean locked, String disabledReason, boolean dataColumn) {
        if (locked && !map.booleanValue()) {
            throw new IllegalArgumentException("You cannot have map false but locked true");
        }
        this.mainConfig = mainConfig;
        this.hubConfig = hubConfig;
        this.destConfig = destConfig;
        this.sourceField = hubField;
        this.hubField = hubField;
        this.destField = spokeField;
        this.map = map;
        this.locked = locked;
        this.dataColumn = dataColumn;
        this.disabledReasonOverride = disabledReason;
        this.updateState();
    }

    private void updateState() {
        boolean _dataColumn = this.dataColumn;
        SyncDirection hubSyncDirection = this.mainConfig.getSyncDirectionAdjusted(this.hubConfig, true);
        boolean hubIsWriteable = hubSyncDirection.isWriteable();
        SyncDirection spokeSyncDirection = this.mainConfig.getSyncDirectionAdjusted(this.destConfig, false);
        boolean spokeIsWriteable = spokeSyncDirection.isWriteable();
        if (this.hubConfig.isLimitedToFieldsOnLayout() && this.hubField != null && !this.hubField.isPresentOnLayout() || this.destConfig.isLimitedToFieldsOnLayout() && this.destField != null && !this.destField.isPresentOnLayout()) {
            this.disabledReason = "This table is set to only sync fields on the layout, and this field is not present on the sync layout.";
            this.locked = false;
        } else if (this.disabledReasonOverride != null) {
            this.disabledReason = this.disabledReasonOverride;
        } else if (this.isModifiedByField(this.hubField) || this.isModifiedByField(this.destField)) {
            this.disabledReason = "You should not sync fields that contain the name of who modified the record; that will lead to unnecessary record conflicts.";
        } else if (this.hubField != null && (this.hubField == this.hubConfig.getModTimeColumn() || this.hubField.getAutoEnter() == AutoEnter.ModificationTimestamp) || this.destField != null && (this.destField == this.destConfig.getModTimeColumn() || this.destField.getAutoEnter() == AutoEnter.ModificationTimestamp)) {
            _dataColumn = false;
            this.disabledReason = "You should not sync modification timestamp fields.";
        } else if (this.hubField != null && this.hubField.isGlobal() || this.destField != null && this.destField.isGlobal()) {
            this.disabledReason = "Global fields cannot be synced";
        } else if (this.hubField != null && TableConfig.MISSING_COLUMN.getName().equals(this.hubField.getName())) {
            this.disabledReason = "Hub field has been removed from the database and cannot sync";
        } else if (this.destField != null && TableConfig.MISSING_COLUMN.getName().equals(this.destField.getName())) {
            this.disabledReason = "Spoke field has been removed from the database and cannot sync";
        } else if (this.hubField != null && this.destField != null) {
            boolean spokeFieldIsWriteable = this.destField.isWriteable();
            this.disabledReason = !this.hubField.isWriteable() && !spokeFieldIsWriteable ? "Neither field is writeable. This could be because they are calculation or summary fields. It could also be caused by field-level validation or custom access privileges." : (!hubIsWriteable && !spokeFieldIsWriteable || !spokeIsWriteable && !this.hubField.isWriteable() ? "Destination field is not writeable. This could be because it is a calculation or summary field. It could also be caused by field-level validation or custom access privileges." : (this.locked ? "Special fields, such as foreign keys and writeback fields, cannot be disabled" : null));
        } else {
            this.disabledReason = null;
        }
        this.errorReason = this.hubField != null && this.destField == null && !this.hubField.isNullable() && this.hubField.getDefaultValue() == null && this.hubField.getAutoEnter() == AutoEnter.None && hubIsWriteable ? "Hub field is required. It must be matched up with a spoke field." : (this.destField != null && this.hubField == null && !this.destField.isNullable() && StringUtils.isEmpty(this.destField.getDefaultValue()) && this.destField.getAutoEnter() == AutoEnter.None && spokeIsWriteable ? "Spoke field is required. It must be matched up with a hub field." : null);
        if (this.isModifiedByField(this.hubField) || this.isModifiedByField(this.destField)) {
            this.warningReason = "You should not sync fields that contain the name of who modified the record; that will lead to unnecessary record conflicts.";
            if (this.map == null) {
                this.map = false;
            }
        } else if (this.hubField != null && this.hubField.getAutoEnter() == AutoEnter.Sequential && hubIsWriteable) {
            this.warningReason = "You should not sync serial number fields in a bidirectional sync, unless they are the primary key for the table. Use the writeback feature to write the serial number from the hub to the spoke.";
            if (this.map == null) {
                this.map = false;
            }
        } else if (!this.locked && this.disabledReason == null && this.hubField != null && this.hubField.getAutoEnter() == AutoEnter.ModificationTimestamp) {
            this.warningReason = "You should not sync modification timestamp fields.";
            if (this.map == null) {
                this.map = false;
            }
        } else {
            this.warningReason = hubIsWriteable && this.hubField != null && !this.hubField.isNullable() && this.hubField.getDefaultValue() == null && this.hubField.getAutoEnter() == AutoEnter.None && this.destField != null && this.destField.isNullable() ? (this.mainConfig.isFileMakerHub() && this.destField.isText() ? "" : "Hub field cannot accept null values, but spoke field can be null. This may be OK, but it may cause problems if null values are written to the hub.") : (spokeIsWriteable && this.hubField != null && this.hubField.isNullable() && this.destField != null && !this.destField.isNullable() && this.destField.getDefaultValue() == null && this.destField.getAutoEnter() == AutoEnter.None ? (this.mainConfig.isFileMakerSpoke() && this.destField.isText() ? "" : "Spoke field cannot accept null values, but hub field can be null. This may be OK, but it may cause problems if null values are written to the spoke.") : "");
        }
        if (this.map == null) {
            this.map = true;
        }
        this.dataColumn = _dataColumn;
    }

    @Nullable
    public ColumnInfo getDestField() {
        return this.destField;
    }

    public void setDestField(@Nullable ColumnInfo destField) {
        this.destField = destField;
        this.updateState();
    }

    private boolean isModifiedByField(@Nullable ColumnInfo field) {
        return field != null && (field.getAutoEnter() == AutoEnter.ModificationAccountName || field.getAutoEnter() != AutoEnter.None && (field.getName().toLowerCase().contains("modifiedby") || field.getName().toLowerCase().contains("modified by")));
    }

    public boolean isSync() {
        if (this.locked) {
            return true;
        }
        if (this.disabledReason != null) {
            return false;
        }
        if (this.sourceField == null || this.destField == null) {
            return false;
        }
        return this.map;
    }

    public boolean isDisabled() {
        return this.disabledReason != null;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public String getTooltip() {
        if (this.destField != null && this.destField.isBinary()) {
            return "Containers take longer to sync than non-container data. Ideally, containers should be in their own table with their own modification timestamps.";
        }
        return null;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

