/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.config;

import com.prosc.core.FeedbackException;
import com.prosc.mirror.config.MissingPrimaryKeyException;
import com.prosc.mirror.config.NoSuchTableException;
import com.prosc.mirror.config.client.ConfigClientNodes;
import com.prosc.mirror.config.client.WizardModel;
import com.prosc.mirror.model.AutoEnter;
import com.prosc.mirror.model.ColumnInfo;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.TableInfo;
import com.prosc.shared.StringUtils;
import com.prosc.sync.SyncDirection;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class TableConfigValidator {
    public void validate(WizardModel model, TableConfig sourceConfig, TableConfig destConfig) throws FeedbackException {
        if (sourceConfig.getDataColumns().contains(null)) {
            throw new FeedbackException("Hub contains one or more empty columns. This is a programming bug; please report it to plugins@360works.com: " + sourceConfig.getDataColumns());
        }
        if (sourceConfig.getDataColumnsCount() != destConfig.getDataColumnsCount()) {
            throw new FeedbackException("Hub and spoke have different numbers of columns. This is a programming bug; please report it to plugins@360works.com. Hub: " + sourceConfig.getDataColumns() + "; Spoke: " + destConfig.getDataColumns());
        }
        if (destConfig.getDataColumns().contains(null)) {
            throw new FeedbackException("Spoke node " + destConfig.getTableName() + " contains one or more empty columns. This is a programming bug; please report it to plugins@360works.com: " + destConfig.getDataColumns());
        }
        destConfig.validate();
        this.validateConfig(model.getSource(), sourceConfig);
        for (ConfigClientNodes eachDestination : model.getDestinations()) {
            this.validateConfig(eachDestination, destConfig);
        }
        sourceConfig.validate();
    }

    public void validateConfig(ConfigClientNodes nodesInfo, TableConfig config) throws FeedbackException {
        if (config.isVirtual()) {
            return;
        }
        @Nullable ColumnInfo modTimeColumn = config.getModTimeColumn();
        LinkedList<String> errors = new LinkedList<String>();
        if (nodesInfo.getDatabaseProperties().getType().isConfigureFields()) {
            boolean timestampOptional;
            for (ColumnInfo eachDataColumn : config.getDataColumns()) {
                this.validateColumn(config, eachDataColumn);
            }
            this.validateColumn(config, config.getCreationTimestampColumn());
            this.validateColumn(config, config.getModTimeColumn());
            this.validateColumn(config, config.getPrimaryKey1());
            this.validateColumn(config, config.getPrimaryKey2());
            String nodeName = nodesInfo.getDatabaseProperties().getName();
            if (config.getPrimaryKeys().isEmpty()) {
                errors.add("No primary key is specified for " + config.getTableName() + " in the " + nodeName + " database.");
            }
            if (config.getPrimaryKey1() == null) {
                throw new MissingPrimaryKeyException("No primary key could be auto-detected for table '" + config.getTableName() + "'");
            }
            if (config.getPrimaryKey1().equals(modTimeColumn)) {
                errors.add("Primary key column " + config.getPrimaryKey1().getName() + " for " + config.getTableName() + " is the same as the modification timestamp in the " + nodeName + " database.");
            }
            boolean bl = timestampOptional = !nodesInfo.isHub() && config.getSyncDirection() == SyncDirection.writeOnlyRelaxed;
            if (modTimeColumn == null && !timestampOptional) {
                errors.add("No modification timestamp is specified for " + config.getTableName() + " in the " + nodeName + " database.");
            }
        }
        HashSet<String> allMappedFields = new HashSet<String>();
        for (ColumnInfo column : config.getDataColumns()) {
            allMappedFields.add(column.getName());
        }
        for (ColumnInfo column : config.getPrimaryKeys()) {
            allMappedFields.add(column.getName());
        }
        if (modTimeColumn != null) {
            allMappedFields.add(modTimeColumn.getName());
        }
        try {
            TableInfo tableInfo = nodesInfo.getTableInfo(config.getTableName());
            if (config.isWriteable(nodesInfo.isHub())) {
                for (ColumnInfo column : tableInfo.getColumns(false)) {
                    if (column.isNullable() || column.getAutoEnter() != AutoEnter.None || column.getDefaultValue() != null || column.getName().contains("::") || allMappedFields.contains(column.getName())) continue;
                    errors.add("Column '" + column.getName() + "' in table '" + config.getTableName() + "' is required, but it is not matched up.");
                }
            }
        }
        catch (NoSuchTableException e) {
            errors.add(e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        if (errors.size() > 0) {
            throw new FeedbackException(StringUtils.join("\n", 64000, errors));
        }
    }

    private void validateColumn(TableConfig config, @Nullable ColumnInfo eachDataColumn) throws FeedbackException {
        if (eachDataColumn == null) {
            return;
        }
        if (eachDataColumn.getName().contains("\\")) {
            throw new FeedbackException("Field names cannot contain backslash characters. Invalid field name '" + eachDataColumn.getName() + "' in table '" + config.getTableName() + "'");
        }
    }
}

