/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.io.InputStreamRangeModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InputStreamInfo
implements Closeable {
    private final InputStream stream;
    private final String name;
    private final long length;
    private final String contentType;
    private final boolean closeStream;
    @NotNull
    private Charset charset = StandardCharsets.UTF_8;
    private final File file;
    private String contentEncoding;
    private long lastModified;
    private InputStreamRangeModel rangeModel;

    public InputStreamInfo(File file) throws FileNotFoundException {
        this(file, null);
    }

    public InputStreamInfo(File file, @Nullable String optionalContentType) throws FileNotFoundException {
        this(file.isDirectory() ? null : new FileInputStream(file), file, file.getName(), file.length(), optionalContentType);
        this.lastModified = file.lastModified();
    }

    public InputStreamInfo(InputStream stream, String name, long length) {
        this(stream, name, length, null);
    }

    public InputStreamInfo(InputStream stream, String name, long length, @Nullable String optionalContentType) {
        this(stream, null, name, length, optionalContentType);
    }

    private InputStreamInfo(InputStream stream, @Nullable File file, String name, long length, @Nullable String optionalContentType) {
        this.stream = stream;
        this.name = name;
        this.length = length;
        this.contentType = optionalContentType;
        this.closeStream = file != null;
        this.file = file;
        this.lastModified = -1L;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public Reader getReader() {
        return new InputStreamReader(this.stream, this.charset);
    }

    public String getName() {
        return this.name;
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getFile() {
        return this.file;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            this.stream.close();
        }
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @NotNull
    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(@NotNull Charset charset) {
        this.charset = charset;
    }

    public InputStreamRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(InputStreamRangeModel rangeModel) {
        this.rangeModel = rangeModel;
    }
}

