/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.infrastructure.ClassUtils;
import com.prosc.infrastructure.SimpleFormatterThreadsafe;
import com.prosc.io.IOUtils;
import com.prosc.shared.ReflectionUtils;
import com.prosc.shared.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogUtils {
    private static final Logger log = Logger.getLogger(LogUtils.class.getName());
    private static String externalIpAddress;
    private static final Map<String, File> tempLogFiles;
    private static Map<String, Level> localizedLabelToLevel;

    public static void main(String[] args) {
        Level warning = LogUtils.localizedStringToLogLevel("MAIS DETALHADO").orElse(null);
        System.out.println(warning);
    }

    public static boolean isFileLoggingEnabled() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            return true;
        }
        return false;
    }

    public static void enableThreadsafeLogging() {
        LogManager manager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(manager.getLoggerNames());
        for (String loggerName : loggerNames) {
            for (Handler handler : manager.getLogger(loggerName).getHandlers()) {
                if (!(handler.getFormatter() instanceof SimpleFormatter)) continue;
                handler.setFormatter(new SimpleFormatterThreadsafe());
            }
        }
    }

    public static void flush(@NotNull Logger whichLog) {
        Logger currentLog = whichLog;
        do {
            for (Handler handler : currentLog.getHandlers()) {
                handler.flush();
            }
        } while ((currentLog = currentLog.getParent()) != null);
    }

    public static File enableTempLogging(String filename) throws IOException {
        File logDest;
        File logFolder;
        if (tempLogFiles.containsKey(filename)) {
            return tempLogFiles.get(filename);
        }
        File file = logFolder = Platform.current.unixLike ? new File("/tmp") : new File("C:\\Windows\\Temp");
        if (!logFolder.exists() || !logFolder.canWrite()) {
            logFolder = IOUtils.findWriteableTempDirectory();
        }
        if ((logDest = new File(logFolder, filename)).exists() && (logDest.isDirectory() || !logDest.canWrite())) {
            logDest = IOUtils.ensureUniqueFilename(logDest);
        }
        try {
            FileHandler handler = new FileHandler(logDest.getAbsolutePath());
            handler.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(handler);
            tempLogFiles.put(filename, logDest);
            log.info("Temporary logging enabled to file " + logDest.getAbsolutePath());
            return logDest;
        }
        catch (IOException e) {
            throw new IOException("Could not enable temp logging because a new FileHandler could not be created", e);
        }
    }

    public static File locateLogFile() throws FileNotFoundException {
        return LogUtils.locateLogFile(null);
    }

    public static File locateLogFile(@Nullable Date requestedDate) throws FileNotFoundException {
        List<File> matchingLogFiles = LogUtils.locateLogFiles();
        return LogUtils.getFile(requestedDate, matchingLogFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> locateLogFiles() {
        ArrayList<File> result = new ArrayList<File>();
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        Handler whichHandler = null;
        try {
            Handler[] handlerArray = handlers;
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                Handler handler;
                whichHandler = handler = handlerArray[i];
                try {
                    Class<?> handlerClass = handler.getClass();
                    if (handler instanceof ConsoleHandler) continue;
                    if (handler instanceof FileHandler) {
                        File[] files;
                        Field filesField = handlerClass.getDeclaredField("files");
                        Field patternField = handlerClass.getDeclaredField("pattern");
                        filesField.setAccessible(true);
                        patternField.setAccessible(true);
                        String pattern = (String)patternField.get(handler);
                        for (File file : files = (File[])filesField.get(handler)) {
                            if (!file.getAbsolutePath().startsWith(pattern)) continue;
                            result.add(file);
                        }
                        break;
                    }
                    String directory = (String)ReflectionUtils.getFieldValue(handler, "directory");
                    final String logPrefix = (String)ReflectionUtils.getFieldValue(handler, "prefix");
                    File logDirectory = new File(directory);
                    if (!logDirectory.exists() || !logDirectory.isDirectory()) {
                        log.log(Level.WARNING, "Log directory " + directory + " does not exist, or is not a directory");
                        continue;
                    }
                    File[] logFiles = logDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().startsWith(logPrefix);
                        }
                    });
                    if (logFiles == null || logFiles.length == 0) continue;
                    result.addAll(Arrays.asList(logFiles));
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, "Couldn't get log file", e);
        }
        finally {
            if (whichHandler != null) {
                whichHandler.flush();
            }
        }
        return result;
    }

    public static File getFile(Date requestedDate, List<File> logFiles) throws FileNotFoundException {
        logFiles.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        if (requestedDate == null) {
            return logFiles.get(logFiles.size() - 1);
        }
        if (logFiles.size() == 0) {
            throw new FileNotFoundException("Cannot locate any log file");
        }
        File result = logFiles.get(0);
        Iterator<File> iterator = logFiles.iterator();
        while (iterator.hasNext()) {
            File logFile;
            result = logFile = iterator.next();
            if (logFile.lastModified() < requestedDate.getTime()) continue;
            break;
        }
        return result;
    }

    public static String getSystemInfo() {
        return LogUtils.getSystemInfo(false, false, false);
    }

    public static String getSystemInfo(boolean lookupIpAddress) {
        return LogUtils.getSystemInfo(lookupIpAddress, false, false);
    }

    public static String getSystemInfo(boolean lookupIpAddress, boolean dumpSystemProperties, boolean dumpEnvironmentVariables) {
        String catalinaHome = System.getenv("CATALINA_HOME");
        String catalinaBase = System.getenv("CATALINA_BASE");
        try {
            catalinaHome = new File(catalinaHome).getCanonicalPath();
            catalinaBase = new File(catalinaBase).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        URL classUrl = LogUtils.class.getResource("LogUtils.class");
        String localhostHostname = "<Unknown>";
        String localhostIp = "<Unknown>";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            localhostIp = inetAddress.getHostAddress();
            localhostHostname = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Couldn't get local host", e);
        }
        String externalIp = lookupIpAddress ? LogUtils.getExternalAddress(false) : "<Lookup disabled>";
        TimeZone defaultTimeZone = TimeZone.getDefault();
        String result = "java.version: " + System.getProperty("java.version") + " / jvm version: " + System.getProperty("java.vm.version") + " / JAVA_JVM_VERSION is " + System.getenv("JAVA_JVM_VERSION") + StringUtils.CR + "java.home: " + System.getProperty("java.home") + StringUtils.CR + "JVM name: " + System.getProperty("java.vm.name") + StringUtils.CR + "Tomcat home directory: " + catalinaHome + "; Tomcat base directory: " + catalinaBase + StringUtils.CR + "LogUtils class location: " + classUrl + StringUtils.CR + "Operating system info: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " running on " + System.getProperty("os.arch") + " architecture (" + System.getProperty("sun.arch.data.model") + " bit)" + StringUtils.CR + "Temp directory: " + tmpDir.getAbsolutePath() + "; exists is " + tmpDir.exists() + "; writeable is " + tmpDir.canWrite() + StringUtils.CR + "Working directory: " + System.getProperty("user.dir") + StringUtils.CR + "Local hostname: " + localhostHostname + " / local IP address: " + localhostIp + " / external IP address: " + externalIp + StringUtils.CR + "Process name/ID: " + ManagementFactory.getRuntimeMXBean().getName() + StringUtils.CR + "User name is " + System.getProperty("user.name") + " and home directory is " + System.getProperty("user.home") + "; writeable is " + new File(System.getProperty("user.home")).canWrite() + StringUtils.CR + "Locale is " + Locale.getDefault().getDisplayName(Locale.US) + " / File encoding: " + System.getProperty("file.encoding") + " / time zone is " + defaultTimeZone.getID() + " / " + defaultTimeZone.getDisplayName(true, 1, Locale.US) + "(GMT offset " + defaultTimeZone.getOffset(System.currentTimeMillis()) + " milliseconds )" + StringUtils.CR + "Current local time is " + new Date() + StringUtils.CR + "Available processors: " + Runtime.getRuntime().availableProcessors() + StringUtils.CR + LogUtils.getMemoryInfo();
        result = result + StringUtils.CR + StringUtils.CR + "Launch arguments:";
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        for (String string : runtimeMxBean.getInputArguments()) {
            result = result + StringUtils.CR + string;
        }
        if (dumpEnvironmentVariables) {
            result = result + StringUtils.CR + StringUtils.CR + "Environment variables:";
            for (Map.Entry entry : System.getenv().entrySet()) {
                result = result + StringUtils.CR + (String)entry.getKey() + ": " + (String)entry.getValue();
            }
        }
        if (dumpSystemProperties) {
            result = result + StringUtils.CR + StringUtils.CR + "System properties: ";
            for (Map.Entry entry : System.getProperties().entrySet()) {
                result = result + StringUtils.CR + entry.getKey() + ": " + entry.getValue();
            }
        }
        return result;
    }

    public static String getExternalAddress(boolean forceRefresh) {
        if (externalIpAddress == null || forceRefresh) {
            try {
                URLConnection connection = new URL("https://networkcheck.360works.com/EchoServer/info").openConnection();
                connection.setConnectTimeout(10000);
                externalIpAddress = IOUtils.urlConnectionAsString(connection).split("\n")[1];
            }
            catch (IOException e) {
                externalIpAddress = "<unknown>";
            }
        }
        return externalIpAddress;
    }

    public static String getMemoryInfo() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Runtime runtime = Runtime.getRuntime();
        long maxMem = runtime.maxMemory();
        long freeMem = runtime.freeMemory();
        long totalMem = runtime.totalMemory();
        long availableMem = maxMem - totalMem + freeMem;
        return "Max heap size is " + numberFormat.format(maxMem) + "; free memory is " + numberFormat.format(freeMem) + "; total memory is " + numberFormat.format(totalMem) + "; available memory is " + numberFormat.format(availableMem);
    }

    public static String dumpThreadStackTrace() {
        ThreadMXBean threadMX = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMX.dumpAllThreads(false, false);
        NumberFormat numberFormat = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("isThreadContentionMonitoringSupported: " + threadMX.isThreadContentionMonitoringSupported() + " / isThreadContentionMonitoringEnabled: " + threadMX.isThreadContentionMonitoringEnabled() + "\n");
        String delim = "";
        for (ThreadInfo info : threadInfos) {
            sb.append(delim).append("ID: ").append(info.getThreadId()).append(" / state: ").append(info.getThreadState().name()).append(" / name: ").append(info.getThreadName()).append(StringUtils.CR);
            if (threadMX.isThreadContentionMonitoringSupported() && threadMX.isThreadContentionMonitoringEnabled()) {
                sb.append("Milliseconds spent waiting: " + numberFormat.format(info.getWaitedTime()) + " / blocked: " + numberFormat.format(info.getBlockedTime())).append(StringUtils.CR);
            }
            if (info.getThreadState() == Thread.State.BLOCKED) {
                sb.append("Currently waiting for lock " + info.getLockName() + " owned by " + info.getLockOwnerName() + " / thread ID " + info.getLockOwnerId() + "\n");
            }
            for (StackTraceElement traceElement : info.getStackTrace()) {
                sb.append("    " + traceElement.toString() + StringUtils.CR);
            }
            delim = StringUtils.CR;
        }
        return sb.toString();
    }

    public static Optional<Level> localizedStringToLogLevel(String logLevelString) {
        if (localizedLabelToLevel == null) {
            try {
                localizedLabelToLevel = new HashMap<String, Level>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(ClassUtils.getResourceAsStream(LogUtils.class, "LevelNames.txt").orElseThrow(() -> new IOException("LevelNames.txt missing from classloader")), StandardCharsets.UTF_8));){
                    reader.lines().filter(line -> !line.startsWith("#") && !line.trim().isEmpty()).forEach(line -> {
                        String[] split = line.split("=");
                        localizedLabelToLevel.put(split[0].trim(), Level.parse(split[1].trim()));
                    });
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not build international localized list of level names", e);
                try {
                    return Optional.of(Level.parse(logLevelString));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Optional.of(Level.INFO);
                }
            }
        }
        return Optional.ofNullable(localizedLabelToLevel.get(logLevelString));
    }

    public static Logger getRootLogger(Logger log) {
        while (log.getParent() != null && log.getParent() != log) {
            log = log.getParent();
        }
        return log;
    }

    static {
        tempLogFiles = new HashMap<String, File>(1);
        localizedLabelToLevel = null;
    }
}

