/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.infrastructure.IEProcessLaunchException;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LaunchBrowser {
    private static final Logger log = Logger.getLogger(LaunchBrowser.class.getName());
    private static final Pattern WIN_ESCAPE_PATTERN_WITHOUT_SPACES_COMMAS = Pattern.compile("[&()^;]");
    private static final Pattern WIN_ESCAPE_PATTERN = Pattern.compile("([&^();, ])");
    private boolean runInBackground;

    public LaunchBrowser() {
        this(false);
    }

    public LaunchBrowser(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public int launch(String path) throws IEProcessLaunchException {
        log.info("Opening URL: " + path);
        try {
            if (Desktop.isDesktopSupported() && path.startsWith("http")) {
                Desktop.getDesktop().browse(new URI(path));
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Could not browse to " + path + ", using command-line instead", e);
        }
        String[] cmd = Platform.isWin() ? new String[]{"cmd.exe", "/C", "start", path} : new String[]{"/usr/bin/open", path};
        return this.runCommand(cmd);
    }

    private int runCommand(String[] cmd) throws IEProcessLaunchException {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            if (!this.runInBackground) {
                process.waitFor();
                int result = process.exitValue();
                if (result != 0) {
                    if ((result == 1 || result == -1) && Platform.isWin()) {
                        log.log(Level.WARNING, "URL launch failed with error code " + result + ", using args " + Arrays.asList(cmd));
                    } else {
                        throw new IEProcessLaunchException("URL launch failed with error code " + result + ", using args: " + Arrays.asList(cmd));
                    }
                }
                return result;
            }
            return 0;
        }
        catch (IOException e) {
            if (e.getMessage().contains("error=5")) {
                throw new IEProcessLaunchException("Error launching file: IE is using Protected Mode, turn OFF, or add page to trusted sites. Check Tools-->Internet Options-->Security.");
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int launch(File localFile) throws IEProcessLaunchException {
        log.info(Platform.isWin() ? "Opening Windows path: " + localFile.getAbsolutePath() : "Opening path: " + localFile.getAbsolutePath());
        if (Platform.isWin()) {
            String[] cmd = localFile.isDirectory() ? new String[]{"explorer.exe", localFile.getAbsolutePath()} : new String[]{"cmd.exe", "/C", this._escapeCharsForWindowsPath(localFile.getAbsolutePath())};
            log.log(Level.INFO, Arrays.asList(cmd).toString());
            return this.runCommand(cmd);
        }
        return this.launch(localFile.getAbsolutePath());
    }

    private String _escapeCharsForWindowsPath(String path) {
        log.info("Escaping path: " + path);
        Matcher matcher = WIN_ESCAPE_PATTERN_WITHOUT_SPACES_COMMAS.matcher(path);
        if (matcher.find()) {
            path = WIN_ESCAPE_PATTERN.matcher(path).replaceAll("^$1");
        }
        log.info("Escaped result: " + path);
        return path;
    }

    static void main(String[] args) {
        String path = "C:\\DOCUME~1\\val\\LOCALS~1\\Temp\\supercontainer_downloads\\test\\Prichard, Nathan - Activation&HTE().PDF";
        LaunchBrowser lb = new LaunchBrowser();
        String result = lb._escapeCharsForWindowsPath(path);
        log.info(result);
    }

    public int launch(URL url) throws IEProcessLaunchException {
        return this.launch(url.toExternalForm());
    }
}

