/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.AbstractInstaller;
import com.prosc.infrastructure.IEProcessLaunchException;
import com.prosc.infrastructure.LaunchBrowser;
import com.prosc.shared.ExceptionUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class InstallerGUI {
    private static final Logger log = Logger.getLogger(InstallerGUI.class.getName());
    private AbstractInstaller installer;

    public InstallerGUI(AbstractInstaller installer) {
        this.installer = installer;
    }

    public void run() throws Exception {
        this.installer.checkConfiguration();
        final JButton cancelButton = new JButton("Cancel");
        JButton removeButton = new JButton("Remove");
        removeButton.setVisible(this.installer.canRemove());
        final JButton installButton = new JButton(this.installer.isInstalled() ? "Upgrade" : "Install");
        final JPanel installPanel = new JPanel(new BorderLayout());
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        new LaunchBrowser().launch(e.getURL());
                    }
                    catch (IEProcessLaunchException e1) {
                        ExceptionUtils.reportAndLogException(Level.WARNING, installPanel, "", e1);
                    }
                }
            }
        };
        String instructions = this.installer.getInstallInstructions();
        JEditorPane instructionsLabel = new JEditorPane("text/html", instructions);
        instructionsLabel.setEditable(false);
        instructionsLabel.setOpaque(false);
        instructionsLabel.addHyperlinkListener(listener);
        this.applyFontRuleToEditorPane(instructionsLabel);
        JLabel versionInfo = null;
        if (this.installer.getVersionInfo() != null) {
            versionInfo = new JLabel(this.installer.getVersionInfo());
        }
        final JEditorPane finishedPane = new JEditorPane("text/html", null);
        finishedPane.setEditable(false);
        finishedPane.setOpaque(false);
        finishedPane.addHyperlinkListener(listener);
        this.applyFontRuleToEditorPane(finishedPane);
        final JButton finishButton = new JButton("Finish");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(cancelButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(installButton);
        if (versionInfo != null) {
            JPanel versionPanel = new JPanel(new FlowLayout(2));
            versionPanel.add(versionInfo);
            installPanel.add((Component)versionPanel, "North");
        }
        installPanel.add((Component)instructionsLabel, "Center");
        installPanel.add((Component)buttonPanel, "South");
        installPanel.setPreferredSize(new Dimension(570, 340));
        installPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel finishedPanel = new JPanel(new BorderLayout());
        finishedPanel.add((Component)finishedPane, "Center");
        buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(finishButton);
        finishedPanel.add((Component)buttonPanel, "South");
        final JFrame frame = new JFrame(this.installer.getProductTitle() + " Installer");
        if (Platform.isWin()) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
        }
        frame.setDefaultCloseOperation(3);
        final CardLayout cardLayout = new CardLayout(10, 20);
        frame.getContentPane().setLayout(cardLayout);
        frame.getContentPane().add((Component)installPanel, "one");
        frame.getContentPane().add((Component)finishedPanel, "two");
        frame.getRootPane().setDefaultButton(installButton);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        ActionListener installAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String finishedMessage;
                    if (e.getSource() == installButton) {
                        InstallerGUI.this.installer.runInstaller();
                        finishedMessage = InstallerGUI.this.installer.getSuccessMessage();
                    } else {
                        InstallerGUI.this.installer.runUninstaller();
                        finishedMessage = InstallerGUI.this.installer.getUninstallMessage();
                    }
                    finishedPane.setText(finishedMessage);
                    cardLayout.next(frame.getContentPane());
                    frame.getRootPane().setDefaultButton(finishButton);
                }
                catch (UserCanceledException finishedMessage) {
                }
                catch (RuntimeException e1) {
                    log.log(Level.SEVERE, "Installation failed: " + e1, e1);
                    JOptionPane.showMessageDialog(null, e1.toString());
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Installation failed: " + e1, e1);
                    JOptionPane.showMessageDialog(null, e1.getMessage());
                }
            }
        };
        installButton.addActionListener(installAction);
        removeButton.addActionListener(installAction);
        ActionListener closeFrame = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
                if (e.getSource() == cancelButton) {
                    System.exit(-1);
                } else {
                    System.exit(0);
                }
            }
        };
        cancelButton.addActionListener(closeFrame);
        finishButton.addActionListener(closeFrame);
    }

    private void applyFontRuleToEditorPane(JEditorPane editorPane) {
        Font font = editorPane.getFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        if (editorPane.getDocument() instanceof HTMLDocument) {
            ((HTMLDocument)editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        }
    }
}

