/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.FileMakerConfigurationException;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.io.ProcessUtils;
import com.prosc.windows.NoSuchRegistryEntryException;
import com.prosc.windows.WindowsRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileMakerInstallerUtils {
    private static final Logger log = Logger.getLogger(FileMakerInstallerUtils.class.getName());
    private File fmServerHome;
    private File wpeHome;
    private File webApps;
    private int version;
    private File jkConfigFile;
    private static final String CR = System.getProperty("line.separator");
    private File tomcatDir;

    public int getVersion() {
        return this.version;
    }

    public final File getFmServerHome() throws FileMakerConfigurationException {
        if (this.fmServerHome == null) {
            File programsDir;
            if (!Platform.isMac()) {
                try {
                    String fmServerPath;
                    try {
                        fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\14.0\\Services", "InstallLocation");
                    }
                    catch (NoSuchRegistryEntryException e14) {
                        try {
                            fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\13.0\\Services", "InstallLocation");
                        }
                        catch (NoSuchRegistryEntryException e13) {
                            try {
                                fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\12.0\\Services", "InstallLocation");
                            }
                            catch (NoSuchRegistryEntryException e12) {
                                try {
                                    fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\11.0\\Services", "InstallLocation");
                                }
                                catch (NoSuchRegistryEntryException e11) {
                                    try {
                                        fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\10.0\\Services", "InstallLocation");
                                    }
                                    catch (NoSuchRegistryEntryException e10) {
                                        try {
                                            fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\9.0\\Services", "InstallLocation");
                                        }
                                        catch (NoSuchRegistryEntryException e9) {
                                            fmServerPath = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\8.0\\Services", "InstallLocation");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    File candidate = new File(fmServerPath);
                    if (candidate.exists() && candidate.isDirectory()) {
                        this.fmServerHome = candidate;
                        return this.fmServerHome;
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not determine FileMaker Server location from registry; will check standard locations");
                }
            }
            if (Platform.isMac()) {
                programsDir = new File("/Library");
            } else {
                String PROGRAM_FILES_DRIVE_AND_FOLDER = System.getenv("PROGRAMFILES");
                String PROGRAM_FILES_DRIVE_AND_FOLDER_64BIT = System.getenv("PROGRAMFILES(X86)");
                if (PROGRAM_FILES_DRIVE_AND_FOLDER_64BIT != null && new File(PROGRAM_FILES_DRIVE_AND_FOLDER_64BIT).exists()) {
                    PROGRAM_FILES_DRIVE_AND_FOLDER = PROGRAM_FILES_DRIVE_AND_FOLDER_64BIT;
                }
                File programsBaseDir = new File(PROGRAM_FILES_DRIVE_AND_FOLDER);
                programsDir = new File(programsBaseDir, "FileMaker");
            }
            File fmCandidate = new File(programsDir, "FileMaker Server");
            if (fmCandidate.exists()) {
                this.version = 8;
                this.fmServerHome = fmCandidate;
            } else {
                fmCandidate = new File(programsDir, "FileMaker Server 7");
                if (!fmCandidate.exists()) {
                    throw new FileMakerConfigurationException("FileMaker Server is not installed on this computer, or cannot be found");
                }
                this.version = 7;
                this.fmServerHome = fmCandidate;
            }
        }
        return this.fmServerHome;
    }

    public final File getWpeHome() throws FileMakerConfigurationException {
        if (this.wpeHome == null) {
            File fmServerHome = this.getFmServerHome();
            File webCandidate = new File(fmServerHome, "Web Publishing");
            if (!webCandidate.exists()) {
                throw new FileMakerConfigurationException("The Web Publishing Engine is not installed; there is no web publishing directory at " + webCandidate.getAbsolutePath());
            }
            this.wpeHome = webCandidate;
            this.tomcatDir = new File(this.wpeHome, "publishing-engine/jwpc-tomcat");
            if (this.tomcatDir.exists()) {
                this.version = 12;
                this.webApps = this.tomcatDir;
            } else {
                this.tomcatDir = new File(this.wpeHome, "publishing-engine/cwpe-tomcat");
                if (this.tomcatDir.exists()) {
                    this.version = 9;
                    this.webApps = new File(this.tomcatDir, "bin");
                } else {
                    this.tomcatDir = new File(this.wpeHome, "jakarta-tomcat");
                    if (this.tomcatDir.exists()) {
                        this.webApps = new File(this.tomcatDir, "webapps");
                    } else {
                        throw new FileMakerConfigurationException("The Web Publishing Engine is installed, but damaged. There is no tomcat directory at " + this.tomcatDir.getAbsolutePath());
                    }
                }
            }
        }
        return this.wpeHome;
    }

    public File getTomcatDir() {
        return this.tomcatDir;
    }

    public final File getJKFile() throws FileMakerConfigurationException {
        if (this.jkConfigFile == null) {
            File wpeHome = this.getWpeHome();
            File adminWebFolder = this.version >= 9 ? new File(this.fmServerHome, "Admin/admin-helper/WEB-INF/conf") : new File(wpeHome, "web-configuration/WEB-INF/conf");
            File jkCandidate = Platform.isMac() ? (this.version >= 12 ? new File(adminWebFolder, "mod_proxy.conf") : (this.version >= 9 ? new File(adminWebFolder, "mod_jk.conf") : new File(adminWebFolder, "mod_jk_paths.conf"))) : new File(adminWebFolder, "uriworkermap.properties");
            if (!jkCandidate.exists()) {
                throw new FileMakerConfigurationException("Web Publishing is not deployed and not integrated with webserver.\n\nIf you're using FMS 9, please run the Deployment Assistant. Could not locate JK mount config file at " + jkCandidate.getAbsolutePath());
            }
            this.jkConfigFile = jkCandidate;
        }
        return this.jkConfigFile;
    }

    public final File getWebApps() throws FileMakerConfigurationException {
        this.getWpeHome();
        return this.webApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeJKMounts(List<String> mountPoints, boolean add) throws FileMakerConfigurationException, IOException {
        List<String> remainingMounts;
        block24: {
            if (add && (mountPoints = this.checkExistingMounts(mountPoints)).isEmpty()) {
                log.log(Level.INFO, "Already mounted from a previous installation");
                return;
            }
            File jkFile = this.getJKFile();
            File backupFile = IOUtils.ensureUniqueFilename(new File(jkFile.getParentFile(), jkFile.getName() + ".bak"));
            IOUtils.copyFile(jkFile, backupFile);
            String jkSettings = IOUtils.fileAsString(jkFile);
            if (add) {
                String whichWorker;
                String string = whichWorker = this.version >= 12 ? "jwpc" : "cwpe";
                if (Platform.isMac()) {
                    if (jkFile.getName().equals("mod_proxy.conf")) {
                        for (String string2 : mountPoints) {
                            jkSettings = jkSettings + CR + "ProxyPass /" + string2 + " ajp://127.0.0.1:16021/" + string2;
                            jkSettings = jkSettings + CR + "ProxyPassReverse /" + string2 + " ajp://127.0.0.1:16021/" + string2;
                        }
                    } else {
                        String mountCommand = this.version < 9 ? "JKFmMount" : "JkFmMount";
                        for (String mountPoint : mountPoints) {
                            jkSettings = jkSettings + CR + (String)mountCommand + " /" + mountPoint + " " + whichWorker;
                            jkSettings = jkSettings + CR + (String)mountCommand + " /" + mountPoint + "/* " + whichWorker;
                        }
                    }
                } else {
                    for (String string3 : mountPoints) {
                        jkSettings = jkSettings + CR + "/" + string3 + "=" + whichWorker;
                        jkSettings = jkSettings + CR + "/" + string3 + "/*=" + whichWorker;
                    }
                }
            } else {
                String string;
                StringBuilder newContents = new StringBuilder(jkSettings.length());
                BufferedReader br = new BufferedReader(new StringReader(jkSettings));
                while ((string = br.readLine()) != null) {
                    boolean includeLine = true;
                    for (String mountPoint : mountPoints) {
                        if (!string.contains(mountPoint)) continue;
                        includeLine = false;
                        break;
                    }
                    if (!includeLine) continue;
                    if (newContents.length() > 0) {
                        newContents.append(CR);
                    }
                    newContents.append(string);
                }
                jkSettings = newContents.toString();
            }
            if (Platform.isMac()) {
                log.log(Level.INFO, "using authopen command.");
                String[] cmds = new String[]{"/usr/libexec/authopen", "-w", jkFile.getAbsolutePath()};
                Process process = Runtime.getRuntime().exec(cmds);
                try (OutputStream outputStream = process.getOutputStream();){
                    outputStream.write(jkSettings.getBytes(StandardCharsets.UTF_8));
                }
                try {
                    int result = process.waitFor();
                    if (result != 0) {
                        String errorMessage = IOUtils.inputStreamAsString(process.getErrorStream());
                        throw new IOException("Could not write to configuration file at " + jkFile.getAbsolutePath() + ": " + errorMessage);
                    }
                    break block24;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Process was interrupted while writing to JkConfiguration file");
                }
            }
            if (!jkFile.delete()) throw new RuntimeException("Could not delete the JK file at " + jkFile.getAbsolutePath());
            if (!jkFile.createNewFile()) throw new RuntimeException("Could not create new JK file at " + jkFile.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(jkFile);
            ByteArrayInputStream in = new ByteArrayInputStream(jkSettings.getBytes(StandardCharsets.UTF_8));
            try {
                IOUtils.writeInputToOutput((InputStream)in, (OutputStream)out, 8192);
            }
            finally {
                in.close();
                out.close();
            }
        }
        if (!add || (remainingMounts = this.checkExistingMounts(mountPoints)).isEmpty()) return;
        throw new RuntimeException("An error occurred; these mount points were not written: " + remainingMounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> checkExistingMounts(List<String> mountPoints) throws FileMakerConfigurationException, IOException {
        ArrayList<String> result = new ArrayList<String>(mountPoints);
        try (BufferedReader br = new BufferedReader(new FileReader(this.getJKFile()));){
            String eachLine;
            while ((eachLine = br.readLine()) != null && result.size() > 0) {
                ListIterator it = result.listIterator();
                while (it.hasNext()) {
                    if (!eachLine.contains((CharSequence)it.next())) continue;
                    it.remove();
                }
            }
        }
        return result;
    }

    public final void copyDirectory(File srcDir, File dest) throws IOException {
        try {
            IOUtils.copyDirectory(srcDir, dest);
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().contains("Access is denied")) {
                throw new IOException("Can't write to the installation directory, please make sure you are logged in with an administrative account.", e);
            }
            throw e;
        }
    }

    public void restartWebServer() throws IOException {
        try {
            if (Platform.isMac()) {
                String[] cmds = new String[]{"apachectl", "graceful"};
                ProcessUtils.doShellCommand(cmds, null, null);
            } else {
                String[] cmds = new String[]{"IISReset"};
                ProcessUtils.doShellCommand(cmds, null, null);
            }
        }
        catch (ProcessExecutionException e) {
            throw new IOException("Could not restart web server: " + e.toString(), e);
        }
        catch (UserCanceledException e) {
            throw new IOException("Process was interrupted while waiting for web server to restart.", e);
        }
    }
}

