/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.AbstractInstaller;
import com.prosc.infrastructure.FileMakerConfigurationException;
import com.prosc.infrastructure.FileMakerInstallerUtils;
import com.prosc.io.IOUtils;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class DefaultInstaller
extends AbstractInstaller {
    private static final Logger log = Logger.getLogger(DefaultInstaller.class.getName());
    private static final FileMakerInstallerUtils utils = new FileMakerInstallerUtils();
    private final String installInstructions = IOUtils.urlConnectionAsString(this.installUrl().openConnection());
    private final String successMessage = IOUtils.urlConnectionAsString(this.successUrl().openConnection());
    private final String uninstallMessage = IOUtils.urlConnectionAsString(this.uninstallUrl().openConnection());
    private final List<String> mountPoints = new LinkedList<String>();
    private final File installationWarFile;
    private boolean restartFailed;
    private boolean finished;
    private Exception workerException;

    public DefaultInstaller() throws IOException {
        this.mountPoints.add(this.getServletName());
        log.info("Mount points: " + this.mountPoints);
        this.installationWarFile = new File(this.getServletName() + ".war");
    }

    private URL installUrl() {
        return this.installationUrl();
    }

    private URL uninstallUrl() {
        return this.getClass().getResource("UninstallMessage.html");
    }

    private URL successUrl() {
        return this.getClass().getResource("SuccessMessage.html");
    }

    private URL installationUrl() {
        return this.getClass().getResource("InstallInstructions.html");
    }

    protected void addMountPoint(String mountPoint) {
        this.mountPoints.add(mountPoint);
    }

    protected abstract String getServletName();

    @Override
    public void checkConfiguration() throws Exception {
        utils.getJKFile();
    }

    @Override
    public boolean isInstalled() throws FileMakerConfigurationException, IOException {
        return new File(utils.getWebApps(), this.getServletName()).exists() || utils.checkExistingMounts(this.mountPoints).isEmpty();
    }

    @Override
    public String getInstallInstructions() {
        return this.installInstructions;
    }

    @Override
    public String getSuccessMessage() {
        return this.successMessage;
    }

    @Override
    public String getUninstallMessage() {
        return this.uninstallMessage;
    }

    public File getInstallationWarFile() {
        return this.installationWarFile;
    }

    @Override
    public final void runInstaller() throws FileMakerConfigurationException, IOException, UserCanceledException {
        this.preInstallUI();
        this.installNoUI();
        this.postInstallUI();
    }

    protected void preInstallUI() throws FileMakerConfigurationException, IOException, UserCanceledException {
        block8: {
            if (Platform.isMac()) {
                if (!new File("/System").canWrite()) {
                    throw new FileMakerConfigurationException("You must run this application using the Mac installer application, not by double-clicking on the installer.jar file");
                }
            } else if (Platform.isWin()) {
                if (!new File("/Windows").canWrite()) {
                    throw new FileMakerConfigurationException("You must run this application using the Windows installer application, not by double-clicking on the installer.jar file");
                }
            } else {
                throw new FileMakerConfigurationException("The installer does not support this platform: " + (Object)((Object)Platform.current));
            }
            try {
                new URL("http://127.0.0.1").openStream().close();
            }
            catch (IOException e) {
                String message = "<html>There is no Web Server running on this computer. Verify that a Web Server is installed and running by testing the URL http://127.0.0.1. <br>MirrorSync will not be able to work correctly until this is fixed. Would you like to proceed with installation anyway?</html>";
                int choice = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "<html>There is no Web Server running on this computer. Verify that a Web Server is installed and running by testing the URL http://127.0.0.1. <br>MirrorSync will not be able to work correctly until this is fixed. Would you like to proceed with installation anyway?</html>", "Web Server is not running", 2);
                if (choice != 2) break block8;
                throw new UserCanceledException();
            }
        }
    }

    protected void installNoUI() throws FileMakerConfigurationException, IOException {
        Frame rootFrame = JOptionPane.getRootFrame();
        final JDialog progressDialog = DefaultInstaller.dialogForMessage(rootFrame, "This may take a moment, you'll see a message here when the install is complete.", "Installing " + this.getProductTitle());
        Runnable installTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    File confDir = new File(utils.getTomcatDir(), "conf");
                    File loggingPropertiesFile = new File(confDir, "logging.properties");
                    if (!loggingPropertiesFile.exists()) {
                        File srcFile = new File("logging.properties");
                        if (!srcFile.exists()) throw new IOException("Could not copy logging.properties file because it is missing from the installer data directory.");
                        log.info("Logging setup: Copying " + srcFile.getAbsolutePath() + " to " + loggingPropertiesFile.getAbsolutePath());
                        IOUtils.copyFile(srcFile, loggingPropertiesFile);
                    } else {
                        log.info("Logging properties file already exists at " + loggingPropertiesFile);
                    }
                    log.info("Writing " + DefaultInstaller.this.getProductTitle() + " info to Tomcat config file at " + utils.getJKFile());
                    utils.writeJKMounts(DefaultInstaller.this.mountPoints, true);
                    DefaultInstaller.this.deleteServletDir();
                    log.log(Level.INFO, "Copying " + DefaultInstaller.this.getProductTitle() + " to WebApps");
                    utils.copyDirectory(DefaultInstaller.this.installationWarFile, new File(utils.getWebApps(), DefaultInstaller.this.installationWarFile.getName()));
                    try {
                        utils.restartWebServer();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Could not restart web server", e);
                        DefaultInstaller.this.restartFailed = true;
                    }
                }
                catch (Exception e) {
                    try {
                        DefaultInstaller.this.workerException = e;
                    }
                    catch (Throwable throwable) {
                        DefaultInstaller.this.finished = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressDialog.setVisible(false);
                            }
                        });
                        throw throwable;
                    }
                    DefaultInstaller.this.finished = true;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                DefaultInstaller.this.finished = true;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
        };
        Thread workerThread = new Thread(installTask);
        workerThread.start();
        progressDialog.setVisible(true);
        if (!this.finished) {
            workerThread.interrupt();
            throw new RuntimeException("Installation was cancelled. Your " + this.getProductTitle() + " installation may be in a corrupt state, either complete the install or uninstall " + this.getProductTitle() + ".");
        }
        if (this.workerException != null) {
            if (this.workerException instanceof FileMakerConfigurationException) {
                throw (FileMakerConfigurationException)this.workerException;
            }
            if (this.workerException instanceof IOException) {
                throw (IOException)this.workerException;
            }
            throw new RuntimeException(this.workerException);
        }
        if (this.restartFailed) {
            JOptionPane.showMessageDialog(rootFrame, this.getProductTitle() + " was installed successfully, but the web server could not be restarted. You will need to restart it yourself, or restart the computer.");
        }
    }

    private void postInstallUI() {
    }

    @Override
    public void runUninstaller() throws FileMakerConfigurationException, IOException {
        if (this.isInstalled()) {
            log.log(Level.INFO, "Removing " + this.getProductTitle() + "...");
            File warFile = new File(utils.getWebApps(), this.installationWarFile.getName());
            if (warFile.exists() && !IOUtils.deleteRecursive(warFile)) {
                throw new IOException("Can't delete the previous version at " + warFile.getAbsolutePath() + ", please make sure you are logged in with an administrative account.");
            }
            this.deleteServletDir();
            utils.writeJKMounts(this.mountPoints, false);
            log.log(Level.INFO, "Done removing " + this.getProductTitle() + ".");
        }
    }

    private void deleteServletDir() throws FileMakerConfigurationException, IOException {
        File webDir;
        if (this.isInstalled() && (webDir = new File(utils.getWebApps(), this.getServletName())).exists() && !IOUtils.deleteRecursive(webDir)) {
            throw new IOException("Can't delete " + webDir.getAbsolutePath() + ". Try stopping the Web Publishing Engine during installation.");
        }
    }

    private static JDialog dialogForMessage(Component parentComponent, String dialogMessage, String dialogTitle) {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JComponent[] message = new JComponent[]{new JLabel(dialogMessage), progressBar};
        Object[] options = new Object[]{"Cancel"};
        return new JOptionPane(message, 1, 0, null, options).createDialog(parentComponent, dialogTitle);
    }
}

