/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.FileMakerConfigurationException;
import java.io.IOException;

public abstract class AbstractInstaller {
    public boolean canRemove() throws FileMakerConfigurationException, IOException {
        return this.isInstalled();
    }

    public abstract boolean isInstalled() throws FileMakerConfigurationException, IOException;

    public abstract void runInstaller() throws FileMakerConfigurationException, IOException, UserCanceledException;

    public abstract void runUninstaller() throws FileMakerConfigurationException, IOException;

    public abstract String getInstallInstructions();

    public abstract String getSuccessMessage();

    public abstract String getUninstallMessage();

    public String getVersionInfo() {
        String versionNumber = this.getClass().getPackage().getImplementationVersion();
        if (versionNumber != null) {
            return "Version " + versionNumber;
        }
        return null;
    }

    public void checkConfiguration() throws Exception {
    }

    public abstract String getProductTitle();
}

