/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.sqs.SQSRequest;
import com.prosc.aws.sqs.SendMessageResult;
import com.prosc.security.EncryptionUtils;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class SendMessage
extends SQSRequest {
    private final byte[] messageBodyMd5;
    private int attributeCount = 0;

    public SendMessage(Signer signer, boolean encrypt, @NotNull String queueUrl, @NotNull String messageBody) {
        super(signer, encrypt, queueUrl);
        if (StringUtils.isEmpty(messageBody)) {
            throw new IllegalArgumentException("Simple Queue Service requires a non-empty message body.");
        }
        this.setQueryParam("Action", "SendMessage");
        this.setPostParam("MessageBody", messageBody);
        this.messageBodyMd5 = EncryptionUtils.generateMD5Hash(messageBody.getBytes(StandardCharsets.UTF_8));
    }

    public SendMessage setDelaySeconds(int delaySeconds) {
        this.setQueryParam("DelaySeconds", String.valueOf(delaySeconds));
        return this;
    }

    public SendMessage setMessageAttribute(String name, String value) {
        this.setMessageAttribute(name, value, "String");
        return this;
    }

    public SendMessage setMessageAttribute(String name, double value) {
        this.setMessageAttribute(name, String.valueOf(value), "Number");
        return this;
    }

    public SendMessage setMessageAttribute(String name, Number value) {
        this.setMessageAttribute(name, String.valueOf(value), "Number");
        return this;
    }

    public SendMessage setMessageAttribute(String name, byte[] value) {
        String encodedValue = Base64.getEncoder().encodeToString(value);
        this.setMessageAttribute(name, encodedValue, "Binary");
        return this;
    }

    public void setMessageAttribute(String name, String rawValue, String customTypeName) {
        if (rawValue != null && rawValue.length() != 0) {
            ++this.attributeCount;
            this.setQueryParam("MessageAttribute." + this.attributeCount + ".Name", name);
            this.setQueryParam("MessageAttribute." + this.attributeCount + ".Value.DataType", customTypeName);
            if (customTypeName.startsWith("Binary")) {
                this.setPostParam("MessageAttribute." + this.attributeCount + ".Value.BinaryValue", rawValue);
            } else {
                this.setPostParam("MessageAttribute." + this.attributeCount + ".Value.StringValue", rawValue);
            }
        }
    }

    public SendMessageResult call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        awsResult.validate();
        SendMessageResult sendMessageResult = new SendMessageResult((Element)awsResult.getDocument().getElementsByTagName("SendMessageResult").item(0));
        String messageBodyMd5String = EncryptionUtils.toHex(this.messageBodyMd5);
        if (!messageBodyMd5String.equals(sendMessageResult.getMd5OfMessageBody())) {
            throw new IOException("MD5 of local message (" + messageBodyMd5String + ") does not match MD5 of AWS queued message (" + sendMessageResult.getMd5OfMessageBody() + ")");
        }
        return sendMessageResult;
    }
}

