/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.xml.DomUtils;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Message {
    private static final Logger log = Logger.getLogger(Message.class.getName());
    private final String messageId;
    private final String receiptHandle;
    private final String md5OfBody;
    private final String body;
    private final String senderId;
    private final Date sentTimestamp;
    private final Date approximateFirstReceiveTimestamp;
    private final Integer approximateReceiveCount;
    private final Map<String, AttributeValue> messageAttributes = new HashMap<String, AttributeValue>();

    Message(Element messageElement) {
        this.messageId = DomUtils.getChildText(messageElement, "MessageId");
        this.receiptHandle = DomUtils.getChildText(messageElement, "ReceiptHandle");
        this.md5OfBody = DomUtils.getChildText(messageElement, "MD5OfBody");
        this.body = DomUtils.getChildText(messageElement, "Body");
        String _senderId = null;
        Date _sentTimestamp = null;
        Date _approximateFirstReceiveTimestamp = null;
        Integer _approximateReceiveCount = null;
        NodeList attributes = messageElement.getElementsByTagName("Attribute");
        for (int n = 0; n < attributes.getLength(); ++n) {
            Element attributeElement = (Element)attributes.item(n);
            String name = DomUtils.getChildText(attributeElement, "Name");
            String value = DomUtils.getChildText(attributeElement, "Value");
            if ("SenderId".equals(name)) {
                _senderId = value;
                continue;
            }
            if ("SentTimestamp".equals(name)) {
                _sentTimestamp = new Date(Long.valueOf(value));
                continue;
            }
            if ("ApproximateReceiveCount".equals(name)) {
                _approximateReceiveCount = Integer.valueOf(value);
                continue;
            }
            if ("ApproximateFirstReceiveTimestamp".equals(name)) {
                _approximateFirstReceiveTimestamp = new Date(Long.valueOf(value));
                continue;
            }
            System.out.println("Unknown attribute: " + name + " / " + value);
        }
        NodeList messageAttributeNodes = messageElement.getElementsByTagName("MessageAttribute");
        for (int n = 0; n < messageAttributeNodes.getLength(); ++n) {
            Element attributeElement = (Element)messageAttributeNodes.item(n);
            String name = DomUtils.getChildText(attributeElement, "Name");
            Element value = (Element)attributeElement.getElementsByTagName("Value").item(0);
            AttributeValue attributeValue = new AttributeValue();
            attributeValue.dataType = DomUtils.getChildText(value, "DataType");
            if (attributeValue.dataType.startsWith("Binary")) {
                String base64 = DomUtils.getChildText(value, "BinaryValue");
                AttributeValue.access$102(attributeValue, Base64.getDecoder().decode(base64));
            } else {
                attributeValue.stringData = DomUtils.getChildText(value, "StringValue");
            }
            this.messageAttributes.put(name, attributeValue);
        }
        this.senderId = _senderId;
        this.sentTimestamp = _sentTimestamp;
        this.approximateFirstReceiveTimestamp = _approximateFirstReceiveTimestamp;
        this.approximateReceiveCount = _approximateReceiveCount;
    }

    public String getMessageId() {
        return this.messageId;
    }

    String getReceiptHandle() {
        return this.receiptHandle;
    }

    public String getMd5OfBody() {
        return this.md5OfBody;
    }

    public String getBody() {
        return this.body;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public Date getSentTimestamp() {
        return this.sentTimestamp;
    }

    public Date getApproximateFirstReceiveTimestamp() {
        return this.approximateFirstReceiveTimestamp;
    }

    public Integer getApproximateReceiveCount() {
        return this.approximateReceiveCount;
    }

    public Map<String, AttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public String getMessageAttributeStringData(String name) {
        AttributeValue value = this.messageAttributes.get(name);
        if (value == null) {
            return null;
        }
        return value.getStringData();
    }

    public Number getMessageAttributeNumberData(String name) {
        AttributeValue value = this.messageAttributes.get(name);
        if (value == null) {
            return null;
        }
        return value.getNumberData();
    }

    public byte[] getMessageAttributeBinaryData(String name) {
        AttributeValue value = this.messageAttributes.get(name);
        if (value == null) {
            return null;
        }
        return value.getBinaryData();
    }

    public String toString() {
        String bodyTruncated = this.body;
        if (bodyTruncated.length() > 256) {
            bodyTruncated = bodyTruncated.substring(0, 256) + "...";
        }
        return "Message{messageId='" + this.messageId + '\'' + ", body='" + bodyTruncated + '\'' + ", senderId='" + this.senderId + '\'' + ", sentTimestamp=" + this.sentTimestamp + ", approximateFirstReceiveTimestamp=" + this.approximateFirstReceiveTimestamp + ", approximateReceiveCount=" + this.approximateReceiveCount + ", messageAttributes=" + this.messageAttributes + '}';
    }

    public static class AttributeValue {
        private String dataType;
        private byte[] binaryData;
        private String stringData;

        public String getDataType() {
            return this.dataType;
        }

        public byte[] getBinaryData() {
            return this.binaryData;
        }

        public String getStringData() {
            return this.stringData;
        }

        public Number getNumberData() {
            return new BigDecimal(this.stringData);
        }

        public Object getData() {
            if (this.dataType.startsWith("Number")) {
                return this.getNumberData();
            }
            if (this.dataType.startsWith("Binary")) {
                return this.binaryData;
            }
            return this.stringData;
        }

        public String toString() {
            return "AttributeValue{" + String.valueOf(this.getData()) + '}';
        }

        static /* synthetic */ byte[] access$102(AttributeValue x0, byte[] x1) {
            x0.binaryData = x1;
            return x1;
        }
    }
}

