/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.QueueDoesNotExistException;
import com.prosc.aws.sqs.SQSRequest;
import java.io.IOException;

public class GetQueueUrl
extends SQSRequest {
    public GetQueueUrl(Signer signer, boolean encrypt, String queueName) {
        super(signer, encrypt);
        this.setQueryParam("Action", "GetQueueUrl");
        this.setQueryParam("QueueName", queueName);
    }

    public GetQueueUrl setQueueOwnerAWSAccountId(String accountId) {
        this.setQueryParam("QueueOwnerAWSAccountId", accountId);
        return this;
    }

    public String call() throws IOException, QueueDoesNotExistException {
        AwsResult awsResult = this.sendWithRetry();
        QueueDoesNotExistException.check(awsResult);
        awsResult.validate();
        return awsResult.getDocument().getElementsByTagName("QueueUrl").item(0).getTextContent();
    }
}

