/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.sqs.SQSRequest;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetQueueAttributes
extends SQSRequest {
    public GetQueueAttributes(@Nullable Signer signer, boolean encrypt, String queueUrl) {
        super(signer, encrypt, queueUrl);
        this.setQueryParam("Action", "GetQueueAttributes");
        this.setQueryParam("AttributeName.1", "All");
    }

    public Map<String, String> call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        awsResult.validate();
        Node getQueueAttributesResult = awsResult.getDocument().getDocumentElement().getElementsByTagName("GetQueueAttributesResult").item(0);
        if (getQueueAttributesResult == null) {
            return Collections.emptyMap();
        }
        NodeList nodeList = getQueueAttributesResult.getChildNodes();
        HashMap<String, String> result = new HashMap<String, String>(nodeList.getLength());
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node item = nodeList.item(n);
            if (!(item instanceof Element)) continue;
            String name = DomUtils.getChildText((Element)item, "Name");
            String value = DomUtils.getChildText((Element)item, "Value");
            result.put(name, value);
        }
        return result;
    }
}

