/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sqs;

import com.prosc.aws.Signer;
import com.prosc.aws.sqs.Message;
import com.prosc.aws.sqs.SQSRequest;
import java.io.IOException;
import java.util.List;

public class DeleteMessageBatch
extends SQSRequest {
    private final List<Message> messagesToDelete;

    public DeleteMessageBatch(Signer signer, boolean encrypt, String queueUrl, List<Message> messagesToDelete) {
        super(signer, encrypt, queueUrl);
        this.messagesToDelete = messagesToDelete;
    }

    public void call() throws IOException {
        int index = 0;
        int batchIndex = 0;
        int allCount = this.messagesToDelete.size();
        for (Message message : this.messagesToDelete) {
            this.setQueryParam("DeleteMessageBatchRequestEntry." + ++batchIndex + ".Id", message.getMessageId());
            this.setQueryParam("DeleteMessageBatchRequestEntry." + batchIndex + ".ReceiptHandle", message.getReceiptHandle());
            if (batchIndex != 10 && ++index != allCount) continue;
            this.setQueryParam("Version", "2012-11-05");
            this.setQueryParam("Action", "DeleteMessageBatch");
            this.sendWithRetry().validate();
            this.clearAllParams();
            batchIndex = 0;
        }
    }
}

