/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.Signer;
import com.prosc.xml.DomUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class User {
    private final String userId;
    private final String path;
    private final String userName;
    private final String arn;
    private final Date createDate;
    private final Date passwordLastUsed;

    User(Element xml) {
        this.userId = DomUtils.getChildText(xml, "UserId");
        this.path = DomUtils.getChildText(xml, "Path");
        this.userName = DomUtils.getChildText(xml, "UserName");
        this.arn = DomUtils.getChildText(xml, "Arn");
        String createDateString = DomUtils.getChildText(xml, "CreateDate");
        this.createDate = createDateString == null ? null : Signer.parseDateTime(createDateString);
        String passwordLastUsedString = DomUtils.getChildText(xml, "PasswordLastUsed");
        this.passwordLastUsed = passwordLastUsedString == null ? null : Signer.parseDateTime(passwordLastUsedString);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getArn() {
        return this.arn;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getPasswordLastUsed() {
        return this.passwordLastUsed;
    }

    public String toString() {
        return "User{userId='" + this.userId + '\'' + ", path='" + this.path + '\'' + ", userName='" + this.userName + '\'' + ", arn='" + this.arn + '\'' + ", createDate=" + this.createDate + ", passwordLastUsed=" + this.passwordLastUsed + '}';
    }
}

