/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.iam.AttachedPolicy;
import com.prosc.aws.iam.IamRequest;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListAttachedRolePoliciesRequest
extends IamRequest {
    public ListAttachedRolePoliciesRequest(@NotNull Signer signer, @NotNull String roleName) {
        super(signer);
        this.setQueryParam("Action", "ListAttachedRolePolicies");
        this.setQueryParam("RoleName", roleName);
    }

    public List<AttachedPolicy> call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        awsResult.validate();
        Element attachedPolicies = (Element)awsResult.getDocument().getElementsByTagName("AttachedPolicies").item(0);
        Iterable<Element> attachments = DomUtils.getChildElements((Node)attachedPolicies, "member");
        LinkedList<AttachedPolicy> result = new LinkedList<AttachedPolicy>();
        for (Element attachment : attachments) {
            result.add(new AttachedPolicy(attachment));
        }
        return result;
    }
}

