/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.iam.AssumeRoleResult;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

public class AssumeRole
extends AwsRequest<AssumeRole> {
    public AssumeRole(@Nullable Signer signer, String roleArnToAssume, String sessionIdentifier) {
        super(signer);
        this.setPostParam("Version", "2011-06-15");
        this.setPostParam("Action", "AssumeRole");
        this.setPostParam("RoleSessionName", sessionIdentifier);
        this.setPostParam("RoleArn", roleArnToAssume);
    }

    public AssumeRole setDurationSeconds(int durationSeconds) {
        if (durationSeconds < 900 || durationSeconds > 43200) {
            throw new IllegalArgumentException("DurationSeconds must be between 900 and 43,200, inclusive.");
        }
        this.setPostParam("DurationSeconds", String.valueOf(durationSeconds));
        return this;
    }

    public AssumeRole setExternalId(String externalId) {
        StringUtils.validateLength("ExternalId", externalId, 2, 1224);
        this.setPostParam("ExternalId", externalId);
        return this;
    }

    public AssumeRole setPolicy(String policy) {
        StringUtils.validateLength("Policy", policy, null, 2048);
        this.setPostParam("Policy", policy);
        return this;
    }

    public AssumeRole setSerialNumber(String serialNumber) {
        StringUtils.validateLength("SerialNumber", serialNumber, 9, 256);
        this.setPostParam("SerialNumber", serialNumber);
        return this;
    }

    public AssumeRole setTokenCode(String tokenCode) {
        StringUtils.validateLength("TokenCode", tokenCode, 6, 6);
        this.setPostParam("TokenCode", tokenCode);
        return this;
    }

    public AssumeRoleResult call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        awsResult.validate();
        return new AssumeRoleResult(awsResult.getDocument());
    }

    @Override
    protected AwsResult _send(String nextToken) throws IOException {
        URL endpoint = new URL("https", "sts.amazonaws.com", "");
        return this.defaultSend(endpoint, "sts", ResponseStyle.xml, ResponseStyle.xml);
    }
}

