/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.aws.exception.ServerClockMismatchException;
import com.prosc.shared.StringUtils;
import com.prosc.xml.DomUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccessDeniedException
extends AWSRuntimeException {
    private static final Logger log = Logger.getLogger(AccessDeniedException.class.getName());

    public AccessDeniedException(int responseCode, @Nullable String errorCode, String errorMessage, @Nullable Document parsedXml, AwsRequest<?> request) {
        super(responseCode, errorCode, errorMessage + " / accessKey " + request.getSigner().getAccessKey(), parsedXml, request);
        if (parsedXml != null) {
            Iterator<Element> iterator = DomUtils.getChildElements((Node)parsedXml.getDocumentElement(), "CanonicalRequest").iterator();
            if (iterator.hasNext()) {
                String awsCanonicalRequest = iterator.next().getTextContent();
                String proscCanonicalRequest = Optional.ofNullable(request.getSigningResult()).map(signingResult -> signingResult.canonicalString).orElse("");
                if (!(StringUtils.isEmpty(proscCanonicalRequest) || StringUtils.isEmpty(awsCanonicalRequest) || proscCanonicalRequest.equals(awsCanonicalRequest))) {
                    log.log(Level.WARNING, "Canonical requests do not match.\nAWS-generated request: " + awsCanonicalRequest + "\nProsc-generated request: " + proscCanonicalRequest);
                }
            } else if ("AccessDenied".equals(errorCode)) {
                log.log(Level.WARNING, "No canonical request was returned by AWS, so there is no way to compare the requests. Raw result:\n" + DomUtils.dumpXml(parsedXml.getDocumentElement()));
            }
        }
    }

    private AccessDeniedException(int responseCode, String errorMessage, AwsRequest<?> request) {
        this(responseCode, (String)null, errorMessage, (Document)null, request);
    }

    public static void check(@NotNull AwsResult awsResult, AwsRequest<?> request) {
        AWSRuntimeException exception = null;
        if ("AccessDenied".equals(awsResult.getErrorCode()) || "InvalidAccessKeyId".equals(awsResult.getErrorCode())) {
            exception = new AccessDeniedException(awsResult.getHttpStatusCode(), awsResult.getErrorCode(), awsResult.getErrorCode(), awsResult.getDocument(), request);
        } else if ("The security token included in the request is invalid.".equals(awsResult.getErrorCode())) {
            exception = new AccessDeniedException(awsResult.getHttpStatusCode(), "InvalidAccessKeyId", awsResult.getErrorCode(), awsResult.getDocument(), request);
        } else if (awsResult.getHttpStatusCode() == 403) {
            String file = awsResult.getUrlConnection().getURL().getFile();
            if (awsResult.getDocument() == null) {
                String message = awsResult.getResponseAsString();
                if (StringUtils.isEmpty(message)) {
                    message = StringUtils.isEmpty(file) ? "" : file.substring(1);
                }
                exception = new AccessDeniedException(awsResult.getHttpStatusCode(), message, request);
            } else {
                String message = DomUtils.getRecursiveChildText(awsResult.getDocument().getDocumentElement(), "Message");
                if (awsResult.getErrorStyle() == ResponseStyle.xml && awsResult.getDocument() != null && message != null && message.toLowerCase().contains("signature expired")) {
                    exception = new ServerClockMismatchException(awsResult.getHttpStatusCode(), awsResult.getDocument(), request);
                }
                if (exception == null) {
                    exception = new AccessDeniedException(403, awsResult.getErrorCode(), message, awsResult.getDocument(), request);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

