/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsRequest;
import com.prosc.xml.DomUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class AWSRuntimeException
extends RuntimeException {
    private final String accessKey;
    private String message;
    private final String type;
    private final String code;
    private final String requestId;
    private final Integer responseCode;
    private final Document parsedXml;

    public AWSRuntimeException(String errorMessage) {
        this(errorMessage, (Document)null);
    }

    public AWSRuntimeException(String errorMessage, Document parsedXml) {
        this(null, null, errorMessage, parsedXml, null);
    }

    public AWSRuntimeException(int responseCode, @NotNull Document parsedXml, AwsRequest<?> request) {
        this(responseCode, null, null, parsedXml, request);
    }

    public AWSRuntimeException(int responseCode, String code, AwsRequest<?> request) {
        this(responseCode, code, null, request);
    }

    public AWSRuntimeException(int responseCode, String code, String errorMessage, AwsRequest<?> request) {
        this(responseCode, code, errorMessage, null, request);
    }

    public AWSRuntimeException(@Nullable Integer responseCode, @Nullable String code, @Nullable String errorMessage, @Nullable Document parsedXml, @Nullable AwsRequest<?> request) {
        if (parsedXml == null) {
            this.type = null;
            this.requestId = null;
            this.code = code;
        } else {
            Element xml = parsedXml.getDocumentElement();
            this.code = code == null ? DomUtils.getRecursiveChildText(xml, "Code") : code;
            this.type = DomUtils.getRecursiveChildText(xml, "Type");
            this.requestId = DomUtils.getRecursiveChildText(xml, "RequestId");
            if (errorMessage == null) {
                errorMessage = DomUtils.getRecursiveChildText(xml, "Message");
            }
        }
        this.responseCode = responseCode;
        this.parsedXml = parsedXml;
        if (request == null) {
            this.message = errorMessage;
            this.accessKey = null;
        } else {
            this.message = errorMessage == null ? "HTTP error code " + responseCode + " for request " + request.toString() : request.toString() + ": " + errorMessage;
            this.accessKey = request.getSigner() == null ? null : request.getSigner().getAccessKey();
        }
    }

    public boolean isRetry() {
        return false;
    }

    @Override
    public String getMessage() {
        if (this.getClass() == AWSRuntimeException.class && this.parsedXml != null) {
            return this.getXmlResponse();
        }
        return this.message;
    }

    public String getMessagePlainText() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getXmlResponse() {
        if (this.parsedXml == null) {
            return null;
        }
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)this.parsedXml.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(this.parsedXml);
    }

    public Document getParsedXml() {
        return this.parsedXml;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getAccessKey() {
        return this.accessKey;
    }
}

